/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public final class SrmGroupEvaplanSumCalculateOp
extends AbstractOperationServicePlugIn {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("billdate");
        e.getFieldKeys().add("finishdate");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("scheme");
        e.getFieldKeys().add("grade");
        e.getFieldKeys().add("compsumcalculate");
        e.getFieldKeys().add("avgcal");
        e.getFieldKeys().add("evaorg");
        e.getFieldKeys().add("orgweight");
        e.getFieldKeys().add("category");
        e.getFieldKeys().add("terminatecaltype");
        e.getFieldKeys().add("entryentity1.evaorg");
        e.getFieldKeys().add("entryentity1.evaperson");
        e.getFieldKeys().add("entryentity1.orgweight");
        e.getFieldKeys().add("entryentity.supplier");
        e.getFieldKeys().add("subentryentity.material");
        e.getFieldKeys().add("groupgrade");
        e.getFieldKeys().add("type");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject curGroupEvaPlan = dataEntities[0];
        boolean avgcal = curGroupEvaPlan.getBoolean("avgcal");
        if (avgcal) {
            this.avgCalScoreAndCreateGroupRpt(curGroupEvaPlan);
        } else {
            this.orgWeightCalScoreAndCreateGroupRpt(curGroupEvaPlan);
        }
    }

    private void avgCalScoreAndCreateGroupRpt(DynamicObject curGroupEvaPlan) {
        long groupevaplanId = curGroupEvaPlan.getLong("id");
        String type = curGroupEvaPlan.getString("type");
        DynamicObjectCollection srm_scorerpt = this.getScoreRpt(groupevaplanId);
        Set<String> evaDimension = this.getEvaDimension(srm_scorerpt);
        for (String dimension : evaDimension) {
            String[] split = dimension.split("-");
            long supplierId = Long.parseLong(split[0]);
            long categoryId = Long.parseLong(split[1]);
            long materialId = Long.parseLong(split[2]);
            long schemeId = Long.parseLong(split[3]);
            BigDecimal score = new BigDecimal("0");
            HashSet<Long> scorerptIds = new HashSet<Long>(16);
            int evaOrgSum = 0;
            for (DynamicObject scorerpt : srm_scorerpt) {
                long supplier = scorerpt.getLong("supplier");
                long category = scorerpt.getLong("category");
                long material = scorerpt.getLong("material");
                long scheme = scorerpt.getLong("scheme");
                if (supplier != supplierId || category != categoryId || material != materialId || scheme != schemeId) continue;
                long scorerptId = scorerpt.getLong("id");
                scorerptIds.add(scorerptId);
                BigDecimal sumscore = scorerpt.getBigDecimal("sumscore");
                score = score.add(sumscore);
                ++evaOrgSum;
            }
            score = score.divide(new BigDecimal(evaOrgSum), 2, 5);
            this.createGroupEvaScorerpt(scorerptIds, curGroupEvaPlan, type, score, supplierId, categoryId, materialId);
            curGroupEvaPlan.set("compsumcalculate", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curGroupEvaPlan});
        }
    }

    private void orgWeightCalScoreAndCreateGroupRpt(DynamicObject curGroupEvaPlan) {
        long groupevaplanId = curGroupEvaPlan.getLong("id");
        String type = curGroupEvaPlan.getString("type");
        String terminatecaltype = curGroupEvaPlan.getString("terminatecaltype");
        DynamicObjectCollection orgEntry = curGroupEvaPlan.getDynamicObjectCollection("entryentity1");
        HashMap<Long, BigDecimal> weightMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject orgEntryRow : orgEntry) {
            long evaOrgId = orgEntryRow.getLong("evaorg.id");
            BigDecimal orgweight = orgEntryRow.getBigDecimal("orgweight");
            weightMap.put(evaOrgId, orgweight);
        }
        DynamicObjectCollection srm_scorerpt = this.getScoreRpt(groupevaplanId);
        Set<String> evaDimension = this.getEvaDimension(srm_scorerpt);
        for (String dimension : evaDimension) {
            BigDecimal curOrgWeight;
            BigDecimal sumscore;
            long scorerptId;
            String[] split = dimension.split("-");
            long supplierId = Long.parseLong(split[0]);
            long categoryId = Long.parseLong(split[1]);
            long materialId = Long.parseLong(split[2]);
            long schemeId = Long.parseLong(split[3]);
            BigDecimal score = new BigDecimal("0");
            BigDecimal allWeight = new BigDecimal(100);
            HashSet<Long> scorerptIds = new HashSet<Long>(16);
            int evaOrgSum = 0;
            for (DynamicObject scorerpt : srm_scorerpt) {
                long supplier = scorerpt.getLong("supplier");
                long category = scorerpt.getLong("category");
                long material = scorerpt.getLong("material");
                long scheme = scorerpt.getLong("scheme");
                long rptOrgId = scorerpt.getLong("org");
                if (supplier != supplierId || category != categoryId || material != materialId || scheme != schemeId) continue;
                BigDecimal rptOrgWeight = (BigDecimal)weightMap.get(rptOrgId);
                allWeight = allWeight.subtract(rptOrgWeight);
                ++evaOrgSum;
                scorerptId = scorerpt.getLong("id");
                scorerptIds.add(scorerptId);
                sumscore = scorerpt.getBigDecimal("sumscore");
                curOrgWeight = (BigDecimal)weightMap.get(rptOrgId);
                score = score.add(sumscore.multiply(curOrgWeight).divide(new BigDecimal(100), 2, 5));
            }
            if (!"3".equals(terminatecaltype) && allWeight.compareTo(new BigDecimal(0)) != 0) {
                scorerptIds.clear();
                score = new BigDecimal(0);
                BigDecimal subtract = new BigDecimal(100).subtract(allWeight);
                for (DynamicObject scorerpt : srm_scorerpt) {
                    long supplier = scorerpt.getLong("supplier");
                    long category = scorerpt.getLong("category");
                    long material = scorerpt.getLong("material");
                    long scheme = scorerpt.getLong("scheme");
                    long rptOrgId = scorerpt.getLong("org");
                    if (supplier != supplierId || category != categoryId || material != materialId || scheme != schemeId) continue;
                    scorerptId = scorerpt.getLong("id");
                    scorerptIds.add(scorerptId);
                    sumscore = scorerpt.getBigDecimal("sumscore");
                    curOrgWeight = (BigDecimal)weightMap.get(rptOrgId);
                    if (terminatecaltype.equals("1")) {
                        curOrgWeight = curOrgWeight.add(allWeight.multiply(curOrgWeight.divide(subtract, 2, 5)));
                    } else if (terminatecaltype.equals("2")) {
                        curOrgWeight = curOrgWeight.add(allWeight.divide(new BigDecimal(evaOrgSum), 2, 5));
                    }
                    score = score.add(sumscore.multiply(curOrgWeight).divide(new BigDecimal(100), 2, 5));
                }
            }
            this.createGroupEvaScorerpt(scorerptIds, curGroupEvaPlan, type, score, supplierId, categoryId, materialId);
            curGroupEvaPlan.set("compsumcalculate", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curGroupEvaPlan});
        }
    }

    private DynamicObjectCollection getScoreRpt(long groupevaplanId) {
        DynamicObjectCollection srm_evaplan = QueryServiceHelper.query((String)"srm_evaplan", (String)"id", (QFilter[])new QFilter[]{new QFilter("groupevaplanno", "=", (Object)groupevaplanId).and("bizstatus", "!=", (Object)"Z")});
        if (srm_evaplan == null || srm_evaplan.isEmpty()) {
            srm_evaplan = QueryServiceHelper.query((String)"srm_evaplan_batch", (String)"id", (QFilter[])new QFilter[]{new QFilter("groupevaplanno", "=", (Object)groupevaplanId).and("bizstatus", "!=", (Object)"Z")});
        }
        HashSet<Long> idSet = new HashSet<Long>(8);
        for (DynamicObject data : srm_evaplan) {
            long id = data.getLong("id");
            idSet.add(id);
        }
        DynamicObjectCollection srm_scorerpt = QueryServiceHelper.query((String)"srm_scorerpt", (String)"id,org,supplier,category,material,scheme,grade,sumscore", (QFilter[])new QFilter[]{new QFilter("taskbillid", "in", idSet).and("bizstatus", "=", (Object)"G")});
        return srm_scorerpt;
    }

    private Set<String> getEvaDimension(DynamicObjectCollection srm_scorerpt) {
        HashSet<String> evaDimension = new HashSet<String>(16);
        for (DynamicObject scorerpt : srm_scorerpt) {
            String supplier = scorerpt.getString("supplier");
            String category = scorerpt.getString("category");
            String material = scorerpt.getString("material");
            String scheme = scorerpt.getString("scheme");
            String dimension = supplier + "-" + category + "-" + material + "-" + scheme;
            evaDimension.add(dimension);
        }
        return evaDimension;
    }

    private void createGroupEvaScorerpt(Set<Long> scorerptIds, DynamicObject groupEvaplan, String type, BigDecimal score, long supplierId, long categoryId, long materialId) {
        DynamicObject groupscorerpt = BusinessDataServiceHelper.newDynamicObject((String)"srm_groupscorerpt");
        long id = groupEvaplan.getLong("id");
        long org = groupEvaplan.getLong("org.id");
        String billno = groupEvaplan.getString("billno");
        String name = groupEvaplan.getString("name");
        Date billdate = groupEvaplan.getDate("billdate");
        Date finishdate = groupEvaplan.getDate("finishdate");
        boolean avgcal = groupEvaplan.getBoolean("avgcal");
        String terminatecaltype = groupEvaplan.getString("terminatecaltype");
        DynamicObject scheme = groupEvaplan.getDynamicObject("scheme");
        DynamicObject grade = null;
        grade = "1".equals(type) || "2".equals(type) ? groupEvaplan.getDynamicObject("grade") : groupEvaplan.getDynamicObject("groupgrade");
        groupscorerpt.set("org", (Object)org);
        groupscorerpt.set("groupevaplanno", (Object)billno);
        groupscorerpt.set("name", (Object)name);
        groupscorerpt.set("billstatus", (Object)"A");
        groupscorerpt.set("billdate", (Object)billdate);
        groupscorerpt.set("plandate", (Object)finishdate);
        groupscorerpt.set("supplier", (Object)supplierId);
        groupscorerpt.set("category", (Object)categoryId);
        groupscorerpt.set("material", (Object)materialId);
        groupscorerpt.set("groupsumscore", (Object)score);
        groupscorerpt.set("avgcal", (Object)avgcal);
        groupscorerpt.set("terminatecaltype", (Object)terminatecaltype);
        groupscorerpt.set("creator", (Object)RequestContext.get().getCurrUserId());
        long groupGrade = 0L;
        if (grade != null) {
            groupGrade = this.getGroupGrade(score, grade);
            groupscorerpt.set("groupevagrade", (Object)groupGrade);
        }
        DynamicObjectCollection entryentity = groupscorerpt.getDynamicObjectCollection("entryentity");
        for (Long scorerpt : scorerptIds) {
            DynamicObject newRow = entryentity.addNew();
            newRow.set("scorerptno", (Object)scorerpt);
            if (avgcal) continue;
            this.setEvaOrgWeight(newRow, id, scorerpt);
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"srm_groupscorerpt", (DynamicObject[])new DynamicObject[]{groupscorerpt}, null);
        if (!operationResult.isSuccess()) {
            this.log.info("\u751f\u6210\u96c6\u56e2\u8bc4\u4f30\u62a5\u544a\u5931\u8d25\uff1asupplierId[" + supplierId + "],categoryId[" + categoryId + "],materialId[" + materialId + "]@" + operationResult.getAllErrorOrValidateInfo() + operationResult.getMessage());
        } else if (groupGrade != 0L) {
            String rptBillno = groupscorerpt.getString("billno");
            if ("1".equals(type) || "2".equals(type)) {
                boolean synsupgrade;
                if (scheme != null && (synsupgrade = scheme.getBoolean("synsupgrade"))) {
                    this.updateGroupGrade(billno, rptBillno, groupGrade, org, supplierId, categoryId, materialId);
                }
            } else {
                this.updateGroupGrade(billno, rptBillno, groupGrade, org, supplierId, categoryId, materialId);
            }
        }
    }

    private void setEvaOrgWeight(DynamicObject newRow, Long groupEvaPlanId, Long scorerpt) {
        DynamicObject srm_scorerpt = QueryServiceHelper.queryOne((String)"srm_scorerpt", (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)scorerpt)});
        long scoreRptOrgId = srm_scorerpt.getLong("org");
        DynamicObject srm_groupevaplan = QueryServiceHelper.queryOne((String)"srm_groupevaplan", (String)"id,entryentity1.evaorg,entryentity1.orgweight", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)groupEvaPlanId).and("entryentity1.evaorg", "=", (Object)scoreRptOrgId)});
        BigDecimal orgweight = srm_groupevaplan.getBigDecimal("entryentity1.orgweight");
        newRow.set("orgweight", (Object)orgweight);
    }

    private long getGroupGrade(BigDecimal score, DynamicObject grade) {
        long gradeId = grade.getLong("id");
        DynamicObjectCollection srm_grade = QueryServiceHelper.query((String)"srm_grade", (String)"entryentity.evagrade.id,entryentity.scorefrom,entryentity.scoreto", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)gradeId)});
        long evaGradeId = 0L;
        for (DynamicObject gradeRow : srm_grade) {
            BigDecimal scorefrom = gradeRow.getBigDecimal("entryentity.scorefrom");
            BigDecimal scoreto = gradeRow.getBigDecimal("entryentity.scoreto");
            if (score.compareTo(scorefrom) < 0 || score.compareTo(scoreto) >= 0) continue;
            evaGradeId = gradeRow.getLong("entryentity.evagrade.id");
        }
        return evaGradeId;
    }

    private void updateGroupGrade(String planBillNo, String rptBillno, long calgrade, long org, long supplierId, long categoryId, long materialId) {
        HashMap result;
        ArrayList supplierGradeModels = new ArrayList();
        HashMap<String, Object> supplierGradeModel = new HashMap<String, Object>(12);
        DynamicObject srm_groupevaplan = QueryServiceHelper.queryOne((String)"srm_groupevaplan", (String)"datetimefrom,datetimeto", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)planBillNo)});
        Date datetimefrom = srm_groupevaplan.getDate("datetimefrom");
        Date datetimeto = srm_groupevaplan.getDate("datetimeto");
        supplierGradeModel.put("sourcetype", "B");
        supplierGradeModel.put("source", rptBillno);
        supplierGradeModel.put("evagrade_id", calgrade);
        supplierGradeModel.put("bdsupplier_id", supplierId);
        supplierGradeModel.put("category_id", categoryId);
        supplierGradeModel.put("createorg_id", org);
        supplierGradeModel.put("useorg_id", org);
        supplierGradeModel.put("datetimefrom", datetimefrom);
        supplierGradeModel.put("datetimeto", datetimeto);
        supplierGradeModels.add(supplierGradeModel);
        if (supplierGradeModels.size() > 0 && !((Boolean)(result = (HashMap)DispatchServiceHelper.invokeBizService((String)"bd", (String)"pbd", (String)"PbdSupplierGradeService", (String)"synchroSupplierGrade", (Object[])new Object[]{supplierGradeModels})).get("success")).booleanValue() && Objects.nonNull(result.get("message"))) {
            throw new KDException(result.get("message").toString());
        }
    }
}

