/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.srm.service.list.SrmScoreRptListService;

public final class SrmScoreRptDirectApproveOp
extends AbstractOperationServicePlugIn {
    protected IAppCache scoredirectapprove = AppCache.get((String)"scoredirectapprove");
    private SrmScoreRptListService srmScoreRptListService;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("taskbillid");
        e.getFieldKeys().add("bizstatus");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap reportMap = new HashMap(16);
        for (DynamicObject data : dataEntities) {
            String lockKey;
            String key;
            long taskbillid = data.getLong("taskbillid");
            long id = data.getLong("id");
            ArrayList<Object> pkList = (ArrayList<Object>)reportMap.get(taskbillid);
            if (pkList == null) {
                pkList = new ArrayList<Object>(10);
            }
            if ("1".equals(key = (String)this.scoredirectapprove.get(lockKey = "/scm/srm/opplugin/directapprove/" + id, String.class))) continue;
            this.scoredirectapprove.put(lockKey, (Object)"1", 10);
            pkList.add(data.getPkValue());
            reportMap.put(taskbillid, pkList);
        }
        for (Map.Entry entry : reportMap.entrySet()) {
            Long taskbillid = (Long)entry.getKey();
            List pkList = (List)entry.getValue();
            String lockKey = "/scm/srm/opplugin/directapprove/" + taskbillid;
            DLock lock = DLock.create((String)lockKey);
            lock.lock();
            try {
                String operationKey = e.getOperationKey();
                this.handleScoreRptDirectApprove(pkList, operationKey);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void handleScoreRptDirectApprove(List<Object> pkList, String operationKey) {
        Map variables = this.operateOption.getVariables();
        String cfmOption = "";
        if (variables.containsKey("cfmOption")) {
            cfmOption = this.operateOption.getVariableValue("cfmOption");
        }
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        returnData.put("cfmOption", cfmOption);
        if (operationKey.equals("directapprove_exec")) {
            returnData.put("result", "agree");
        } else {
            returnData.put("result", "reject");
        }
        SrmScoreRptListService serviceRpt = this.getServiceRpt();
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        Object[] primaryKeyValues = pkList.toArray(new Object[pkList.size()]);
        OperationServiceHelper.executeOperate((String)"sendapprovemsg", (String)"srm_scorerpt", (Object[])primaryKeyValues, (OperateOption)option.copy());
        serviceRpt.dealReviewReurnData(returnData, primaryKeyValues, true);
        serviceRpt.dealApproveReurnData(returnData, primaryKeyValues, true);
        Object result = returnData.get("result");
        if (Objects.nonNull(result) && "agree".equals(result.toString())) {
            OperationServiceHelper.executeOperate((String)"synsupgrade", (String)"srm_scorerpt", (Object[])primaryKeyValues, (OperateOption)option.copy());
            this.writeBackGroupEvaPlanCalStatus(pkList);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    protected SrmScoreRptListService getServiceRpt() {
        if (Objects.isNull(this.srmScoreRptListService)) {
            this.srmScoreRptListService = new SrmScoreRptListService();
            return this.srmScoreRptListService;
        }
        return this.srmScoreRptListService;
    }

    private void writeBackGroupEvaPlanCalStatus(List<Object> pkList) {
        Long groupevaplanno;
        if (pkList == null || pkList.isEmpty()) {
            return;
        }
        DynamicObject curBill = QueryServiceHelper.queryOne((String)"srm_scorerpt", (String)"id,taskbillid", (QFilter[])new QFilter[]{new QFilter("id", "=", pkList.get(0))});
        long taskbillid = curBill.getLong("taskbillid");
        DynamicObject srm_evaplan = QueryServiceHelper.queryOne((String)"srm_evaplan", (String)"id,groupevaplanno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskbillid)});
        if (srm_evaplan == null) {
            srm_evaplan = QueryServiceHelper.queryOne((String)"srm_evaplan_batch", (String)"id,groupevaplanno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskbillid)});
        }
        if (srm_evaplan != null && (groupevaplanno = Long.valueOf(srm_evaplan.getLong("groupevaplanno"))) != null && groupevaplanno != 0L) {
            this.writeBackGroupEvaPlanCalStatus(groupevaplanno);
        }
    }

    private void writeBackGroupEvaPlanCalStatus(Long groupevaplanno) {
        DynamicObjectCollection srm_evaplan = QueryServiceHelper.query((String)"srm_evaplan", (String)"id,bizstatus,groupevaplanno", (QFilter[])new QFilter[]{new QFilter("groupevaplanno", "=", (Object)groupevaplanno)});
        if (srm_evaplan == null || srm_evaplan.isEmpty()) {
            srm_evaplan = QueryServiceHelper.query((String)"srm_evaplan_batch", (String)"id,bizstatus,groupevaplanno", (QFilter[])new QFilter[]{new QFilter("groupevaplanno", "=", (Object)groupevaplanno)});
        }
        HashSet<Long> evaplanIds = new HashSet<Long>(16);
        boolean wb = true;
        for (Object evaplan : srm_evaplan) {
            String bizstatus = evaplan.getString("bizstatus");
            if ("A".equals(bizstatus) || "B".equals(bizstatus)) {
                wb = false;
            }
            long evaplanId = evaplan.getLong("id");
            evaplanIds.add(evaplanId);
        }
        DynamicObjectCollection srm_scorerpt = QueryServiceHelper.query((String)"srm_scorerpt", (String)"id,bizstatus", (QFilter[])new QFilter[]{new QFilter("taskbillid", "in", evaplanIds)});
        for (DynamicObject scorerpt : srm_scorerpt) {
            String bizstatus = scorerpt.getString("bizstatus");
            if ("G".equals(bizstatus) || "Z".equals(bizstatus)) continue;
            wb = false;
            break;
        }
        if (wb) {
            DynamicObject groupevaplan = BusinessDataServiceHelper.loadSingle((String)"srm_groupevaplan", (String)"id,billno,billstatus,cansumcalculate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)groupevaplanno)});
            groupevaplan.set("cansumcalculate", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{groupevaplan});
        }
    }
}

