/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.srm.common.SrmScoreUtil;
import kd.scm.srm.service.SrmAutoScoreService;

public class SrmScoreRptRemarkOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("bizstatus");
        e.getFieldKeys().add("cfmstatus");
        e.getFieldKeys().add("taskbillid");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        ArrayList<Long> idList = new ArrayList<Long>();
        HashSet<Long> taskbillIDS = new HashSet<Long>(12);
        for (DynamicObject dynamicObject : objs) {
            String bizStatus = dynamicObject.getString("bizstatus");
            if (!SrmScoreStatusEnum.ENDED.getValue().equals(bizStatus)) continue;
            Long id = (Long)dynamicObject.getPkValue();
            idList.add(id);
            taskbillIDS.add(dynamicObject.getLong("taskbillid"));
        }
        if (idList.size() == 0) {
            return;
        }
        DynamicObjectType dt = ORMUtil.newDynamicObject((String)"srm_score").getDynamicObjectType();
        DynamicObject[] scoreObjs = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)dt);
        ArrayList<DynamicObject> scoreObjList = new ArrayList<DynamicObject>(scoreObjs.length);
        DynamicObject[] dynamicObjectArray = scoreObjs;
        int bizStatus = dynamicObjectArray.length;
        for (int i = 0; i < bizStatus; ++i) {
            DynamicObject scoreObj;
            DynamicObject scoreDy = scoreObj = dynamicObjectArray[i];
            DynamicObject newScoreDy = (DynamicObject)OrmUtils.clone((IDataEntityBase)scoreDy, (boolean)false, (boolean)true);
            String billNO = CodeRuleServiceHelper.getNumber((String)"srm_score", (DynamicObject)newScoreDy, (String)"0");
            newScoreDy.set("billno", (Object)billNO);
            newScoreDy.set("bizstatus", (Object)SrmScoreStatusEnum.TOBESCORE);
            newScoreDy.set("cfmstatus", (Object)SrmScoreStatusEnum.TOBESTART.getValue());
            newScoreDy.set("sumscore", null);
            newScoreDy.set("supgrade", null);
            this.clearData(newScoreDy);
            scoreObjList.add(newScoreDy);
        }
        Object[] objectArray = SaveServiceHelper.save((DynamicObject[])scoreObjList.toArray(new DynamicObject[0]));
        if (objectArray.length > 0) {
            ArrayList<Long> ids = new ArrayList<Long>(12);
            for (Object o : objectArray) {
                if (!(o instanceof DynamicObject)) continue;
                ids.add(((DynamicObject)o).getLong("id"));
            }
            this.getOption().setVariableValue("scoreIds", JacksonJsonUtil.toJSON(ids));
        }
        if (taskbillIDS.size() > 0) {
            SrmScoreUtil.setEvaplanStatus(taskbillIDS);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String scoreIdStr = this.getOption().getVariableValue("scoreIds", "");
        final List ids = JacksonJsonUtil.fromJSONList((String)scoreIdStr, Long.class);
        final SrmAutoScoreService srmAutoScoreService = new SrmAutoScoreService();
        ThreadPools.executeOnce((String)"SrmScoreRptRemarkOp_AutoScore", (Runnable)new Runnable(){

            @Override
            public void run() {
                srmAutoScoreService.pushAutoScoreTaskByTaskId(ids);
            }
        });
    }

    private void clearData(DynamicObject newScoreDy) {
        DynamicObjectCollection entryCols = newScoreDy.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entryCols) {
            entry.set("manscore", (Object)0);
            entry.set("veto", (Object)"9");
            DynamicObjectCollection subEntryCols = entry.getDynamicObjectCollection("subentry");
            for (DynamicObject subEntry : subEntryCols) {
                subEntry.set("note", (Object)"");
                subEntry.set("scorerscored", (Object)Boolean.FALSE);
                subEntry.set("scorerveto", null);
                subEntry.set("scoreattachment", null);
            }
        }
        DynamicObjectCollection entryOvarAllEva = newScoreDy.getDynamicObjectCollection("entryentity");
        entryOvarAllEva.clear();
    }
}

