/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin;

import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.constant.SupplierLifeCycleConstant;
import kd.scm.common.util.DateUtil;
import kd.scm.srm.opplugin.validator.SrmSupApproveTempAuditValidator;

public class SrmSupApproveTempAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("tempstatus");
        e.getFieldKeys().add("expirydate");
        e.getFieldKeys().add("remaindate");
        e.getFieldKeys().add("bdsupplier");
        e.getFieldKeys().add("supplier");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SrmSupApproveTempAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] srm_suppliers;
        DynamicObject[] dyns = e.getDataEntities();
        Date today = DateUtil.string2date((String)DateUtil.date2str((Date)new Date(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
        HashSet<Long> supplierIdSet = new HashSet<Long>(16);
        for (DynamicObject dyn : dyns) {
            long supplierId = dyn.getLong("supplier.id");
            supplierIdSet.add(supplierId);
            this.setDynamicObjectValue(dyn, today);
        }
        for (DynamicObject srm_supplier : srm_suppliers = BusinessDataServiceHelper.load((String)"srm_supplier", (String)"id,supplier_status", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIdSet)})) {
            srm_supplier.set("supplier_status", (Object)SupplierLifeCycleConstant.SUPSTATUS_TEMP);
        }
        SaveServiceHelper.update((DynamicObject[])srm_suppliers);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }

    private void setDynamicObjectValue(DynamicObject dyn, Date today) {
        dyn.set("tempstatus", (Object)"B");
        Date expirydate = dyn.getDate("expirydate");
        if (expirydate != null) {
            int days = (int)((expirydate.getTime() - today.getTime()) / 86400000L);
            dyn.set("remaindate", (Object)days);
        }
    }
}

