/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.srm.common.service.imp.SrmCateGoryAddPmInvokeImp;
import kd.scm.srm.common.service.imp.SrmCateGoryAddXkInvokeImp;
import kd.scm.srm.common.service.imp.SrmCateGoryDisEffEctPmInvokeImp;
import kd.scm.srm.common.service.imp.SrmCateGoryDisEffectXkInvokeImp;
import kd.scm.srm.common.service.imp.SrmCateGoryUpdateDatePmInvokeImp;
import kd.scm.srm.common.service.imp.SrmCateGoryUpdatePmInvokeImp;

public class SrmSupCategorySaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("supplier_id");
        fieldKeys.add("org_id");
        fieldKeys.add("category_id");
        fieldKeys.add("material_id");
        fieldKeys.add("auditstatus");
        fieldKeys.add("supplier_number");
        fieldKeys.add("org_number");
        fieldKeys.add("material_number");
        fieldKeys.add("issourcelist");
        fieldKeys.add("modifytime");
        fieldKeys.add("categorytype");
        fieldKeys.add("modifier_id");
        fieldKeys.add("categorytype");
        fieldKeys.add("supplier");
        fieldKeys.add("effectdate");
        fieldKeys.add("expirydate");
        fieldKeys.add("sourcelistentryid");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        List selectedRows = e.getSelectedRows();
        ArrayList addReq = new ArrayList(1024);
        ArrayList modifyReq = new ArrayList(1024);
        HashSet<Long> sourceListEntryIds = new HashSet<Long>(16);
        for (ExtendedDataEntity row : selectedRows) {
            DynamicObject dataEntity = row.getDataEntity();
            String sourcelistentryid = dataEntity.getString("sourcelistentryid");
            if (StringUtils.isEmpty((CharSequence)sourcelistentryid)) continue;
            sourceListEntryIds.add(Long.parseLong(sourcelistentryid));
        }
        HashSet<String> existSourceListEntryIds = new HashSet<String>(16);
        if (sourceListEntryIds.size() > 0) {
            QFilter qFilter = new QFilter("entryentity.id", "in", sourceListEntryIds);
            DynamicObjectCollection pmSourceLists = QueryServiceHelper.query((String)"pm_sourcelist", (String)"entryentity.id", (QFilter[])qFilter.toArray());
            for (DynamicObject row : pmSourceLists) {
                existSourceListEntryIds.add(row.getString("entryentity.id"));
            }
        }
        for (ExtendedDataEntity row : selectedRows) {
            DynamicObject dataEntity = row.getDataEntity();
            boolean issourcelist = dataEntity.getBoolean("issourcelist");
            String status = dataEntity.getString("auditstatus");
            long materialId = dataEntity.getLong("material_id");
            if (!issourcelist) continue;
            HashMap<String, Object> reqMap = new HashMap<String, Object>();
            reqMap.put("org", dataEntity.getLong("org_id"));
            reqMap.put("supplier", dataEntity.getLong("supplier_id"));
            reqMap.put("modifier", dataEntity.getLong("modifier_id"));
            reqMap.put("modifytime", dataEntity.getDate("modifytime"));
            reqMap.put("id", row.getBillPkId());
            String sourcelistentryid = dataEntity.getString("sourcelistentryid");
            if (existSourceListEntryIds.contains(sourcelistentryid)) {
                reqMap.put("sourcelistentryid", sourcelistentryid);
            } else {
                reqMap.put("sourcelistentryid", null);
            }
            reqMap.put("auditstatus", status);
            ArrayList entryentitys = new ArrayList();
            HashMap<String, Object> entryentityMap = new HashMap<String, Object>();
            entryentityMap.put("type", dataEntity.getString("categorytype"));
            entryentityMap.put("material", materialId);
            entryentityMap.put("materialsort", dataEntity.getLong("category_id"));
            entryentityMap.put("entryid", row.getBillPkId());
            entryentityMap.put("effectdate", dataEntity.getDate("effectdate"));
            entryentityMap.put("expirydate", dataEntity.getDate("expirydate"));
            entryentitys.add(entryentityMap);
            reqMap.put("entryentity", entryentitys);
            if ("1".equals(status)) {
                addReq.add(reqMap);
                continue;
            }
            modifyReq.add(reqMap);
        }
        if (ApiConfigUtil.hasCQScmConfig()) {
            if (addReq.size() > 0) {
                SrmCateGoryAddPmInvokeImp addInvoke = new SrmCateGoryAddPmInvokeImp();
                addInvoke.invoke(addReq);
                SrmCateGoryUpdateDatePmInvokeImp cateGoryUpdateDate = new SrmCateGoryUpdateDatePmInvokeImp();
                cateGoryUpdateDate.invoke(addReq);
            }
            if (modifyReq.size() > 0) {
                SrmCateGoryUpdatePmInvokeImp upInvoke = new SrmCateGoryUpdatePmInvokeImp();
                upInvoke.invoke(modifyReq);
                SrmCateGoryDisEffEctPmInvokeImp cateGoryDisEffEct = new SrmCateGoryDisEffEctPmInvokeImp();
                cateGoryDisEffEct.invoke(modifyReq);
            }
        } else if (ApiConfigUtil.hasXKScmConfig()) {
            List selectDys = selectedRows.stream().map(x -> x.getDataEntity()).collect(Collectors.toList());
            SrmCateGoryAddXkInvokeImp srmCateGoryAddXkInvokeImp = new SrmCateGoryAddXkInvokeImp();
            srmCateGoryAddXkInvokeImp.invoke(selectDys);
            SrmCateGoryDisEffectXkInvokeImp srmCateGoryDisEffectXkInvokeImp = new SrmCateGoryDisEffectXkInvokeImp();
            srmCateGoryDisEffectXkInvokeImp.invoke(selectDys);
        }
    }
}

