/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.srm.opplugin.validator.SrmSupplierRegDeleteValidator;

public class SrmSupplierRegDeleteOp
extends AbstractOperationServicePlugIn {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("name");
        fieldKeys.add("status");
        fieldKeys.add("auditstatus");
        fieldKeys.add("societycreditcode");
        fieldKeys.add("executeresult");
        fieldKeys.add("billno");
        fieldKeys.add("enable");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List validExtDataEntities = e.getValidExtDataEntities();
        if (validExtDataEntities.size() > 1) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u4e00\u6761\u6570\u636e\u3002", (String)"SrmSupplierRegDeleteOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            e.cancel = true;
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject supplierregObj = extendedDataEntity.getDataEntity();
            if (!WorkflowServiceHelper.inProcess((String)supplierregObj.getString("id"))) continue;
            e.setCancelMessage(ResManager.loadKDString((String)"\u6d41\u7a0b\u4e2d\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"SrmSupplierRegDeleteOp_1", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            e.cancel = true;
            return;
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArrayList<Object> pkList = new ArrayList<Object>(10);
        ArrayList<String> supplierregidList = new ArrayList<String>(10);
        for (DynamicObject supplierregObj : e.getDataEntities()) {
            Object status = supplierregObj.get("status");
            if (status.toString().equals("A") || status.toString().equals("B")) {
                String supplierregid = supplierregObj.getString("id");
                supplierregidList.add(supplierregid);
            }
            Object pkValue = supplierregObj.getPkValue();
            pkList.add(pkValue);
        }
        this.log.info("\u6ce8\u518c\u8d44\u6599\u5220\u9664\u8fde\u5e26\u5220\u9664\u6ce8\u518c\u7528\u6237\u96c6\u5408supplierregidList\uff1a" + supplierregidList);
        DeleteServiceHelper.delete((String)"srm_user", (QFilter[])new QFilter[]{new QFilter("supplierregid", "in", supplierregidList)});
        this.deleteAdmSupplierReg(pkList);
    }

    private void deleteAdmSupplierReg(List<Object> pkList) {
        if (pkList == null || pkList.isEmpty()) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", String.valueOf(Boolean.TRUE));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        option.setVariableValue("skipCheckDataPermission", String.valueOf(Boolean.TRUE));
        DynamicObject[] adm_supplierregs = BusinessDataServiceHelper.load((String)"adm_supplierreg", (String)"id,billno,status,enable", (QFilter[])new QFilter[]{new QFilter("id", "in", pkList)});
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"adm_supplierreg", (DynamicObject[])adm_supplierregs, (OperateOption)option.copy());
        if (!operationResult.isSuccess()) {
            this.log.info("\u8c03\u7528\u586b\u5199\u6ce8\u518c\u8d44\u6599\u7684\u5220\u9664\u5931\u8d25" + operationResult.getAllErrorOrValidateInfo() + operationResult.getMessage());
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SrmSupplierRegDeleteValidator());
        this.getOption().setVariableValue("ignorerefentityids", "pds_sup_aptitude");
    }
}

