/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.audit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.SupplierUtil;
import kd.scm.srm.common.BlackEnterpriseUtil;
import kd.scm.srm.common.SrmBlackListUtil;

public class SrmBlackEnterpriseAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        if (!fieldKeys.contains("id")) {
            e.getFieldKeys().add("id");
        }
        if (!fieldKeys.contains("auditstatus")) {
            e.getFieldKeys().add("auditstatus");
        }
        if (!fieldKeys.contains("supplier")) {
            e.getFieldKeys().add("supplier");
        }
        e.getFieldKeys().add("entryentity_e");
        e.getFieldKeys().add("entryentity_e.enumber");
        e.getFieldKeys().add("blacktype");
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("sourceblackbillid");
        e.getFieldKeys().add("auditstatus");
        e.getFieldKeys().add("number");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List validExtDataEntities = e.getValidExtDataEntities();
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            boolean isEAS;
            DynamicObject obj = extendedDataEntity.getDataEntity();
            String blacktype = obj.getString("blacktype");
            if (!"1".equals(blacktype)) continue;
            long billId = SrmCommonUtil.getPkValue((DynamicObject)obj);
            long supplierId = SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("supplier"));
            Map resultMap = SrmBlackListUtil.addToBlackList((String)"srm_blackenterprise", (long)SrmCommonUtil.getPkValue((DynamicObject)obj));
            if (((Boolean)resultMap.get("succed")).booleanValue()) {
                QFilter[] filters = new QFilter[]{new QFilter("sourceid", "=", (Object)billId)};
                DynamicObject[] rows = BusinessDataServiceHelper.load((String)"srm_blackenterprise", (String)"id", (QFilter[])filters);
                if (rows != null && rows.length > 0) {
                    for (DynamicObject row : rows) {
                        resultMap = SrmCommonUtil.autoAuditOp((String)"srm_blackenterprise", (long)row.getLong("id"));
                    }
                }
                if ((rows = BusinessDataServiceHelper.load((String)"srm_blackperson", (String)"id", (QFilter[])filters)) != null && rows.length > 0) {
                    for (DynamicObject row : rows) {
                        resultMap = SrmCommonUtil.autoAuditOp((String)"srm_blackperson", (long)row.getLong("id"));
                    }
                }
            }
            if (obj.getDynamicObject("supplier") != null && obj.getDynamicObject("supplier").getLong("supplier.id") != 0L && (isEAS = ((Boolean)SrmCommonUtil.getSrmParameter().get("isuseeas")).booleanValue()) && ApiConfigUtil.hasEASConfig()) {
                ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
                datas.add(BusinessDataServiceHelper.loadSingle((Object)obj.getDynamicObject("supplier").getString("supplier.id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_supplier")));
                Map disableEasSupplier = SupplierUtil.synDisableEasSupplier(datas);
                if ("false".equals(disableEasSupplier.get("succed"))) {
                    resultMap.put("succed", Boolean.FALSE);
                    resultMap.put("message", disableEasSupplier.get("message"));
                }
            }
            if (((Boolean)resultMap.get("succed")).booleanValue()) {
                obj.set("auditstatus", (Object)SrmSupplierStatusEnum.AUDIT.getValue());
                BlackEnterpriseUtil.auditUpdateSup((DynamicObject[])new DynamicObject[]{obj});
                continue;
            }
            SrmBlackListUtil.deleteFromBlackList((String)"srm_blackenterprise", (long)billId);
            SrmBlackListUtil.deleteFromBlackList((String)"srm_blackperson", (long)billId);
            e.setCancelMessage(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5ba1\u6838\u5904\u7406\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a%1", (String)"SrmBlackEnterpriseAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmBlackEnterpriseAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[]{resultMap.get("message")}));
            e.cancel = true;
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> releaseBillIds = new ArrayList<Long>(10);
        for (DynamicObject data : dataEntities) {
            String blacktype = data.getString("blacktype");
            if (!"2".equals(blacktype)) continue;
            String sourceblackbillid = data.getString("sourceblackbillid");
            if (StringUtils.isNotBlank((CharSequence)sourceblackbillid) && !"0".equals(sourceblackbillid)) {
                releaseBillIds.add(Long.parseLong(sourceblackbillid));
            }
            data.set("auditstatus", (Object)"E");
        }
        DynamicObject[] srm_blackenterprises = BusinessDataServiceHelper.load((String)"srm_blackenterprise", (String)"id,auditstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", releaseBillIds)});
        if (srm_blackenterprises.length > 0) {
            for (DynamicObject srm_blackenterprise : srm_blackenterprises) {
                srm_blackenterprise.set("auditstatus", (Object)"E");
            }
            SaveServiceHelper.save((DynamicObject[])srm_blackenterprises);
        }
    }
}

