/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.audit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SrmQuestionAudit
extends AbstractOperationServicePlugIn {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("sunsupquestion");
        e.getFieldKeys().add("entryentity");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        Set targetBillIds;
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("srm_supquestion");
        pushArgs.setTargetEntityNumber("srm_questioncomp");
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(12);
        for (DynamicObject dataEntity : dataEntities) {
            ListSelectedRow listSelectedRow = new ListSelectedRow();
            listSelectedRow.setPrimaryKeyValue(dataEntity.getPkValue());
            selectedRowList.add(listSelectedRow);
        }
        pushArgs.setSelectedRows(selectedRowList);
        ConvertOperationResult result = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
        if (result.isSuccess()) {
            targetBillIds = result.getTargetBillIds();
            DynamicObject[] loadDy = BusinessDataServiceHelper.load((String)"srm_questioncomp", (String)"supplier,bizpartner", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)targetBillIds)});
            if (loadDy.length > 0) {
                List suIds = Arrays.stream(loadDy).map(x -> x.getLong("supplier.id")).collect(Collectors.toList());
                DynamicObjectCollection querySups = QueryServiceHelper.query((String)"srm_supplier", (String)"id,bizpartner", (QFilter[])new QFilter[]{new QFilter("id", "in", suIds)});
                for (DynamicObject dynamicObject : loadDy) {
                    long supId = dynamicObject.getLong("supplier.id");
                    for (DynamicObject querySup : querySups) {
                        Long bizpartner;
                        if (supId != querySup.getLong("id") || !Objects.nonNull(bizpartner = Long.valueOf(querySup.getLong("bizpartner")))) continue;
                        dynamicObject.set("bizpartner", (Object)bizpartner);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])loadDy);
            }
        } else {
            StringBuilder message = new StringBuilder();
            result.getBillReports().forEach(row -> message.append(row.getFailMessage()));
            this.log.info(message.toString());
            throw new KDBizException(message.toString());
        }
        this.log.info(targetBillIds.toString());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
    }
}

