/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.audit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.srm.opplugin.validator.SrmAptitudeNoValidator;
import org.apache.commons.collections.CollectionUtils;

public class SrmSampleNotifyAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        if (!fieldKeys.contains("biztype")) {
            e.getFieldKeys().add("biztype");
        }
        if (!fieldKeys.contains("auditstatus")) {
            e.getFieldKeys().add("auditstatus");
        }
        if (!fieldKeys.contains("auditopinion")) {
            e.getFieldKeys().add("auditopinion");
        }
        if (!fieldKeys.contains("supplier")) {
            e.getFieldKeys().add("supplier");
        }
        if (!fieldKeys.contains("aptitudeno")) {
            e.getFieldKeys().add("aptitudeno");
        }
        if (!fieldKeys.contains("billno")) {
            e.getFieldKeys().add("billno");
        }
        e.getFieldKeys().add("entryentity.category");
        e.getFieldKeys().add("entryentity.material");
        e.getFieldKeys().add("entryentity.unit");
        e.getFieldKeys().add("entryentity.qty");
        e.getFieldKeys().add("entryentity.senddate");
        e.getFieldKeys().add("entryentity.receiver");
        e.getFieldKeys().add("entryentity.phone");
        e.getFieldKeys().add("entryentity.address");
        e.getFieldKeys().add("remark");
        e.getFieldKeys().add("cfmstatus");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List validExtDataEntities = e.getValidExtDataEntities();
        int size = e.getValidExtDataEntities().size();
        if (size > 1) {
            String aptitudeEntityName = EntityMetadataCache.getDataEntityType((String)"srm_aptitudeexam").getDisplayName().getLocaleValue();
            String entityName = this.billEntityType.getDisplayName().getLocaleValue();
            HashMap<String, StringBuilder> aptitudeOfNumber = new HashMap<String, StringBuilder>(size);
            ArrayList<String> uniqueAptitude = new ArrayList<String>(size);
            HashSet<String> errorAptitude = new HashSet<String>(size);
            for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
                String billNo = extendedDataEntity.getBillNo();
                DynamicObject aptitudeDynamicObject = extendedDataEntity.getDataEntity().getDynamicObject("aptitudeno");
                if (Objects.isNull(aptitudeDynamicObject)) continue;
                String aptitudeName = aptitudeDynamicObject.getString("name");
                if (uniqueAptitude.contains(aptitudeName)) {
                    ((StringBuilder)aptitudeOfNumber.get(aptitudeName)).append('\u3001').append(billNo);
                    errorAptitude.add(aptitudeName);
                    continue;
                }
                uniqueAptitude.add(aptitudeName);
                aptitudeOfNumber.put(aptitudeName, new StringBuilder().append(billNo));
            }
            if (uniqueAptitude.size() < size && !errorAptitude.isEmpty()) {
                StringBuilder message = new StringBuilder(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5b58\u5728\u540c\u4e00\u8d44\u8d28\u5ba1\u67e5\u5355\u53f7\u5bf9\u5e94\u7684\u591a\u884c\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u6570\u636e\u3002", (String)"SrmSampleNotifyAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmSceneExamAuditOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                for (String billNo : errorAptitude) {
                    message.append(aptitudeEntityName).append('\uff1a').append(billNo).append("->").append(entityName).append((CharSequence)aptitudeOfNumber.get(billNo)).append('\uff1b');
                }
                e.setCancel(true);
                e.setCancelMessage(message.append("").toString());
            }
        }
        if (!e.isCancel()) {
            for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
                DynamicObject obj = extendedDataEntity.getDataEntity();
                obj.set("auditstatus", (Object)SrmSupplierStatusEnum.AUDIT.getValue());
                obj.set("cfmstatus", (Object)"A");
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SrmAptitudeNoValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        this.updateAptitudeExam(e.getDataEntities(), null);
    }

    private void updateAptitudeExam(DynamicObject[] objects, String billType) {
        DynamicObject[] sampleExam;
        ArrayList<Long> aptitudeIds = new ArrayList<Long>(objects.length);
        HashMap<Long, Long> mapAptitudeOfNotify = new HashMap<Long, Long>((int)((double)objects.length / 0.75));
        HashMap<Long, String> mapAptitudeOfNotifyRemark = new HashMap<Long, String>((int)((double)objects.length / 0.75));
        HashMap mapAptitudeOfCategoryEntry = new HashMap((int)((double)objects.length / 0.75));
        for (DynamicObject object : objects) {
            DynamicObject dynamicObject = object.getDynamicObject("aptitudeno");
            if (Objects.isNull(dynamicObject)) continue;
            Long aptitudeId = dynamicObject.getLong("id");
            aptitudeIds.add(aptitudeId);
            mapAptitudeOfNotify.put(aptitudeId, object.getLong("id"));
            mapAptitudeOfNotifyRemark.put(aptitudeId, object.getString("remark"));
            DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
            HashMap mapAptitudeOfCategory = new HashMap();
            for (DynamicObject row2 : entryentity) {
                Long category = row2.getLong("category_id");
                if (!mapAptitudeOfCategory.containsKey(category)) {
                    ArrayList<DynamicObject> materialEntry = new ArrayList<DynamicObject>();
                    materialEntry.add(row2);
                    mapAptitudeOfCategory.put(category, materialEntry);
                    continue;
                }
                ((List)mapAptitudeOfCategory.get(category)).add(row2);
            }
            mapAptitudeOfCategoryEntry.put(aptitudeId, mapAptitudeOfCategory);
        }
        if (CollectionUtils.isEmpty(aptitudeIds)) {
            return;
        }
        QFilter qFilter = new QFilter("aptitudeno", "in", aptitudeIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"srm_aptitudeexam", (String)"id,issample,hassample", (QFilter[])new QFilter[]{new QFilter("id", "in", aptitudeIds)}, (String)"id");){
            dataSet.forEach(row -> {
                boolean hasSample = row.getBoolean("hassample");
                boolean isSample = row.getBoolean("issample");
                if (!isSample || hasSample) {
                    aptitudeIds.remove(row.getLong("id"));
                }
            });
        }
        ArrayList samplePkIds = new ArrayList();
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"srm_sampleexam", (String)"id", (QFilter[])new QFilter[]{qFilter.and(new QFilter("billstatus", "=", (Object)"A").or(new QFilter("entryentity.material", "=", (Object)0)))}, (String)"id");){
            dataSet.forEach(row -> samplePkIds.add(row.getLong("id")));
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        for (DynamicObject sample : sampleExam = BusinessDataServiceHelper.load((Object[])samplePkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"srm_sampleexam"))) {
            DynamicObject aptitudeynamicObject = sample.getDynamicObject("aptitudeno");
            if (Objects.isNull(aptitudeynamicObject)) continue;
            Long aptitudeId = aptitudeynamicObject.getLong("id");
            DynamicObjectCollection entryentity = sample.getDynamicObjectCollection("entryentity");
            entryentity.clear();
            sample.set("notifyno_id", mapAptitudeOfNotify.get(aptitudeId));
            sample.set("remark", mapAptitudeOfNotifyRemark.get(aptitudeId));
            Map mapAptitudeOfMaterial = (Map)mapAptitudeOfCategoryEntry.get(aptitudeId);
            for (Map.Entry entry : mapAptitudeOfMaterial.entrySet()) {
                Long key = (Long)entry.getKey();
                List materialEntry = (List)entry.getValue();
                for (DynamicObject row3 : materialEntry) {
                    DynamicObject newRow = (DynamicObject)entryentity.getDynamicObjectType().createInstance();
                    newRow.set("category_id", (Object)key);
                    newRow.set("material_id", (Object)row3.getLong("material_id"));
                    newRow.set("unit_id", (Object)row3.getLong("unit_id"));
                    newRow.set("qty", (Object)row3.getBigDecimal("qty"));
                    newRow.set("senddate", (Object)row3.getDate("senddate"));
                    newRow.set("receiver", (Object)row3.getString("receiver"));
                    newRow.set("phone", (Object)row3.getString("phone"));
                    newRow.set("address", (Object)row3.getString("address"));
                    newRow.set("testresult", (Object)"1");
                    entryentity.add((Object)newRow);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])sampleExam);
    }
}

