/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.botp;

import java.util.ArrayList;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.RfiVisibleUtil;

public class SrmCertificateToRFIOp
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities;
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey("srm_issuerfi")) {
            DynamicObject newRow;
            DynamicObject bill = extendedDataEntity.getDataEntity();
            long orgId = bill.getLong("org.id");
            long bizTypeId = bill.getLong("biztype.id");
            DynamicObjectCollection rfiConfigContents = RfiVisibleUtil.queryRfiContentByBiztype((Long)bizTypeId, (Long)orgId);
            DynamicObjectCollection defaultRfiConfigContents = null;
            Object sortRfiConfigContents = new ArrayList();
            if (rfiConfigContents.isEmpty()) {
                defaultRfiConfigContents = QueryServiceHelper.query((String)"pbd_rficontent", (String)"id,name,seqnumber", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C"))}, (String)"seqnumber");
                try {
                    sortRfiConfigContents = defaultRfiConfigContents.stream().sorted((x, y) -> Integer.parseInt(x.getString("seqnumber")) - Integer.parseInt(y.getString("seqnumber"))).collect(Collectors.toList());
                }
                catch (Exception numberFormatException) {
                    sortRfiConfigContents = defaultRfiConfigContents;
                }
            }
            DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
            if (!rfiConfigContents.isEmpty()) {
                for (DynamicObject data : rfiConfigContents) {
                    newRow = entryentity.addNew();
                    newRow.set("rficontent_id", data.get("entryentity.rficontent"));
                    newRow.set("required", (Object)data.getBoolean("entryentity.required"));
                    newRow.set("rfidesc", (Object)data.getString("entryentity.rfidesc"));
                }
                continue;
            }
            if (sortRfiConfigContents.isEmpty()) continue;
            for (DynamicObject data : sortRfiConfigContents) {
                newRow = entryentity.addNew();
                newRow.set("rficontent_id", (Object)data.getLong("id"));
                newRow.set("required", (Object)Boolean.FALSE);
            }
        }
    }
}

