/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.event;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.srm.common.constant.SrmConstant;
import kd.sdk.scm.srm.extpoint.ISrmAccessNodeService;

public class SrmNodeBotpEventPlugin
implements IEventServicePlugin {
    private Log logger = LogFactory.getLog(SrmNodeBotpEventPlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        String eventNumber = evt.getEventNumber();
        Long eventId = evt.getEventId();
        this.logger.info(eventNumber + ".executePlugin start");
        EntityEvent entityEvent = null;
        if (evt instanceof EntityEvent) {
            entityEvent = (EntityEvent)evt;
        }
        if (entityEvent == null) {
            this.logger.info(eventNumber + ".executePlugin : evt == null");
            return evt.getEventId();
        }
        String entityKey = entityEvent.getEntityNumber();
        ArrayList<Long> pkIds = new ArrayList<Long>(entityEvent.getBusinesskeys().size());
        for (String businesskey : entityEvent.getBusinesskeys()) {
            pkIds.add(Long.valueOf(businesskey));
        }
        if ("srm_aptitudeexam".equals(entityKey)) {
            this.pushBill(pkIds, entityKey);
        } else if (!"srm_supapprove".equals(entityKey)) {
            QFilter qFilter = new QFilter("id", "in", pkIds);
            DynamicObjectCollection curBills = QueryServiceHelper.query((String)entityKey, (String)"id,aptitudeno", (QFilter[])qFilter.toArray());
            pkIds.clear();
            for (DynamicObject node : curBills) {
                pkIds.add(node.getLong("aptitudeno"));
            }
            this.pushBill(pkIds, entityKey);
        }
        return eventId;
    }

    protected void pushBill(List<Long> aptitudeIds, String currentBillnumber) {
        DynamicObject[] aptitudes;
        String selectProperties = "id,billno,isautopush,entry_node,entry_node.id,entry_node.accessnode";
        QFilter qFilter = new QFilter("id", "in", aptitudeIds);
        block0: for (DynamicObject aptitude : aptitudes = BusinessDataServiceHelper.load((String)"srm_aptitudeexam", (String)selectProperties, (QFilter[])qFilter.toArray())) {
            boolean isautopush = aptitude.getBoolean("isautopush");
            if (isautopush) continue;
            DynamicObjectCollection nodeentrys = aptitude.getDynamicObjectCollection(SrmConstant.ENTRY_NODE);
            boolean nextBillFlag = "srm_aptitudeexam".equals(currentBillnumber);
            for (DynamicObject nodeentry : nodeentrys) {
                DynamicObject accessnode = nodeentry.getDynamicObject("accessnode");
                String objectnumber = accessnode.getString("bizobject_id");
                if (nextBillFlag) {
                    String serviceclass = accessnode.getString("serviceclass");
                    if (!StringUtils.isNotBlank((CharSequence)serviceclass)) continue block0;
                    ISrmAccessNodeService nodeService = (ISrmAccessNodeService)TypesContainer.createInstance((String)serviceclass);
                    ArrayList<DynamicObject> aptitudes1 = new ArrayList<DynamicObject>(1);
                    aptitudes1.add(aptitude);
                    nodeService.pushBill(objectnumber, aptitudes1);
                    continue block0;
                }
                if (!currentBillnumber.equals(objectnumber)) continue;
                nextBillFlag = true;
            }
        }
    }
}

