/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.unaudit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.srm.opplugin.validator.SrmQuestionUnAuditValidator;

public class SrmQuestionUnAuditOp
extends AbstractOperationServicePlugIn {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.supdealstatus");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<String> pkIds = new ArrayList<String>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            pkIds.add(dataEntity.getPkValue().toString());
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        operateOption.setVariableValue("skipCheckDataPermission", String.valueOf(Boolean.TRUE));
        operateOption.setVariableValue("isStrict", String.valueOf(Boolean.FALSE));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"adm_questioncomp", (String)"id", (QFilter[])new QFilter[]{new QFilter("srcsupquestionid", "in", pkIds)});
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        Object[] ids = query.stream().map(x -> x.get("id")).collect(Collectors.toSet()).toArray();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"adm_questioncomp", (Object[])ids, (OperateOption)operateOption);
        if (Objects.nonNull(operationResult) && !operationResult.isSuccess()) {
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            StringBuilder message = new StringBuilder(12);
            if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                    String failMessage = iOperateInfo.getMessage();
                    if (StringUtils.isEmpty((Object)failMessage)) continue;
                    message.append(failMessage).append('\n');
                }
            }
            this.log.info(message.toString());
            throw new KDBizException(message.toString());
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SrmQuestionUnAuditValidator());
    }
}

