/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.unaudit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.helper.datahandle.PurDataHandleArgs;
import kd.scm.common.helper.datahandle.TaskStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.opplugin.validator.SrmSupplierRegReturnModifyValidator;

public class SrmSupplierRegReturnModifyOp
extends AbstractOperationServicePlugIn {
    private static final Log LOG = LogFactory.getLog(SrmSupplierRegReturnModifyOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("name");
        fieldKeys.add("org");
        fieldKeys.add("auditstatus");
        fieldKeys.add("supplier");
        fieldKeys.add("email");
        fieldKeys.add("phone");
        fieldKeys.add("bizpartner");
        fieldKeys.add("biztype");
        fieldKeys.add("auditopinion");
        fieldKeys.add("executeresult");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject config = QueryServiceHelper.queryOne((String)"pbd_srmdatasetting", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"srmregsupreturnmodification")});
        if (config != null) {
            Long configId = config.getLong("id");
            for (DynamicObject data : dataEntities) {
                if (!"C".equals(data.getString("auditstatus"))) {
                    data.set("auditstatus", (Object)"A");
                    data.set("status", (Object)"A");
                    SrmCommonUtil.recordAuditInfo((DynamicObject)data);
                    continue;
                }
                PurDataHandleArgs purDataHandleArgs = new PurDataHandleArgs();
                purDataHandleArgs.setTaskConfigId(configId);
                purDataHandleArgs.setSupId(Long.valueOf(Long.parseLong(data.getPkValue().toString())));
                purDataHandleArgs.setSourceBillId(data.getPkValue().toString());
                purDataHandleArgs.setSourceBillType("srmsupplierregreturnmodify");
                purDataHandleArgs.setSourceBillResultFiled("executeresult");
                purDataHandleArgs.setSourceBillkey("srm_supplierreg");
                this.doDispatchService(purDataHandleArgs);
            }
        }
    }

    private void doDispatchService(PurDataHandleArgs purDataHandleArgs) {
        block6: {
            try {
                String args = SerializationUtils.toJsonString((Object)purDataHandleArgs);
                DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"PurDataHandleService", (String)"doPurDataHandle", (Object[])new Object[]{args});
            }
            catch (Exception e) {
                DynamicObject[] resultObjs = this.getResultObj(purDataHandleArgs);
                if (resultObjs == null || resultObjs.length <= 0) break block6;
                DynamicObject result = resultObjs[0];
                DynamicObjectCollection entrys = result.getDynamicObjectCollection("entryentity");
                DynamicObject doingEntry = null;
                for (DynamicObject entry : entrys) {
                    String status = entry.getString("substatus");
                    if (TaskStatusEnum.TASK_DOING.getValue().equals(status) || TaskStatusEnum.TASK_FAIL.getValue().equals(status)) {
                        doingEntry = entry;
                        break;
                    }
                    if (doingEntry != null || !TaskStatusEnum.TASK_NOSTART.getValue().equals(entry.getString("substatus"))) continue;
                    doingEntry = entry;
                }
                if (doingEntry == null && !entrys.isEmpty()) {
                    doingEntry = (DynamicObject)entrys.get(entrys.size() - 1);
                }
                if (doingEntry != null) {
                    doingEntry.set("substatus", (Object)"3");
                    doingEntry.set("detail", (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8d85\u65f6\uff0c\u8bf7\u70b9\u51fb\u91cd\u8bd5\u3002", (String)"SrmSupplierRegReturnModifyOp_1", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{result});
            }
        }
    }

    private DynamicObject[] getResultObj(PurDataHandleArgs args) {
        String sourceBillId = args.getSourceBillId();
        String sourceBillType = args.getSourceBillType();
        QFilter qf = new QFilter("sourcebillid", "=", (Object)sourceBillId);
        if (StringUtils.isNotBlank((CharSequence)sourceBillType)) {
            qf.and("sourcebilltype", "=", (Object)sourceBillType);
        }
        if (StringUtils.isNotBlank((CharSequence)sourceBillId)) {
            return BusinessDataServiceHelper.load((String)"pbd_schandleresult", (String)"id,status,context,entryentity.subtask,entryentity.substatus,entryentity.detail", (QFilter[])new QFilter[]{qf}, (String)"createtime desc", (int)1);
        }
        return null;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SrmSupplierRegReturnModifyValidator());
    }
}

