/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.upgrade.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.DBServiceHelper;
import kd.scm.srm.opplugin.upgrade.NodeUpgradeService;

public class SupapproveUpgradeService
implements NodeUpgradeService {
    @Override
    public void nodeDataUpgrade() {
        DBRoute dbRoute = new DBRoute("pur");
        DB.execute((DBRoute)dbRoute, (String)" delete from t_srm_approvedetail where 1=1 ");
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct s.fid from t_pur_approve s,t_pur_approveentry e,t_pur_aptitude tp,t_pur_entertype te");
        sql.append(" where s.fid = e.fid and s.faptitudenoid = tp.fid and tp.fentertypeid = te.fid order by s.fid desc ");
        Map<Long, Map<String, Long>> typeNodeListMap = this.getTypeNodeListMap(dbRoute);
        try (DataSet dataSet1 = DB.queryDataSet((String)"SupapproveUpgradeService.upgradeNodeInfo", (DBRoute)dbRoute, (String)sql.toString(), null);){
            ArrayList idList = new ArrayList();
            dataSet1.forEach(row -> idList.add(row.getLong("fid")));
            int count = idList.size();
            int totalPages = count / 500;
            if (count % 500 != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<Object[]> params;
                List<Long> subIdList = (pageIndex + 1) * 500 > idList.size() ? idList.subList(pageIndex * 500, idList.size()) : idList.subList(pageIndex * 500, (pageIndex + 1) * 500);
                if (subIdList == null || subIdList.isEmpty() || (params = this.selectData(subIdList, dbRoute, typeNodeListMap)) == null || params.isEmpty() || params == null || params.isEmpty()) continue;
                this.insertData(dbRoute, params);
            }
        }
    }

    private Map<Long, Map<String, Long>> getTypeNodeListMap(DBRoute dbRoute) {
        String sqlTypeNode = "select distinct t.fid,tp.faccessnodeid,node.fbizobject from t_pur_entertype t,t_srm_entertypeentry tp,t_srm_accessnode node where t.fid=tp.fid and node.fid=tp.faccessnodeid and node.fbizobject not in ('srm_aptitudeexam','srm_supapprove') order by t.fid desc,tp.faccessnodeid asc";
        HashMap<Long, Map<String, Long>> typeNodeListMap = new HashMap<Long, Map<String, Long>>(10);
        try (DataSet dataSet1 = DB.queryDataSet((String)"SupapproveUpgradeService.getTypeNodeListMap", (DBRoute)dbRoute, (String)sqlTypeNode, null);){
            dataSet1.forEach(row -> {
                Long typeId = row.getLong("fid");
                Long nodeId = row.getLong("faccessnodeid");
                String objectnumber = row.getString("fbizobject");
                LinkedHashMap<String, Long> typeNodeMap = (LinkedHashMap<String, Long>)typeNodeListMap.get(typeId);
                if (typeNodeMap != null) {
                    typeNodeMap.put(objectnumber, nodeId);
                } else {
                    typeNodeMap = new LinkedHashMap<String, Long>(5);
                    typeNodeMap.put(objectnumber, nodeId);
                    typeNodeListMap.put(typeId, typeNodeMap);
                }
            });
        }
        return typeNodeListMap;
    }

    private List<Object[]> selectData(List<Long> subIdList, DBRoute dbRoute, Map<Long, Map<String, Long>> typeNodeListMap) {
        ArrayList<Object[]> insertList = new ArrayList<Object[]>(subIdList.size() * 5);
        StringBuilder sb = new StringBuilder();
        sb.append(" select distinct s.fid,s.faptitudenoid,s.fscenenoid,tp.fentertypeid,tp.fhasscene,tp.fhassample,");
        sb.append(" tp.fhasmaterial,e.fentryid,e.fsamplenoid,e.ftestresult,e.ftrynoid,e.ftryresult");
        sb.append(" from t_pur_approve s,t_pur_approveentry e,t_pur_aptitude tp,t_pur_entertype te");
        sb.append(" where s.fid = e.fid and s.faptitudenoid = tp.fid and tp.fentertypeid = te.fid");
        sb.append(" and s.fid in (").append(StringUtils.join((Object[])subIdList.toArray(new Long[subIdList.size()]), (char)',')).append(')');
        sb.append(" order by s.fid desc ");
        try (DataSet dataSet1 = DB.queryDataSet((String)"SupapproveUpgradeService.selectData", (DBRoute)dbRoute, (String)sb.toString(), null);){
            HashMap aptitudeBillnoMap = new HashMap();
            dataSet1.forEach(row -> {
                List<Object[]> tempList = this.getInsertData((Row)row, dbRoute, typeNodeListMap, aptitudeBillnoMap);
                if (tempList != null && !tempList.isEmpty()) {
                    insertList.addAll(tempList);
                }
            });
        }
        return insertList;
    }

    private List<Object[]> getInsertData(Row row, DBRoute dbRoute, Map<Long, Map<String, Long>> typeNodeListMap, Map<String, String> aptitudeBillnoMap) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(3);
        Long typeId = row.getLong("fentertypeid");
        Long entryid = row.getLong("fentryid");
        boolean hasscene = row.getBoolean("fhasscene");
        boolean hassample = row.getBoolean("fhassample");
        boolean hasmaterial = row.getBoolean("fhasmaterial");
        if (typeNodeListMap.containsKey(typeId)) {
            String billno;
            String nodestatus;
            int rowseq = 1;
            Map<String, Long> nodeMap = typeNodeListMap.get(typeId);
            Long accessnodeId = nodeMap.get("srm_sceneexam");
            if (accessnodeId != null) {
                Long scenenoid = row.getLong("fscenenoid");
                String billno2 = this.getBillNumber(dbRoute, scenenoid, "srm_sceneexam", aptitudeBillnoMap);
                String nodestatus2 = "0";
                if (hasscene) {
                    nodestatus2 = "1";
                }
                this.addNodeInfo(entryid, rowseq++, accessnodeId, billno2, nodestatus2, params);
            }
            if ((accessnodeId = nodeMap.get("srm_sampleexam")) != null) {
                Long samplenoid = row.getLong("fsamplenoid");
                nodestatus = "0";
                billno = this.getBillNumber(dbRoute, samplenoid, "srm_sampleexam", aptitudeBillnoMap);
                if (hasmaterial) {
                    nodestatus = "1";
                } else {
                    String testresult = row.getString("ftestresult");
                    if ("1".equals(testresult) || "2".equals(testresult)) {
                        nodestatus = testresult;
                    }
                }
                this.addNodeInfo(entryid, rowseq++, accessnodeId, billno, nodestatus, params);
            }
            if ((accessnodeId = nodeMap.get("srm_materialexam")) != null) {
                Long trynoid = row.getLong("ftrynoid");
                nodestatus = "0";
                billno = this.getBillNumber(dbRoute, trynoid, "srm_materialexam", aptitudeBillnoMap);
                if (hassample) {
                    nodestatus = "1";
                } else {
                    String tryresult = row.getString("ftryresult");
                    if ("1".equals(tryresult) || "2".equals(tryresult)) {
                        nodestatus = tryresult;
                    }
                }
                this.addNodeInfo(entryid, rowseq++, accessnodeId, billno, nodestatus, params);
            }
        }
        return params;
    }

    private void addNodeInfo(Long entryid, int rowseq, Long accessnodeId, String billno, String nodestatus, List<Object[]> params) {
        Long detailId = DBServiceHelper.genGlobalLongId();
        Object[] param = new Object[]{entryid, detailId, rowseq, accessnodeId, billno, nodestatus};
        params.add(param);
    }

    private void insertData(DBRoute dbRoute, List<Object[]> parms) {
        String insertSql = " insert into t_srm_approvedetail(fentryid,fdetailid,fseq,faccessnodeid,fnodebillno,fnodestatus)values( ?, ?, ? , ? , ? , ? ) ";
        DB.executeBatch((DBRoute)dbRoute, (String)insertSql, parms);
    }

    private String getBillNumber(DBRoute dbRoute, Long billId, String objectnumber, Map<String, String> aptitudeBillnoMap) {
        String billno = " ";
        String aptitudeBillnoKey = billId + "_" + objectnumber;
        if (billId != null && billId != 0L) {
            String temp = aptitudeBillnoMap.get(aptitudeBillnoKey);
            if (temp == null) {
                String sql = null;
                if ("srm_sceneexam".equals(objectnumber)) {
                    sql = "select fbillno,fid from t_pur_scene where fid=?";
                } else if ("srm_sampleexam".equals(objectnumber)) {
                    sql = "select fbillno,fid from t_pur_sample where fid=?";
                } else if ("srm_materialexam".equals(objectnumber)) {
                    sql = "select fbillno,fid from t_pur_material where fid=?";
                }
                Object[] parames = new Object[]{billId};
                if (StringUtils.isNotBlank((CharSequence)sql)) {
                    try (DataSet dataSet1 = DB.queryDataSet((String)"SupapproveUpgradeService.getBillNumber", (DBRoute)dbRoute, (String)sql, (Object[])parames);){
                        if (!dataSet1.isEmpty()) {
                            Row row = dataSet1.next();
                            billno = row.getString("fbillno");
                        }
                    }
                }
                aptitudeBillnoMap.put(aptitudeBillnoKey, billno);
            } else {
                billno = temp;
            }
        }
        return billno;
    }
}

