/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.srm.common.constant.SrmConstant;
import kd.scm.srm.common.util.SrmCategoryConfigUtil;
import kd.sdk.scm.srm.extpoint.ISrmAccessNodeService;

public class FlowNodeServiceUtil {
    public static void pushBill(Set<Long> aptitudeIds) {
        if (aptitudeIds != null && !aptitudeIds.isEmpty()) {
            String selectedFiled = "id,billno,isautopush,aptitudeno,examresult,auditstatus,entry_node.accessnode";
            QFilter qFilter1 = new QFilter("id", "in", aptitudeIds);
            qFilter1.and("isautopush", "=", (Object)Boolean.TRUE);
            DynamicObject[] aptitudeObjs = BusinessDataServiceHelper.load((String)"srm_aptitudeexam", (String)selectedFiled, (QFilter[])qFilter1.toArray());
            HashMap<String, ISrmAccessNodeService> numberServiceMap = new HashMap<String, ISrmAccessNodeService>(aptitudeObjs.length);
            HashMap<String, List<DynamicObject>> numberNodeMap = new HashMap<String, List<DynamicObject>>(aptitudeObjs.length * 5);
            FlowNodeServiceUtil.putAptitudeMap(aptitudeObjs, numberServiceMap, numberNodeMap);
            if (!numberNodeMap.isEmpty()) {
                for (Map.Entry entry : numberNodeMap.entrySet()) {
                    String objectnumber = (String)entry.getKey();
                    ISrmAccessNodeService nodeService = (ISrmAccessNodeService)numberServiceMap.get(objectnumber);
                    if (nodeService == null) continue;
                    nodeService.pushBill(objectnumber, (List)entry.getValue());
                }
            }
        }
    }

    public static Map<String, Object> verifyAptitudeNo(String objectnumber, Long aptitudeId, DynamicObject dataEntity) {
        DynamicObject org;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        if (dataEntity != null && dataEntity.getDynamicObjectType().getProperty("org") != null && SrmCategoryConfigUtil.isCategory((DynamicObject)(org = dataEntity.getDynamicObject("org"))).booleanValue()) {
            String message = null;
            ISrmAccessNodeService nodeService = FlowNodeServiceUtil.getNodeService(objectnumber);
            message = nodeService != null ? nodeService.verifyAptitudeNo(objectnumber, aptitudeId) : MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5355\u636e({0})\u5728\u4f9b\u5e94\u5546\u51c6\u5165\u8282\u70b9\u662f\u5426\u914d\u7f6e\u5e76\u542f\u7528\u6216\u670d\u52a1\u5904\u7406\u7c7b\u3002", (String)"FlowNodeServiceUtil_0", (String)"scm-srm-opplugin", (Object[])new Object[0]), objectnumber);
            if (StringUtils.isNotBlank((CharSequence)message)) {
                resultMap.put("succed", Boolean.FALSE);
                resultMap.put("message", message);
            }
        }
        return resultMap;
    }

    public static Map<String, Object> setAptitudeNodeStatus(DynamicObject object, boolean finished) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        String message = null;
        String objectNumber = object.getDynamicObjectType().getName();
        ISrmAccessNodeService nodeService = FlowNodeServiceUtil.getNodeService(objectNumber);
        if (nodeService != null) {
            DynamicObject aptitude = object.getDynamicObject("aptitudeno");
            if (aptitude != null) {
                Long aptitudeId = aptitude.getLong("id");
                Date billdate = null;
                if (object.getDynamicObjectType().getProperty("billdate") != null) {
                    billdate = object.getDate("billdate");
                }
                message = aptitudeId != null ? nodeService.setAptitudeNodeStatus(objectNumber, aptitudeId, finished, billdate) : ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4f20\u5165\u5355\u636e\u662f\u5426\u5b58\u5728\u8d44\u8d28\u8bc4\u5ba1\u5355ID\u4fe1\u606f\u3002", (String)"FlowNodeServiceUtil_3", (String)"scm-srm-opplugin", (Object[])new Object[0]);
            } else {
                message = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4f20\u5165\u5355\u636e\u662f\u5426\u5b58\u5728\u8d44\u8d28\u8bc4\u5ba1\u5355\u5bf9\u8c61\u3002", (String)"FlowNodeServiceUtil_2", (String)"scm-srm-opplugin", (Object[])new Object[0]);
            }
        } else {
            message = MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5355\u636e({0})\u5728\u4f9b\u5e94\u5546\u51c6\u5165\u8282\u70b9\u662f\u5426\u914d\u7f6e\u5e76\u542f\u7528\u6216\u670d\u52a1\u5904\u7406\u7c7b\u3002", (String)"FlowNodeServiceUtil_0", (String)"scm-srm-opplugin", (Object[])new Object[0]), objectNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)message)) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", message);
        }
        return resultMap;
    }

    public static Map<String, Object> setSupapproveNodeStatus(DynamicObject[] nodeobjects, boolean isAudit) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        String message = null;
        String objectNumber = nodeobjects[0].getDynamicObjectType().getName();
        ISrmAccessNodeService nodeService = FlowNodeServiceUtil.getNodeService(objectNumber);
        message = nodeService != null ? nodeService.setSupapproveNodeStatus(objectNumber, nodeobjects, isAudit) : MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5355\u636e({0})\u5728\u4f9b\u5e94\u5546\u51c6\u5165\u8282\u70b9\u662f\u5426\u914d\u7f6e\u5e76\u542f\u7528\u6216\u670d\u52a1\u5904\u7406\u7c7b\u3002", (String)"FlowNodeServiceUtil_0", (String)"scm-srm-opplugin", (Object[])new Object[0]), objectNumber);
        if (StringUtils.isNotBlank((CharSequence)message)) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", message);
        }
        return resultMap;
    }

    private static ISrmAccessNodeService getNodeService(String objectnumber) {
        String serviceclass;
        ISrmAccessNodeService nodeService = null;
        QFilter qFilter = new QFilter("status", "=", (Object)"1");
        qFilter.and("bizobject", "=", (Object)objectnumber);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"srm_accessnode", (String)"id,serviceclass", (QFilter[])qFilter.toArray());
        if (dyn != null && StringUtils.isNotBlank((CharSequence)(serviceclass = dyn.getString("serviceclass")))) {
            nodeService = (ISrmAccessNodeService)TypesContainer.createInstance((String)serviceclass);
        }
        return nodeService;
    }

    private static void putAptitudeMap(DynamicObject[] aptitudeObjs, Map<String, ISrmAccessNodeService> numberServiceMap, Map<String, List<DynamicObject>> numberNodeMap) {
        for (DynamicObject apt : aptitudeObjs) {
            DynamicObjectCollection dynList = apt.getDynamicObjectCollection(SrmConstant.ENTRY_NODE);
            for (DynamicObject dyn : dynList) {
                DynamicObject accessnode = dyn.getDynamicObject(SrmConstant.ACCESS_NODE);
                if (accessnode == null) continue;
                String number = accessnode.getString("bizobject_id");
                List<DynamicObject> tempList = numberNodeMap.get(number);
                if (tempList != null) {
                    numberNodeMap.get(number).add(apt);
                } else {
                    tempList = new ArrayList<DynamicObject>(aptitudeObjs.length);
                    tempList.add(apt);
                    numberNodeMap.put(number, tempList);
                }
                String className = accessnode.getString("serviceclass");
                if (numberServiceMap.containsKey(number) || !StringUtils.isNotBlank((CharSequence)className)) continue;
                ISrmAccessNodeService service = (ISrmAccessNodeService)TypesContainer.createInstance((String)className);
                numberServiceMap.put(number, service);
            }
        }
    }
}

