/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.validator;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class SrmEvaPlanBatchSubmitValidator
extends AbstractValidator {
    private String EVASUPENTRY = "entryentity";
    private String EVASOCRERSUBENTRY = "subentryentity";
    private String EVACATEGORY = "category";
    private String EVAMATERIAL = "material";
    private String EVASUPPLIER = "supplier";
    private String EVASCHEME = "scheme";
    private String INDEXCLASS = "indexclass";
    private String SCORER = "scorer";
    private String SCORERWEIGHT = "scorerweight";

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject data = dataEntity.getDataEntity();
            String billName = data.getDynamicObjectType().getName();
            if ("srm_groupevaplan".equals(billName)) {
                String type = data.getString("type");
                if (!"4".equals(type)) continue;
                this.updateBillSelectFields(billName);
            } else if ("srm_autoevatpl".equals(billName)) {
                String pushtype = data.getString("pushtype");
                String exectype = data.getString("exectype");
                boolean autogetvalue = data.getBoolean("autogetvalue");
                if (!"srm_evaplan_batch".equals(pushtype) || !"1".equals(exectype) || autogetvalue) continue;
                DynamicObjectCollection evasupentry = data.getDynamicObjectCollection("evasupentry");
                if (evasupentry == null || evasupentry.isEmpty()) {
                    this.addErrorMessage(dataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u5bf9\u8c61\u5206\u5f55\u3002", (String)"SrmEvaPlanBatchSubmitValidator_0", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanBatchSubmitValidator_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                }
                this.updateBillSelectFields(billName);
            }
            if ("srm_evaplan_batch".equals(billName)) {
                if (!this.validGradeDateTime(data, "datetimefrom")) {
                    this.addErrorMessage(dataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5b58\u5728\u66f4\u65b0\u4f9b\u5e94\u5546\u5206\u7ea7\u7684\u8bc4\u4f30\u65b9\u6848\uff0c\u8bf7\u586b\u5199\u5206\u7ea7\u6709\u6548\u65e5\u671f\u4ece\u3002", (String)"SrmEvaPlanBatchSubmitValidator_9", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanBatchSubmitValidator_9", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                }
                if (!this.validGradeDateTime(data, "datetimeto")) {
                    this.addErrorMessage(dataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5b58\u5728\u66f4\u65b0\u4f9b\u5e94\u5546\u5206\u7ea7\u7684\u8bc4\u4f30\u65b9\u6848\uff0c\u8bf7\u586b\u5199\u5206\u7ea7\u6709\u6548\u65e5\u671f\u81f3\u3002", (String)"SrmEvaPlanBatchSubmitValidator_10", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanBatchSubmitValidator_10", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                }
            }
            DynamicObjectCollection supplierEntry = data.getDynamicObjectCollection(this.EVASUPENTRY);
            String evamethod = data.getString("evamethod");
            int rowIndex = 1;
            HashSet<String> evaSet = new HashSet<String>(16);
            String entityKey = this.getEntityKey();
            for (DynamicObject supplierEntryRow : supplierEntry) {
                String[] messages;
                DynamicObjectCollection subentryentity = supplierEntryRow.getDynamicObjectCollection(this.EVASOCRERSUBENTRY);
                String categoryId = supplierEntryRow.getString(this.EVACATEGORY + ".id");
                String materialId = supplierEntryRow.getString(this.EVAMATERIAL + ".id");
                String supplierId = supplierEntryRow.getString(this.EVASUPPLIER + ".id");
                String schemeId = supplierEntryRow.getString(this.EVASCHEME + ".id");
                DynamicObject scheme = supplierEntryRow.getDynamicObject(this.EVASCHEME);
                String key = categoryId + materialId + supplierId + schemeId;
                if (entityKey.equals("srm_evaplan_batch")) {
                    String bizbillno = supplierEntryRow.getString("bizbillno");
                    key = key + bizbillno;
                }
                String weightstrategy = supplierEntryRow.getString("weightstrategy");
                if (evaSet.contains(key)) {
                    this.addErrorMessage(dataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u5206\u5f55\u7b2c%1\u884c\u8bc4\u4f30\u7ef4\u5ea6\u91cd\u590d\u3002", (String)"SrmEvaPlanBatchSubmitValidator_1", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanBatchSubmitValidator_1", (String)"scm-srm-opplugin", (Object[])new Object[]{rowIndex}));
                } else {
                    evaSet.add(key);
                }
                if ("D".equals(evamethod) && StringUtils.isBlank((CharSequence)categoryId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u5bf9\u8c61\u5206\u5f55\u7b2c%1\u884c\u7684\u8bc4\u4f30\u54c1\u7c7b\u3002", (String)"SrmEvaPlanBatchSubmitValidator_2", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanBatchSubmitValidator_2", (String)"scm-srm-opplugin", (Object[])new Object[]{rowIndex}));
                } else if ("B".equals(evamethod) && StringUtils.isBlank((CharSequence)materialId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u5bf9\u8c61\u5206\u5f55\u7b2c%1\u884c\u7684\u8bc4\u4f30\u7269\u6599\u3002", (String)"SrmEvaPlanBatchSubmitValidator_3", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanBatchSubmitValidator_3", (String)"scm-srm-opplugin", (Object[])new Object[]{rowIndex}));
                }
                Map<Object, Object> resultMap = new HashMap(16);
                if (scheme != null && !((Boolean)(resultMap = this.varifyIndexClas_IndexClassAndScorer(subentryentity, scheme, rowIndex)).get("succed")).booleanValue()) {
                    messages = resultMap.get("message").toString().split("\n");
                    Stream.of(messages).forEach(message -> this.addErrorMessage(dataEntity, (String)message));
                }
                if ("B".equals(weightstrategy) && !((Boolean)(resultMap = this.varifyIndexClas_ScorersWeight(subentryentity, rowIndex)).get("succed")).booleanValue()) {
                    messages = resultMap.get("message").toString().split("\n");
                    Stream.of(messages).forEach(message -> this.addErrorMessage(dataEntity, (String)message));
                }
                ++rowIndex;
            }
        }
    }

    private boolean validGradeDateTime(DynamicObject data, String fieldName) {
        Date dateField;
        boolean success = true;
        if (this.isSynSupGrade(data) && (dateField = data.getDate(fieldName)) == null) {
            success = false;
        }
        return success;
    }

    private boolean isSynSupGrade(DynamicObject data) {
        DynamicObject row;
        DynamicObject scheme;
        DynamicObjectCollection entryentity = data.getDynamicObjectCollection("entryentity");
        boolean synsupgrade = false;
        Iterator iterator = entryentity.iterator();
        while (iterator.hasNext() && ((scheme = (row = (DynamicObject)iterator.next()).getDynamicObject("scheme")) == null || !(synsupgrade = scheme.getBoolean("synsupgrade")))) {
        }
        return synsupgrade;
    }

    private void updateBillSelectFields(String billName) {
        this.EVASUPENTRY = "evasupentry";
        if ("srm_groupevaplan".equals(billName)) {
            this.EVASOCRERSUBENTRY = "evascorersubentry";
        } else if ("srm_autoevatpl".equals(billName)) {
            this.EVASOCRERSUBENTRY = "evascorerentry";
        }
        this.EVACATEGORY = "evacategory";
        this.EVAMATERIAL = "evamaterial";
        this.EVASUPPLIER = "evasupplier";
        this.EVASCHEME = "evascheme";
        this.INDEXCLASS = "evaindexclass";
        this.SCORER = "evascorer";
        this.SCORERWEIGHT = "evascorerweight";
    }

    private Map<String, Object> varifyIndexClas_ScorersWeight(DynamicObjectCollection scorerRows, int rowIndex) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean isSucced = true;
        StringBuilder sb = new StringBuilder();
        HashMap<String, BigDecimal> weightMap = new HashMap<String, BigDecimal>();
        BigDecimal sumWeight = BigDecimal.ZERO;
        for (DynamicObject row : scorerRows) {
            sumWeight = BigDecimal.ZERO;
            String key = row.getString(this.INDEXCLASS + "." + "name");
            String scorer = row.getString(this.SCORER + "." + "name");
            BigDecimal weight = row.getBigDecimal(this.SCORERWEIGHT);
            if (weight.compareTo(BigDecimal.ZERO) == 0) {
                isSucced = false;
                sb.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u5206\u5f55\u7b2c%1\u884c-\u6307\u6807\u5206\u7c7b (%2)\u4e2d\u8bc4\u59d4(%3) \u7684\u6743\u91cd\u4e0d\u5141\u8bb8\u4e3a0\u3002", (String)"SrmEvaPlanBatchSubmitValidator_4", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanBatchSubmitValidator_4", (String)"scm-srm-common", (Object[])new Object[]{rowIndex, key == null ? "" : key, scorer == null ? ResManager.loadKDString((String)"\u672a\u586b\u5199", (String)"SrmEvaPlanBatchSubmitValidator_5", (String)"scm-srm-opplugin", (Object[])new Object[0]) : scorer})).append("\n");
                continue;
            }
            sumWeight = weightMap.get(key) == null ? weight : ((BigDecimal)weightMap.get(key)).add(weight);
            weightMap.put(key, sumWeight);
        }
        for (Map.Entry entry : weightMap.entrySet()) {
            sumWeight = (BigDecimal)entry.getValue();
            if (sumWeight.compareTo(BigDecimal.TEN.multiply(BigDecimal.TEN)) == 0) continue;
            isSucced = false;
            sb.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u5206\u5f55\u7b2c%1\u884c-\u6307\u6807\u5206\u7c7b (%2) \u5404\u8bc4\u59d4\u6743\u91cd\u4e4b\u548c (%3) \u4e0d\u7b49\u4e8e100%\u3002", (String)"SrmEvaPlanBatchSubmitValidator_6", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanBatchSubmitValidator_6", (String)"scm-srm-opplugin", (Object[])new Object[]{rowIndex, entry.getKey(), sumWeight})).append("\n");
        }
        if (!isSucced) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", sb);
        } else {
            resultMap.put("succed", Boolean.TRUE);
        }
        return resultMap;
    }

    private Map<String, Object> varifyIndexClas_IndexClassAndScorer(DynamicObjectCollection scorerRows, DynamicObject scheme, int rowIndex) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean isSucced = true;
        StringBuilder sb = new StringBuilder();
        long schemeId = scheme.getLong("id");
        DynamicObjectCollection srm_scheme = QueryServiceHelper.query((String)"srm_scheme", (String)"id,entryentity,entryentity.index.scoretype,entryentity.index.name,entryentity.index.indextype,entryentity.index.indexclass", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
        HashSet<Long> indexClassSet = new HashSet<Long>(16);
        HashSet<String> indexClassAndScorerSet = new HashSet<String>(16);
        int scorerIndex = 1;
        for (DynamicObject scorerRow : scorerRows) {
            long indexclassId = scorerRow.getLong(this.INDEXCLASS + ".id");
            long scorerId = scorerRow.getLong(this.SCORER + ".id");
            indexClassSet.add(indexclassId);
            String value = indexclassId + "-" + scorerId;
            if (indexClassAndScorerSet.contains(value)) {
                isSucced = false;
                sb.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u5206\u5f55\u7b2c%1\u884c-\u8bc4\u59d4\u4fe1\u606f\u7b2c(%2)\u884c \u6307\u6807\u5206\u7c7b+\u8bc4\u59d4\u91cd\u590d\u3002", (String)"SrmEvaPlanBatchSubmitValidator_7", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanBatchSubmitValidator_7", (String)"scm-srm-opplugin", (Object[])new Object[]{rowIndex, scorerIndex})).append("\n");
            } else {
                indexClassAndScorerSet.add(value);
            }
            ++scorerIndex;
        }
        for (DynamicObject indexEntryRow : srm_scheme) {
            String scoretype = indexEntryRow.getString("entryentity.index.scoretype");
            if ("9".equals(scoretype)) continue;
            String indexName = indexEntryRow.getString("entryentity.index.name");
            long indexTypeId = indexEntryRow.getLong("entryentity.index.indextype");
            long indexClassId = indexEntryRow.getLong("entryentity.index.indexclass");
            if (indexClassSet.contains(indexTypeId) || indexClassSet.contains(indexClassId)) continue;
            isSucced = false;
            sb.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u5206\u5f55\u7b2c%1\u884c-\u6307\u6807(%2) \u672a\u8bbe\u7f6e\u8bc4\u59d4\u3002", (String)"SrmEvaPlanBatchSubmitValidator_8", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanBatchSubmitValidator_8", (String)"scm-srm-opplugin", (Object[])new Object[]{rowIndex, indexName})).append("\n");
        }
        if (!isSucced) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", sb);
        } else {
            resultMap.put("succed", Boolean.TRUE);
        }
        return resultMap;
    }
}

