/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.validator;

import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillVerifyUtil;

public class SrmEvaPlanValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            List autoScoreIndexs;
            Iterator<Object> messageObj;
            Map resultMap;
            long schemeId;
            DynamicObject obj = rowDataEntity.getDataEntity();
            String evamethod = obj.getString("evamethod");
            DynamicObjectCollection supplierRows = obj.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection scorerRows = obj.getDynamicObjectCollection("entry_scorer");
            if (supplierRows == null || supplierRows.size() == 0 || (schemeId = SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("scheme"))) == 0L) continue;
            boolean synsupgrade = obj.getBoolean("scheme.synsupgrade");
            if (synsupgrade) {
                Date datetimefrom = obj.getDate("datetimefrom");
                Date datetimeto = obj.getDate("datetimeto");
                if (datetimefrom == null || datetimeto == null) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u201c\u6709\u6548\u65e5\u671f\u4ece\u201d\u548c\u201c\u6709\u6548\u65e5\u671f\u81f3\u201d\u5b57\u6bb5\u3002", (String)"SrmEvaPlanValidator_10", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                }
            }
            DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"srm_scheme");
            DynamicObjectCollection indexRows = schemeObj.getDynamicObjectCollection("entryentity");
            Date finishDate = obj.getDate("finishdate");
            Date billDate = obj.getDate("billdate");
            if (Objects.isNull(finishDate) || Objects.isNull(billDate)) continue;
            String date = TimeServiceHelper.formatDate((Date)billDate);
            SimpleDateFormat sdf = new SimpleDateFormat(TimeServiceHelper.getDateFormatString());
            Date parabillDate = null;
            try {
                parabillDate = sdf.parse(date);
            }
            catch (ParseException e) {
                parabillDate = billDate;
            }
            if (finishDate.before(parabillDate)) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u201c\u9884\u8ba1\u5b8c\u6210\u65e5\u671f\u201d\u5e94\u5927\u4e8e\u7b49\u4e8e\u201c\u8bc4\u4f30\u65e5\u671f\u201d\u3002", (String)"SrmEvaPlanValidator_11", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            }
            Date datefrom = obj.getDate("datefrom");
            Date dateto = obj.getDate("dateto");
            if (Objects.nonNull(datefrom) && Objects.nonNull(dateto) && !dateto.after(datefrom)) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8bc4\u4f30\u671f\u95f4\u81f3\u5e94\u5927\u4e8e\u8bc4\u4f30\u671f\u95f4\u4ece\u3002", (String)"SrmEvaPlanValidator_1", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            }
            if (!((Boolean)(resultMap = "C".equals(evamethod) ? SrmEvaPlanValidator.isRepeatForEntry(supplierRows, "bizbillno") : SrmCommonUtil.isRepeatForEntry((DynamicObjectCollection)supplierRows, (String)"supplier", null, null)).get("succed")).booleanValue() && Objects.nonNull(messageObj = resultMap.get("message"))) {
                String s = messageObj.toString().replaceAll("\n", "");
                this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61 %1", (String)"SrmEvaPlanValidator_12", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanValidator_6", (String)"scm-srm-opplugin", (Object[])new Object[]{s}));
            }
            messageObj = supplierRows.iterator();
            while (messageObj.hasNext()) {
                DynamicObject supplier = (DynamicObject)messageObj.next();
                String enable = supplier.getString("supplier.enable");
                String status = supplier.getString("supplier.status");
                String supllierName = supplier.getString("supplier.name");
                if (Objects.nonNull(enable) && "0".equals(enable)) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4f9b\u5e94\u5546 (%1) \u4e3a\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u8bc4\u4f30\u5bf9\u8c61\u3002", (String)"SrmEvaPlanValidator_4", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanValidator_4", (String)"scm-srm-opplugin", (Object[])new Object[]{supllierName}));
                }
                if (!Objects.nonNull(status) || !"A".equals(status) && !"B".equals(status)) continue;
                this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u201c%1\u201d\u4e0d\u662f\u201c\u5ba1\u6838\u201d\u72b6\u6001\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u8bc4\u4f30\u5bf9\u8c61\u3002", (String)"SrmEvaPlanValidator_5", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanValidator_5", (String)"scm-srm-opplugin", (Object[])new Object[]{supllierName}));
            }
            resultMap = SrmBillVerifyUtil.verifyScorerEntry((DynamicObjectCollection)indexRows, (DynamicObjectCollection)scorerRows);
            if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                String[] messages = resultMap.get("message").toString().split("\n");
                Stream.of(messages).forEach(message -> this.addErrorMessage(rowDataEntity, (String)message));
            }
            if ((autoScoreIndexs = indexRows.stream().map(x -> x.getDynamicObject("index")).filter(x -> {
                if (Objects.nonNull(x)) {
                    return "9".equals(x.getString("scoretype"));
                }
                return false;
            }).collect(Collectors.toList())).size() > 0) {
                Date dateform = obj.getDate("datefrom");
                Date dateto1 = obj.getDate("dateto");
                if (Objects.isNull(dateform) || Objects.isNull(dateto1)) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u201c\u8bc4\u4f30\u65b9\u6848\u201d\u4e2d\u6709\u201c\u81ea\u52a8\u8bc4\u5206\u201d\u7684\u7c7b\u578b\u6307\u6807\uff0c\u201c\u8bc4\u4f30\u671f\u95f4\u4ece\u201d\u548c\u201c\u8bc4\u4f30\u671f\u95f4\u81f3\u201d\u4fe1\u606f\u5fc5\u5f55\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"SrmEvaPlanValidator_8", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanValidator_8", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                }
            }
            if (!"B".equals(evamethod)) continue;
            DynamicObjectCollection supplierEntryentitys = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject supplierEntryentity : supplierEntryentitys) {
                DynamicObjectCollection subentryentity = supplierEntryentity.getDynamicObjectCollection("subentryentity");
                String supplierName = supplierEntryentity.getString("supplier.name");
                if (!CollectionUtils.isEmpty((Collection)subentryentity) || StringUtils.isEmpty((Object)supplierName)) continue;
                this.addMessage(rowDataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u4f9b\u5e94\u5546: %1 \u201c\u8bc4\u4f30\u7269\u6599\u201d\u4fe1\u606f\u3002", (String)"SrmEvaPlanValidator_9", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanValidator_9", (String)"scm-srm-opplugin", (Object[])new Object[]{supplierName}), ErrorLevel.Error);
            }
        }
    }

    public static Map<String, Object> isRepeatForEntry(DynamicObjectCollection rows, String key1) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        boolean succed = true;
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        StringBuilder message = new StringBuilder();
        int i = 1;
        for (DynamicObject row : rows) {
            String key = null;
            key = row.getString(key1);
            if (key == null || key.trim().equals("")) continue;
            Integer count = (Integer)countMap.get(key);
            if (count != null) {
                if (message.length() == 0) {
                    message.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c", (String)"SrmEvaPlanValidator_13", (String)"scm-srm-opplugin", (Object[])new Object[0]), String.valueOf(i)));
                } else {
                    message.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c", (String)"SrmEvaPlanValidator_14", (String)"scm-srm-opplugin", (Object[])new Object[0]), String.valueOf(i)));
                }
                countMap.put(key, count + 1);
                succed = false;
            } else {
                countMap.put(key, 1);
            }
            ++i;
        }
        if (!succed) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u884c\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff1a", (String)"SrmEvaPlanValidator_15", (String)"scm-srm-opplugin", (Object[])new Object[0]) + "\n" + message);
        }
        return resultMap;
    }
}

