/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.validator;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillVerifyUtil;

public class SrmGroupEvaPlanSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObjectCollection evasupentry;
            String type;
            Object entryRow2;
            DynamicObject obj = rowDataEntity.getDataEntity();
            DynamicObjectCollection supplierRows = obj.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection scorerRows = obj.getDynamicObjectCollection("entry_scorer");
            DynamicObjectCollection orgEntry = obj.getDynamicObjectCollection("entryentity1");
            if (orgEntry == null || orgEntry.size() == 0) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u7ec4\u7ec7\u548c\u8bc4\u4f30\u8d1f\u8d23\u4eba\u3002", (String)"SrmGroupEvaPlanSubmitValidator_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            } else {
                HashSet<Long> evaOrgIdSet = new HashSet<Long>(16);
                for (Object entryRow2 : orgEntry) {
                    DynamicObject evaorg = entryRow2.getDynamicObject("evaorg");
                    DynamicObject evaperson = entryRow2.getDynamicObject("evaperson");
                    long orgId = evaorg.getLong("id");
                    if (evaOrgIdSet.contains(orgId)) {
                        this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8bc4\u4f30\u7ec4\u7ec7\u5b58\u5728\u91cd\u590d\u9879\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SrmGroupEvaPlanSubmitValidator_3", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                        break;
                    }
                    evaOrgIdSet.add(orgId);
                    if (evaorg != null && evaperson != null) continue;
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u7ec4\u7ec7\u548c\u8bc4\u4f30\u8d1f\u8d23\u4eba\u3002", (String)"SrmGroupEvaPlanSubmitValidator_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                }
            }
            boolean avgcal = obj.getBoolean("avgcal");
            if (!avgcal) {
                BigDecimal allWeight = new BigDecimal(0);
                entryRow2 = orgEntry.iterator();
                while (entryRow2.hasNext()) {
                    DynamicObject orgRow = (DynamicObject)entryRow2.next();
                    BigDecimal orgweight = orgRow.getBigDecimal("orgweight");
                    allWeight = allWeight.add(orgweight);
                }
                if (allWeight.compareTo(new BigDecimal(100)) != 0) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5404\u8bc4\u4f30\u7ec4\u7ec7\u6743\u91cd\u52a0\u548c\u9700\u8981\u7b49\u4e8e100%\u3002", (String)"SrmGroupEvaPlanSubmitValidator_2", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                }
            }
            if ((type = obj.getString("type")).equals("2")) {
                String evamethod;
                List autoScoreIndexs;
                Iterator<Object> messageObj;
                Map resultMap;
                if (supplierRows == null || supplierRows.size() == 0) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4f9b\u5e94\u5546\u5206\u5f55\u7684\u4f9b\u5e94\u5546\u3002", (String)"SrmGroupEvaPlanSubmitValidator_1", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                } else {
                    entryRow2 = supplierRows.iterator();
                    while (entryRow2.hasNext()) {
                        DynamicObject entryRow3 = (DynamicObject)entryRow2.next();
                        DynamicObject supplier = entryRow3.getDynamicObject("supplier");
                        if (supplier != null) continue;
                        this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4f9b\u5e94\u5546\u5206\u5f55\u7684\u4f9b\u5e94\u5546\u3002", (String)"SrmGroupEvaPlanSubmitValidator_1", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                    }
                }
                long schemeId = SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("scheme"));
                if (schemeId == 0L) continue;
                DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"srm_scheme");
                DynamicObjectCollection indexRows = schemeObj.getDynamicObjectCollection("entryentity");
                Date finishDate = obj.getDate("finishdate");
                Date billDate = obj.getDate("billdate");
                if (Objects.isNull(finishDate) || Objects.isNull(billDate)) continue;
                String date = TimeServiceHelper.formatDate((Date)billDate);
                SimpleDateFormat sdf = new SimpleDateFormat(TimeServiceHelper.getDateFormatString());
                Date parabillDate = null;
                try {
                    parabillDate = sdf.parse(date);
                }
                catch (ParseException e) {
                    parabillDate = billDate;
                }
                if (finishDate.before(parabillDate)) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8981\u6c42\u5b8c\u6210\u65e5\u671f \u5e94\u5927\u4e8e\u7b49\u4e8e \u8bc4\u4f30\u65e5\u671f\u3002", (String)"SrmGroupEvaPlanSubmitValidator_5", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                }
                Date datefrom = obj.getDate("datefrom");
                Date dateto = obj.getDate("dateto");
                if (Objects.nonNull(datefrom) && Objects.nonNull(dateto) && !dateto.after(datefrom)) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8bc4\u4f30\u671f\u95f4\u81f3\u5e94\u5927\u4e8e\u8bc4\u4f30\u671f\u95f4\u4ece\u3002", (String)"SrmGroupEvaPlanSubmitValidator_6", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                }
                Date datetimefrom = obj.getDate("datetimefrom");
                Date datetimeto = obj.getDate("datetimeto");
                if (Objects.nonNull(datetimefrom) && Objects.nonNull(datetimeto) && !datetimeto.after(datetimefrom)) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u201c\u6709\u6548\u65e5\u671f\u81f3\u201d\u5e94\u5927\u4e8e\u201c\u6709\u6548\u65e5\u671f\u4ece\u201d\u3002", (String)"SrmGroupEvaPlanSubmitValidator_4", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                }
                if (!((Boolean)(resultMap = SrmCommonUtil.isRepeatForEntry((DynamicObjectCollection)supplierRows, (String)"supplier", null, null)).get("succed")).booleanValue() && Objects.nonNull(messageObj = resultMap.get("message"))) {
                    String s = messageObj.toString().replaceAll("\n", "");
                    this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61 %1", (String)"SrmGroupEvaPlanSubmitValidator_7", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanValidator_6", (String)"scm-srm-opplugin", (Object[])new Object[]{s}));
                }
                messageObj = supplierRows.iterator();
                while (messageObj.hasNext()) {
                    DynamicObject supplier = (DynamicObject)messageObj.next();
                    String enable = supplier.getString("supplier.enable");
                    String status = supplier.getString("supplier.status");
                    String supllierName = supplier.getString("supplier.name");
                    if (Objects.nonNull(enable) && "0".equals(enable)) {
                        this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4f9b\u5e94\u5546 (%1) \u4e3a\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u8bc4\u4f30\u5bf9\u8c61\u3002", (String)"SrmGroupEvaPlanSubmitValidator_8", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanValidator_4", (String)"scm-srm-opplugin", (Object[])new Object[]{supllierName}));
                    }
                    if (!Objects.nonNull(status) || !"A".equals(status) && !"B".equals(status)) continue;
                    this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u201c%1\u201d\u4e0d\u662f\u201c\u5ba1\u6838\u201d\u72b6\u6001\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u8bc4\u4f30\u5bf9\u8c61\u3002", (String)"SrmGroupEvaPlanSubmitValidator_9", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanValidator_5", (String)"scm-srm-opplugin", (Object[])new Object[]{supllierName}));
                }
                resultMap = SrmBillVerifyUtil.verifyScorerEntry((DynamicObjectCollection)indexRows, (DynamicObjectCollection)scorerRows);
                if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                    String[] messages = resultMap.get("message").toString().split("\n");
                    Stream.of(messages).forEach(message -> this.addErrorMessage(rowDataEntity, (String)message));
                }
                if ((autoScoreIndexs = indexRows.stream().map(x -> x.getDynamicObject("index")).filter(x -> {
                    if (Objects.nonNull(x)) {
                        return "9".equals(x.getString("scoretype"));
                    }
                    return false;
                }).collect(Collectors.toList())).size() > 0) {
                    Date dateform = obj.getDate("datefrom");
                    Date dateto1 = obj.getDate("dateto");
                    if (Objects.isNull(dateform) || Objects.isNull(dateto1)) {
                        this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u201c\u8bc4\u4f30\u65b9\u6848\u201d\u4e2d\u6709\u201c\u81ea\u52a8\u8bc4\u5206\u201d\u7684\u7c7b\u578b\u6307\u6807\uff0c\u201c\u8bc4\u4f30\u671f\u95f4\u4ece\u201d\u548c\u201c\u8bc4\u4f30\u671f\u95f4\u81f3\u201d\u4fe1\u606f\u5fc5\u5f55\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"SrmGroupEvaPlanSubmitValidator_10", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanValidator_8", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                    }
                }
                if (!"B".equals(evamethod = obj.getString("evamethod"))) continue;
                DynamicObjectCollection supplierEntryentitys = obj.getDynamicObjectCollection("entryentity");
                for (DynamicObject supplierEntryentity : supplierEntryentitys) {
                    DynamicObjectCollection subentryentity = supplierEntryentity.getDynamicObjectCollection("subentryentity");
                    String supplierName = supplierEntryentity.getString("supplier.name");
                    if (!CollectionUtils.isEmpty((Collection)subentryentity) || StringUtils.isEmpty((Object)supplierName)) continue;
                    this.addMessage(rowDataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u4f9b\u5e94\u5546: %1 \u201c\u8bc4\u4f30\u7269\u6599\u201d\u4fe1\u606f\u3002", (String)"SrmGroupEvaPlanSubmitValidator_11", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanValidator_9", (String)"scm-srm-opplugin", (Object[])new Object[]{supplierName}), ErrorLevel.Error);
                }
                continue;
            }
            if (!"4".equals(type) || !(evasupentry = obj.getDynamicObjectCollection("evasupentry")).isEmpty()) continue;
            this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u5bf9\u8c61\u5206\u5f55\u3002", (String)"SrmGroupEvaPlanSubmitValidator_12", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmEvaPlanValidator_8", (String)"scm-srm-opplugin", (Object[])new Object[0]));
        }
    }
}

