/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.validator;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.CollectionUtils;
import kd.scm.common.util.SrmCommonUtil;

public class SrmIndexValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            BigDecimal score;
            DynamicObjectCollection itemRows = rowDataEntity.getDataEntity().getDynamicObjectCollection("entryentity1");
            String property = rowDataEntity.getDataEntity().getString("property");
            String scoretype = rowDataEntity.getDataEntity().getString("scoretype");
            if ("2".equals(property) && "9".equals(scoretype)) continue;
            long indexTypeId = SrmCommonUtil.getPkValue((DynamicObject)rowDataEntity.getDataEntity().getDynamicObject("indextype"));
            if (indexTypeId == 0L) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u6807\u7c7b\u578b\u3002", (String)"SrmIndexValidator_9", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            }
            if ((score = rowDataEntity.getDataEntity().getBigDecimal("score")).compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u6307\u6807\u5206\u503c\u5fc5\u987b\u5927\u4e8e0", (String)"SrmIndexValidator_10", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            }
            if (itemRows == null || itemRows.size() == 0) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8bc4\u5206\u9879\u3002", (String)"SrmIndexValidator_2", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                return;
            }
            for (int i = 0; i < itemRows.size(); ++i) {
                DynamicObjectCollection itemSubRows = ((DynamicObject)itemRows.get(i)).getDynamicObjectCollection("subentryentity1");
                if (!CollectionUtils.isEmpty((Collection)itemSubRows)) continue;
                this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u6307\u6807\u5bf9\u8c61\u4e2d\u7b2c{0}\u884c\u7684\u8bc4\u5206\u89c4\u5219\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"SrmIndexValidator_8", (String)"scm-srm-opplugin", (Object[])new Object[0]), i + 1));
            }
            if (rowDataEntity.getDataEntity().getString("property").equals("1")) {
                for (DynamicObject row : itemRows) {
                    DynamicObjectCollection itemSubRows = row.getDynamicObjectCollection("subentryentity1");
                    for (int i = 0; i < itemSubRows.size(); ++i) {
                        BigDecimal previousValue;
                        BigDecimal currentValue = ((DynamicObject)itemSubRows.get(i)).getBigDecimal("valuefrom1");
                        BigDecimal bigDecimal = previousValue = i > 0 ? ((DynamicObject)itemSubRows.get(i - 1)).getBigDecimal("valuefrom1") : BigDecimal.valueOf(999999999L);
                        if (currentValue.compareTo(previousValue) < 0) continue;
                        this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u7b2c%1\u884c\u7684\u8003\u6838\u503c\u5fc5\u987b\u5c0f\u4e8e\u4e0a\u4e00\u884c\u7684\u8003\u6838\u503c\u3002", (String)"SrmIndexValidator_11", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmIndexValidator_3", (String)"scm-srm-opplugin", (Object[])new Object[]{i + 1}));
                    }
                }
            }
            if ("3".equals(property)) {
                for (DynamicObject row : itemRows) {
                    HashSet<BigDecimal> scoreSet = new HashSet<BigDecimal>(16);
                    DynamicObjectCollection itemSubRows = row.getDynamicObjectCollection("subentryentity1");
                    for (int i = 0; i < itemSubRows.size(); ++i) {
                        BigDecimal itemscore = ((DynamicObject)itemSubRows.get(i)).getBigDecimal("itemscore1");
                        if (scoreSet.contains(itemscore)) {
                            this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u7b2c %1 \u884c\u7684 \u5206\u503c\u91cd\u590d\u3002", (String)"SrmIndexValidator_4", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmIndexValidator_4", (String)"scm-srm-opplugin", (Object[])new Object[]{i + 1}));
                        }
                        scoreSet.add(itemscore);
                    }
                    HashSet<String> accordanceSet = new HashSet<String>(16);
                    for (int i = 0; i < itemSubRows.size(); ++i) {
                        String accordance = ((DynamicObject)itemSubRows.get(i)).getString("accordance1");
                        if (accordanceSet.contains(accordance)) {
                            this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u7b2c %1 \u884c\u7684 \u7b26\u5408\u9879\u503c\u91cd\u590d\u3002", (String)"SrmIndexValidator_5", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmIndexValidator_5", (String)"scm-srm-opplugin", (Object[])new Object[]{i + 1}));
                        }
                        accordanceSet.add(accordance);
                    }
                }
            }
            int isgenericruleSize = 0;
            for (int i = 0; i < itemRows.size(); ++i) {
                DynamicObject row = (DynamicObject)itemRows.get(i);
                Boolean isgenericrule = row.getBoolean("isgenericrule");
                if (isgenericrule.booleanValue()) {
                    ++isgenericruleSize;
                }
                if (isgenericrule.booleanValue()) continue;
                Object category = row.get("category");
                Object material = row.get("material");
                if (category != null && !category.equals(0) || material != null && !material.equals(0)) continue;
                this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u7684\u975e\u901a\u7528\u6307\u6807\uff0c\u54c1\u7c7b\u7f16\u7801\u6216\u8005\u7269\u6599\u7f16\u7801\u8bf7\u586b\u4e00\u9879\u3002", (String)"SrmIndexValidator_6", (String)"scm-srm-opplugin", (Object[])new Object[0]), i + 1));
            }
            if (isgenericruleSize == true) continue;
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e00\u6761\u901a\u7528\u6307\u6807\u5bf9\u8c61\u3002", (String)"SrmIndexValidator_7", (String)"scm-srm-opplugin", (Object[])new Object[0]));
        }
    }
}

