/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class SrmIssueRFIDataValidator
extends AbstractValidator {
    public void validate() {
        String value;
        Long id;
        String name;
        HashMap<Long, String> supplierNameMap = new HashMap<Long, String>(1024);
        HashMap<Long, String> emailMap = new HashMap<Long, String>(1024);
        HashMap<Long, String> phoneMap = new HashMap<Long, String>(1024);
        HashMap<Long, String> simplePhoneMap = new HashMap<Long, String>(1024);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            String phone;
            String email;
            DynamicObject bill = extendedDataEntity.getDataEntity();
            Long id2 = bill.getLong("id");
            String suppliername = bill.getString("suppliername");
            if (suppliername != null && !suppliername.isEmpty()) {
                supplierNameMap.put(id2, suppliername);
            }
            if ((email = bill.getString("email")) != null && !email.isEmpty()) {
                emailMap.put(id2, email);
            }
            if ((phone = bill.getString("phone")) == null || phone.isEmpty()) continue;
            phoneMap.put(id2, phone);
            int index = 0;
            for (int i = 0; i < phone.length(); ++i) {
                if (phone.charAt(i) != '-') continue;
                index = i + 1;
                break;
            }
            simplePhoneMap.put(id2, phone.substring(index, phone.length()));
        }
        String regSupplierName = EntityMetadataCache.getDataEntityType((String)"srm_supplierreg").getDisplayName().getLocaleValue();
        String supplierName = EntityMetadataCache.getDataEntityType((String)"bd_supplier").getDisplayName().getLocaleValue();
        String srmUserName = EntityMetadataCache.getDataEntityType((String)"srm_user").getDisplayName().getLocaleValue();
        String srmBlackEnterprise = EntityMetadataCache.getDataEntityType((String)"srm_blackenterprise").getDisplayName().getLocaleValue();
        String secUserName = EntityMetadataCache.getDataEntityType((String)"bos_user").getDisplayName().getLocaleValue();
        HashMap<Long, String> regSupplierMap = new HashMap<Long, String>();
        HashMap<Long, String> supplierMap = new HashMap<Long, String>();
        HashMap<Long, String> secUserMap = new HashMap<Long, String>();
        HashMap<Long, String> srmUserMap = new HashMap<Long, String>();
        HashMap<Long, String> srmBlackEnterpriseMap = new HashMap<Long, String>();
        String traceId = RequestContext.get().getTraceId();
        ExtendedDataEntity[] extendedDataEntityArray = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)traceId, (String)"srm_supplierreg", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("name", "in", supplierNameMap.values())}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row2 = dataSet.next();
                name = row2.getString("name");
                if (!supplierNameMap.containsValue(name)) continue;
                for (Map.Entry entry : supplierNameMap.entrySet()) {
                    id = (Long)entry.getKey();
                    value = (String)entry.getValue();
                    if (!name.equals(value)) continue;
                    regSupplierMap.put(id, this.bulidMessage(regSupplierName, name, row2.getString("number")));
                }
            }
        }
        catch (Throwable row2) {
            extendedDataEntityArray = row2;
            throw row2;
        }
        dataSet = QueryServiceHelper.queryDataSet((String)traceId, (String)"bd_supplier", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("name", "in", supplierNameMap.values())}, (String)"id");
        extendedDataEntityArray = null;
        try {
            while (dataSet.hasNext()) {
                Row row3 = dataSet.next();
                name = row3.getString("name");
                if (!supplierNameMap.containsValue(name)) continue;
                for (Map.Entry entry : supplierNameMap.entrySet()) {
                    id = (Long)entry.getKey();
                    value = (String)entry.getValue();
                    if (!name.equals(value)) continue;
                    supplierMap.put(id, this.bulidMessage(supplierName, name, row3.getString("number")));
                }
            }
        }
        catch (Throwable row3) {
            extendedDataEntityArray = row3;
            throw row3;
        }
        finally {
            if (dataSet != null) {
                if (extendedDataEntityArray != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row3) {
                        extendedDataEntityArray.addSuppressed(row3);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        dataSet = QueryServiceHelper.queryDataSet((String)traceId, (String)"bos_user", (String)"id,name,phone,email", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1").and(new QFilter("email", "in", emailMap.values()).or(new QFilter("phone", "in", phoneMap.values())).or(new QFilter("phone", "in", simplePhoneMap.values())))}, (String)"id");
        extendedDataEntityArray = null;
        try {
            while (dataSet.hasNext()) {
                String value2;
                Long id2;
                StringBuilder message;
                Row row = dataSet.next();
                String phone = row.getString("phone");
                String email = row.getString("email");
                if (!emailMap.containsValue(email) && !phoneMap.containsValue(phone) && !simplePhoneMap.containsValue(phone)) continue;
                for (Map.Entry entry : emailMap.entrySet()) {
                    Long id3 = (Long)entry.getKey();
                    String value22 = (String)entry.getValue();
                    if (!email.equals(value22)) continue;
                    message = new StringBuilder();
                    if (secUserMap.get(id3) != null) {
                        message.append((String)secUserMap.get(id3));
                    }
                    message.append(this.bulidMessage(secUserName, value22, row.getString("name")));
                    secUserMap.put(id3, message.toString());
                }
                for (Map.Entry entry : phoneMap.entrySet()) {
                    id2 = (Long)entry.getKey();
                    value2 = (String)entry.getValue();
                    if (!phone.equals(value2)) continue;
                    message = new StringBuilder();
                    if (secUserMap.get(id2) != null) {
                        message.append((String)secUserMap.get(id2));
                    }
                    message.append(this.bulidMessage(secUserName, value2, row.getString("name")));
                    secUserMap.put(id2, message.toString());
                }
                for (Map.Entry entry : simplePhoneMap.entrySet()) {
                    id2 = (Long)entry.getKey();
                    value2 = (String)entry.getValue();
                    if (!phone.equals(value2)) continue;
                    message = new StringBuilder();
                    if (secUserMap.get(id2) != null) {
                        message.append((String)secUserMap.get(id2));
                    }
                    message.append(this.bulidMessage(secUserName, value2, row.getString("name")));
                    secUserMap.put(id2, message.toString());
                }
            }
        }
        catch (Throwable throwable) {
            extendedDataEntityArray = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (extendedDataEntityArray != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        extendedDataEntityArray.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList numbers = new ArrayList();
        if (CollectionUtils.isNotEmpty(emailMap.values())) {
            numbers.addAll(emailMap.values());
        }
        if (CollectionUtils.isNotEmpty(simplePhoneMap.values())) {
            numbers.addAll(simplePhoneMap.values());
        }
        try (DataSet srm_users = QueryServiceHelper.queryDataSet((String)traceId, (String)"srm_user", (String)"id,enterprise,number,name", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1").and(new QFilter("number", "in", numbers))}, (String)"id");){
            this.validSrmUser(srm_users, srmUserMap, emailMap, simplePhoneMap, srmUserName);
        }
        var18_22 = null;
        try (DataSet srmBlacdata = QueryServiceHelper.queryDataSet((String)traceId, (String)"srm_blackenterprise", (String)"id,name,number,auditstatus", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1").and(new QFilter("auditstatus", "=", (Object)"C").and(new QFilter("name", "in", supplierNameMap.values())))}, (String)"id");){
            this.validsrmBlackEnterprise(srmBlacdata, supplierNameMap, srmBlackEnterprise, srmBlackEnterpriseMap);
        }
        catch (Throwable throwable) {
            var18_22 = throwable;
            throw throwable;
        }
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            String srmBlackEnterpriseMessage;
            String srmUserMessage;
            String secUserMessage;
            String supplierMessage;
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            id = dynamicObject.getLong("id");
            String regMessage = (String)regSupplierMap.get(id);
            if (regMessage != null) {
                this.addErrorMessage(extendedDataEntity, regMessage);
            }
            if ((supplierMessage = (String)supplierMap.get(id)) != null) {
                this.addErrorMessage(extendedDataEntity, supplierMessage);
            }
            if ((secUserMessage = (String)secUserMap.get(id)) != null) {
                this.addErrorMessage(extendedDataEntity, secUserMessage);
            }
            if ((srmUserMessage = (String)srmUserMap.get(id)) != null) {
                this.addErrorMessage(extendedDataEntity, srmUserMessage);
            }
            if ((srmBlackEnterpriseMessage = (String)srmBlackEnterpriseMap.get(id)) == null) continue;
            this.addErrorMessage(extendedDataEntity, srmBlackEnterpriseMessage);
        }
    }

    private void validsrmBlackEnterprise(DataSet srmBlacdata, Map<Long, String> supplierNameMap, String srmBlackEnterprise, Map<Long, String> srmBlackEnterpriseMap) {
        while (srmBlacdata.hasNext()) {
            Row row = srmBlacdata.next();
            String name = row.getString("name");
            if (!supplierNameMap.containsValue(name)) continue;
            for (Map.Entry<Long, String> entry : supplierNameMap.entrySet()) {
                Long id = entry.getKey();
                String value = entry.getValue();
                if (!name.equals(value)) continue;
                srmBlackEnterpriseMap.put(id, this.bulidMessage(srmBlackEnterprise, name, row.getString("number")));
            }
        }
    }

    private void validSrmUser(DataSet srm_users, Map<Long, String> srmUserMap, Map<Long, String> emailMap, Map<Long, String> simplePhoneMap, String srmUserName) {
        while (srm_users.hasNext()) {
            StringBuilder message;
            String value;
            Long id;
            Row srmUser = srm_users.next();
            String number = srmUser.getString("number");
            if (!emailMap.containsValue(number) && !simplePhoneMap.containsValue(number)) continue;
            for (Map.Entry<Long, String> entry : emailMap.entrySet()) {
                id = entry.getKey();
                value = entry.getValue();
                if (!number.equals(value)) continue;
                message = new StringBuilder();
                if (srmUserMap.get(id) != null) {
                    message.append(srmUserMap.get(id));
                }
                message.append(this.bulidMessage(srmUserName, value, srmUser.getString("name")));
                srmUserMap.put(id, message.toString());
            }
            for (Map.Entry<Long, String> entry : simplePhoneMap.entrySet()) {
                id = entry.getKey();
                value = entry.getValue();
                if (!number.equals(value)) continue;
                message = new StringBuilder();
                if (srmUserMap.get(id) != null) {
                    message.append(srmUserMap.get(id));
                }
                message.append(this.bulidMessage(srmUserName, value, srmUser.getString("name")));
                srmUserMap.put(id, message.toString());
            }
        }
    }

    private String bulidMessage(String entityName, String value, String dataName) {
        return ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u201c%1\u201d\u5df2\u5b58\u5728\u201c%2\u201d\u7684\u6570\u636e\u201c%3\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SrmIssueRFIDataValidator_1", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmIssueRFIDataValidator", (String)"scm-srm-opplugin", (Object[])new Object[]{entityName, value, dataName});
    }
}

