/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.validator;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.scm.common.util.SupplierLifeCycleManagerUtil;

public class SrmSupplierRegUnAuditValidator
extends AbstractValidator {
    private Set<String> BdIgnoreRefEntityIds = new HashSet<String>(32);
    private Set<String> SrmIgnoreRefEntityIds = new HashSet<String>(32);

    public SrmSupplierRegUnAuditValidator() {
        this.BdIgnoreRefEntityIds.add("srm_supplier");
        this.BdIgnoreRefEntityIds.add("srm_supplierreg");
        this.BdIgnoreRefEntityIds.add("srm_supplierchg");
        this.BdIgnoreRefEntityIds.add("srm_supplierinfo");
        this.BdIgnoreRefEntityIds.add("adm_supplier");
        this.BdIgnoreRefEntityIds.add("adm_userquery");
        this.BdIgnoreRefEntityIds.add("adm_supplierchg");
        this.BdIgnoreRefEntityIds.add("pur_supuser");
        this.BdIgnoreRefEntityIds.add("src_supplier");
        this.BdIgnoreRefEntityIds.add("src_supplierinfo");
        this.BdIgnoreRefEntityIds.add("srm_user");
        this.BdIgnoreRefEntityIds.add("bd_suppliergroupdetail");
        this.BdIgnoreRefEntityIds.add("pbd_supplierchg");
        this.BdIgnoreRefEntityIds.add("srm_supenter");
        this.BdIgnoreRefEntityIds.add("srm_supenteraudit");
        this.SrmIgnoreRefEntityIds.add("srm_aptitudebillno");
        this.SrmIgnoreRefEntityIds.add("srm_scenebillno");
        this.SrmIgnoreRefEntityIds.add("srm_samplebillno");
        this.SrmIgnoreRefEntityIds.add("srm_materialbillno");
        this.SrmIgnoreRefEntityIds.add("srm_samplenotifyno");
        this.SrmIgnoreRefEntityIds.add("adm_aptitude");
        this.SrmIgnoreRefEntityIds.add("adm_scene");
        this.SrmIgnoreRefEntityIds.add("adm_samplenotify");
        this.SrmIgnoreRefEntityIds.add("adm_sample");
        this.SrmIgnoreRefEntityIds.add("adm_material");
        this.SrmIgnoreRefEntityIds.add("adm_approve");
        this.SrmIgnoreRefEntityIds.add("adm_aptitude_in");
        this.SrmIgnoreRefEntityIds.add("adm_scene_in");
        this.SrmIgnoreRefEntityIds.add("adm_samplenotify_in");
        this.SrmIgnoreRefEntityIds.add("adm_sample_in");
        this.SrmIgnoreRefEntityIds.add("adm_material_in");
        this.SrmIgnoreRefEntityIds.add("adm_approve_in");
        this.SrmIgnoreRefEntityIds.add("pds_sup_aptitude");
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject bd_supplier;
            DynamicObject supplierregObj = dataEntity.getDataEntity();
            String status = supplierregObj.getString("status");
            if (!"C".equals(status)) continue;
            boolean supplierlifecycle = SupplierLifeCycleManagerUtil.isEnableSupplierLifeCycleManager();
            if (supplierlifecycle) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6ce8\u518c\u8d44\u6599\u5df2\u5ba1\u6279\u901a\u8fc7\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"SrmSupplierRegUnAuditValidator_3", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                continue;
            }
            Object pkValue = supplierregObj.getPkValue();
            Map<String, Object> resMap = this.isRefrencedSup("srm_supplier", pkValue, this.SrmIgnoreRefEntityIds);
            if (((Boolean)resMap.get("isRefrenced")).booleanValue()) {
                StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"\u8be5\u534f\u540c\u4f9b\u5e94\u5546\u5df2\u5728", (String)"SrmSupplierRegUnAuditValidator_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                msg.append(resMap.get("msg"));
                msg.append(ResManager.loadKDString((String)"\u4e0a\u5b58\u5728\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u9000\u56de\u4fee\u6539\u3002", (String)"SrmSupplierRegUnAuditValidator_1", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                this.addErrorMessage(dataEntity, msg.toString());
                continue;
            }
            DynamicObject supplier = supplierregObj.getDynamicObject("supplier");
            if (supplier == null || !((Boolean)(resMap = this.isRefrencedSup("bd_supplier", (bd_supplier = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", supplier.getPkValue())})).getPkValue(), this.BdIgnoreRefEntityIds)).get("isRefrenced")).booleanValue()) continue;
            StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"\u8be5\u4e3b\u6570\u636e\u4f9b\u5e94\u5546\u5df2\u5728", (String)"SrmSupplierRegUnAuditValidator_2", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            msg.append(resMap.get("msg"));
            msg.append(ResManager.loadKDString((String)"\u4e0a\u5b58\u5728\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u9000\u56de\u4fee\u6539\u3002", (String)"SrmSupplierRegUnAuditValidator_1", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            this.addErrorMessage(dataEntity, msg.toString());
        }
    }

    private Map<String, Object> isRefrencedSup(String billName, Object pkValue, Set<String> BdIgnoreRefEntityIds) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        resMap.put("isRefrenced", Boolean.FALSE);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        operateOption.setVariableValue("skipCheckDataPermission", String.valueOf(Boolean.TRUE));
        operateOption.setVariableValue("isStrict", String.valueOf(Boolean.FALSE));
        Map supplierRefrenced = BaseDataRefrenceHelper.checkRefrenced((String)billName, (Object[])new Object[]{pkValue}, BdIgnoreRefEntityIds, null, (OperateOption)operateOption);
        Collection values = supplierRefrenced.values();
        boolean flag = true;
        StringBuilder msg = new StringBuilder();
        for (BaseDataCheckRefrenceResult refrence : values) {
            String curRefenceKey = refrence.getRefenceKey().toString();
            if (!StringUtils.isNotBlank((CharSequence)curRefenceKey)) continue;
            int firstIndex = curRefenceKey.indexOf(44);
            if (firstIndex != -1) {
                curRefenceKey = curRefenceKey.substring(0, firstIndex);
            }
            DynamicObject dynamicObject = this.getTargetBillObj(curRefenceKey);
            LocaleString displayName = dynamicObject.getDynamicObjectType().getDisplayName();
            if (!flag) {
                msg.append(',');
            }
            flag = false;
            msg.append(displayName);
        }
        if (!supplierRefrenced.isEmpty()) {
            resMap.put("isRefrenced", Boolean.TRUE);
            resMap.put("msg", msg);
        }
        return resMap;
    }

    @Deprecated
    public static void addIgnoreRefList(String supType, String billName) {
    }

    private DynamicObject getTargetBillObj(String curRefenceKey) {
        return ORM.create().newDynamicObject(curRefenceKey);
    }
}

