/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.validator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.i18n.api.model.TelephoneVerifyResult;
import kd.bos.i18n.mservice.I18nServiceHelper;

public class SrmUserPhoneValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            List<String> phoneList;
            String msg;
            DynamicObject data = dataEntity.getDataEntity();
            String phone = data.getString("phone");
            if (!StringUtils.isNotBlank((CharSequence)phone) || StringUtils.isEmail((String)phone) || !StringUtils.isNotBlank((CharSequence)(msg = this.validatePhone(phoneList = Collections.singletonList(phone = this.getFullPhoneFormat(phone)))))) continue;
            this.addErrorMessage(dataEntity, msg);
        }
    }

    private String validatePhone(List<String> phoneList) {
        List resultList = I18nServiceHelper.batchVerifyTelephoneNumber(phoneList);
        StringBuilder msg = new StringBuilder();
        for (TelephoneVerifyResult item : resultList) {
            Map result;
            String message;
            if (!item.isParseSuccess()) {
                throw new KDBizException(item.getParseErrorMsg());
            }
            if (item.isVerifySuccess() || !StringUtils.isNotBlank((CharSequence)(message = CollectionUtils.isEmpty((Map)(result = item.getVerifyResult())) ? "" : (String)result.get("message")))) continue;
            msg.append(ResManager.loadResFormat((String)"\u8d26\u53f7(\u624b\u673a\u53f7/\u90ae\u7bb1)\uff1a%1", (String)"SrmUserPhoneValidator_0", (String)"scm-srm-opplugin", (Object[])new Object[]{message}));
            return msg.toString();
        }
        return msg.toString();
    }

    private String getFullPhoneFormat(String phone) {
        if (!phone.startsWith("+")) {
            phone = phone.contains("-") ? "+" + phone : "+86-" + phone;
        }
        return phone;
    }
}

