/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.scm.common.cloudkingdee.CompanyInfo;
import org.apache.commons.lang.StringUtils;

public class BusinessRulesServiceUtils {
    private static Log log = LogFactory.getLog(BusinessRulesServiceUtils.class);

    public static Object load(IDataModel model, Long orgId, String operateKey) throws IOException {
        DynamicObject dataEntity = model.getDataEntity();
        String billId = model.getDataEntityType().getName();
        Object result = DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"IBusinessRulesService", (String)"load", (Object[])new Object[]{orgId, billId, operateKey, dataEntity});
        log.info("\u8c03\u7528\u5c55\u793a\u7c7b\u63a5\u53e3\u8fd4\u56deresult:", (Object)JSONUtils.toString((Object)result));
        return result;
    }

    public static void input(IFormView view, IDataModel model, String propertyName, Object oldValue) {
        try {
            String oldStr;
            LocaleDynamicObjectCollection oldValueLocal;
            DynamicObject orCreateItemByLocaleId;
            String localeId = RequestContext.get().getLang().name();
            DynamicObject dataEntity = model.getDataEntity();
            ILocaleString newNameValue = dataEntity.getLocaleString("name");
            String newStr = "";
            if (Objects.nonNull(newNameValue) && StringUtils.isEmpty((String)(newStr = newNameValue.getLocaleValue()))) {
                return;
            }
            DynamicObject org = dataEntity.getDynamicObject("org");
            if (org == null) {
                return;
            }
            if (propertyName.equals("name") && Objects.nonNull(oldValue) && (orCreateItemByLocaleId = (oldValueLocal = (LocaleDynamicObjectCollection)oldValue).getOrCreateItemByLocaleId(localeId)) != null && newStr.equals(oldStr = orCreateItemByLocaleId.getString("name"))) {
                return;
            }
            Long orgId = (Long)org.getPkValue();
            model.beginInit();
            String billId = model.getDataEntityType().getName();
            Object result = DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"IBusinessRulesService", (String)"input", (Object[])new Object[]{orgId, billId, "input", dataEntity});
            log.info("\u8c03\u7528\u586b\u5145\u7c7b\u63a5\u53e3\u8fd4\u56de");
            Map map = (Map)result;
            Object success = map.get("success");
            log.info("\u8c03\u7528\u586b\u5145\u7c7b\u63a5\u53e3\u8fd4\u56de,success={}", success);
            if (success == null || !success.equals(true)) {
                return;
            }
            Object dataObj = map.get("data");
            if (!(dataObj instanceof DynamicObject)) {
                return;
            }
            DynamicObject data = (DynamicObject)dataObj;
            ArrayList<String> propNames = new ArrayList<String>(8);
            DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : properties) {
                Object value;
                String propName = iDataEntityProperty.getName();
                if (propName.equals(propertyName) || (value = data.get(propName)) == null) continue;
                model.setValue(propName, value);
                propNames.add(propName);
            }
            Map allEntities = model.getDataEntityType().getAllEntities();
            for (Map.Entry entry : allEntities.entrySet()) {
                DynamicObjectCollection dyc;
                String key = (String)entry.getKey();
                if (!data.containsProperty(key) || !CollectionUtils.isNotEmpty((Collection)(dyc = data.getDynamicObjectCollection(key)))) continue;
                TableValueSetter vs = new TableValueSetter(new String[0]);
                int rowindex = 0;
                for (DynamicObject dy : dyc) {
                    DataEntityPropertyCollection entryproperties = dy.getDataEntityType().getProperties();
                    for (IDataEntityProperty iDataEntityProperty : entryproperties) {
                        String propName = iDataEntityProperty.getName();
                        vs.set(propName, dy.get(propName), rowindex);
                    }
                    ++rowindex;
                }
                AbstractFormDataModel modelvs = (AbstractFormDataModel)model;
                modelvs.deleteEntryData(key);
                modelvs.batchCreateNewEntryRow(key, vs);
                propNames.add(key);
            }
            model.endInit();
            for (String key : propNames) {
                view.updateView(key);
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u586b\u5145\u7c7b\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
            log.error((Throwable)e);
            return;
        }
    }

    public static CompanyInfo loadBusinessInfos(DynamicObject dataEntity) {
        try {
            String newStr;
            DynamicObject org = dataEntity.getDynamicObject("org");
            if (org == null) {
                return null;
            }
            ILocaleString newNameValue = dataEntity.getLocaleString("name");
            if (Objects.nonNull(newNameValue) && StringUtils.isEmpty((String)(newStr = newNameValue.getLocaleValue()))) {
                return null;
            }
            Long orgId = (Long)org.getPkValue();
            ArrayList<String> entityKeys = new ArrayList<String>(Arrays.asList("srm_supplierreg", "adm_supplierreg"));
            Object result = DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"IBusinessRulesService", (String)"loadBusinessInfos", (Object[])new Object[]{orgId, entityKeys, "input", dataEntity});
            log.info("\u8c03\u7528\u83b7\u53d6\u5c55\u793a\u7c7b\u6570\u636e\u63a5\u53e3\u8fd4\u56de");
            Map map = (Map)result;
            Object success = map.get("success");
            log.info("\u8c03\u7528\u586b\u5145\u7c7b\u63a5\u53e3\u8fd4\u56de,success={}", success);
            if (success == null || !success.equals(true)) {
                return null;
            }
            Object dataObj = map.get("data");
            if (dataObj == null) {
                return null;
            }
            Map data = (Map)dataObj;
            CompanyInfo companyInfo = new CompanyInfo();
            Object societycreditcode = data.get("societycreditcode");
            Object artificialperson = data.get("artificialperson");
            Object regaddress = data.get("regaddress");
            Object regdate = data.get("regdate");
            if (!Objects.isNull(societycreditcode)) {
                companyInfo.setSocialCreditCode((String)societycreditcode);
            }
            if (!Objects.isNull(artificialperson)) {
                companyInfo.setLegalPerson((String)artificialperson);
            }
            if (!Objects.isNull(regaddress)) {
                companyInfo.setAddress((String)regaddress);
            }
            if (!Objects.isNull(regdate)) {
                companyInfo.setEstablisDate((Date)regdate);
            }
            return companyInfo;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u83b7\u53d6\u5c55\u793a\u7c7b\u6570\u636e\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
            log.error((Throwable)e);
            return null;
        }
    }
}

