/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.IOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmSupplierStatusEnum;

public interface SrmAptitudeOpTemplate
extends IOperationServicePlugIn {
    default public String fillNeedToChange(Map<String, List<String>> supplierMap, String opkey, List<String> needToChangeIds) {
        if (supplierMap == null) {
            return null;
        }
        String resultStatus = null;
        Set<String> supplierids = supplierMap.keySet();
        Set ids = supplierids.stream().map(x -> Long.parseLong(x)).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("supplier", "in", ids);
        QFilter joinQ = QFilter.join((String)"supplier_id", (String)"supplier.id", (QFilter)qFilter);
        QFilter supplierFilter = new QFilter("supplier.auditstatus", "=", (Object)SrmSupplierStatusEnum.APTITUDE.getValue());
        supplierFilter.and("auditstatus", "=", (Object)SrmSupplierStatusEnum.AUDIT.getValue());
        switch (opkey) {
            case "unaudit": {
                joinQ.and(supplierFilter);
                resultStatus = SrmSupplierStatusEnum.AUDIT.getValue();
                break;
            }
            case "audit": {
                joinQ.and(supplierFilter);
                resultStatus = SrmSupplierStatusEnum.APTITUDE.getValue();
                break;
            }
            case "reject": {
                supplierFilter = new QFilter("supplier.auditstatus", "=", (Object)SrmSupplierStatusEnum.UNAPTITUDE);
                supplierFilter.and("auditstatus", "=", (Object)SrmSupplierStatusEnum.UNAUDIT.getValue());
                QFilter supplierFilter1 = new QFilter("supplier.auditstatus", "=", (Object)SrmSupplierStatusEnum.APTITUDE);
                supplierFilter1.and("auditstatus", "=", (Object)SrmSupplierStatusEnum.AUDIT.getValue());
                supplierFilter.or(supplierFilter1);
                joinQ.and(supplierFilter);
                resultStatus = SrmSupplierStatusEnum.UNAPTITUDE.getValue();
                break;
            }
            case "rejection": {
                supplierFilter = new QFilter("supplier.auditstatus", "=", (Object)SrmSupplierStatusEnum.UNAPTITUDE);
                supplierFilter.and("auditstatus", "=", (Object)SrmSupplierStatusEnum.UNAUDIT.getValue());
                QFilter supplierFilter2 = new QFilter("supplier.auditstatus", "=", (Object)SrmSupplierStatusEnum.APTITUDE);
                supplierFilter2.and("auditstatus", "=", (Object)SrmSupplierStatusEnum.AUDIT.getValue());
                supplierFilter.or(supplierFilter2);
                joinQ.and(supplierFilter);
                resultStatus = SrmSupplierStatusEnum.AUDIT.getValue();
                break;
            }
        }
        HashMap resultMap = new HashMap();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"srm_aptitudeexam", (String)"id,supplier_id", (QFilter[])new QFilter[]{joinQ}, null);){
            dataSet.forEach(info -> {
                if (resultMap.containsKey(info.getString("supplier_id"))) {
                    ((List)resultMap.get(info.getString("supplier_id"))).add(info.getString("id"));
                } else {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(info.getString("id"));
                    resultMap.put(info.getString("supplier_id"), list);
                }
            });
        }
        supplierMap.forEach((key, value) -> {
            List list = (List)resultMap.get(key);
            if (list == null) {
                needToChangeIds.add((String)key);
            } else {
                list.removeAll((Collection<?>)value);
                if (list.size() == 0) {
                    needToChangeIds.add((String)key);
                }
            }
        });
        return resultStatus;
    }

    default public DynamicObject[] updateRefInfo(Map<String, List<String>> supplierMap, String opKey) {
        ArrayList<String> needToChangeIds = new ArrayList<String>();
        String newStatus = this.fillNeedToChange(supplierMap, opKey, needToChangeIds);
        if (newStatus != null && needToChangeIds.size() > 0) {
            DynamicObject[] dynamicObjects;
            for (DynamicObject supplierObj : dynamicObjects = BusinessDataServiceHelper.load((String)"pbd_suppliertpl", (String)"auditstatus,group", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)needToChangeIds.stream().mapToLong(s -> Long.parseLong(s)).toArray())})) {
                if (supplierObj == null || supplierObj.getString("auditstatus").equals(SrmSupplierStatusEnum.SUCCESS.getValue())) continue;
                supplierObj.set("auditstatus", (Object)newStatus);
            }
            return dynamicObjects;
        }
        return null;
    }

    default public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        String bizType = dynamicObjects[0].getString("biztype");
        boolean hasGroupId = dynamicObjects[0].getDataEntityType().getProperties().containsKey((Object)"group_id");
        if ("2".equals(bizType)) {
            String key = e.getOperationKey();
            ArrayList<String> list = null;
            HashMap<String, List<String>> supplierMap = new HashMap<String, List<String>>();
            HashMap<String, Long> groupMap = new HashMap<String, Long>();
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (hasGroupId) {
                    Long groupId = dynamicObject.getLong("group_id");
                    groupMap.put(dynamicObject.getString("supplier_id"), groupId);
                }
                if (supplierMap.containsKey(dynamicObject.getString("supplier_id"))) {
                    ((List)supplierMap.get(dynamicObject.getString("supplier_id"))).add(dynamicObject.getString("id"));
                    continue;
                }
                list = new ArrayList<String>();
                list.add(dynamicObject.getString("id"));
                supplierMap.put(dynamicObject.getString("supplier_id"), list);
            }
            DynamicObject[] objects = this.updateRefInfo(supplierMap, key);
            if (objects != null && objects.length > 0) {
                if (key.equals("audit")) {
                    Arrays.stream(objects).forEach(info -> {
                        Long groupId = (Long)groupMap.get(info.getString("id"));
                        if (groupId != null && groupId > 0L) {
                            info.set("group_id", (Object)groupId);
                        }
                    });
                }
                SaveServiceHelper.save((DynamicObject[])objects);
            }
        }
    }
}

