/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmAptitudeOpTemplate;

public class SrmCommonRejectOp
extends AbstractOperationServicePlugIn
implements SrmAptitudeOpTemplate {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        if (!fieldKeys.contains("biztype")) {
            e.getFieldKeys().add("biztype");
        }
        if (!fieldKeys.contains("auditopinion")) {
            e.getFieldKeys().add("auditopinion");
        }
        if (!fieldKeys.contains("auditstatus")) {
            e.getFieldKeys().add("auditstatus");
        }
        if (!fieldKeys.contains("supplier")) {
            e.getFieldKeys().add("supplier");
        }
        if (!fieldKeys.contains("aptitudeno")) {
            e.getFieldKeys().add("aptitudeno");
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        if (e.cancel) {
            return;
        }
        List validExtDataEntities = e.getValidExtDataEntities();
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject obj = extendedDataEntity.getDataEntity();
            String bizType = obj.getString("biztype");
            if ((bizType.equals("3") || bizType.equals("4") || bizType.equals("5") || bizType.equals("B")) && Objects.isNull(obj.getDynamicObject("aptitudeno"))) {
                obj.set("auditstatus", (Object)SrmSupplierStatusEnum.UNAUDIT.getValue());
                continue;
            }
            String status = null;
            switch (bizType) {
                case "1": {
                    status = SrmSupplierStatusEnum.UNAUDIT.getValue();
                    break;
                }
                case "2": {
                    break;
                }
                case "3": {
                    status = SrmSupplierStatusEnum.APTITUDE.getValue();
                    break;
                }
                case "4": {
                    status = SrmSupplierStatusEnum.APTITUDE.getValue();
                    break;
                }
                case "5": {
                    status = SrmSupplierStatusEnum.APTITUDE.getValue();
                    break;
                }
                case "6": {
                    status = SrmSupplierStatusEnum.UNAPROVE.getValue();
                    break;
                }
            }
            if (status != null) {
                DynamicObject supplierObj;
                long supplierId;
                long l = supplierId = this.billEntityType.getName().equals("srm_supplierreg") ? obj.getLong("id") : SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("supplier"));
                if (supplierId != 0L && (supplierObj = QueryRecordUtil.queryRecordSet((String)"srm_supplier", (String)"auditstatus", (String)"id", (Object)supplierId, null, null, null, null, null, null, null, (String)"loadBill", null)) != null && !supplierObj.getString("auditstatus").equals(SrmSupplierStatusEnum.SUCCESS.getValue())) {
                    supplierObj.set("auditstatus", (Object)status);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supplierObj});
                }
            }
            obj.set("auditstatus", (Object)SrmSupplierStatusEnum.UNAUDIT.getValue());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"reject")) {
            DynamicObject[] Objs;
            for (DynamicObject obj : Objs = e.getDataEntities()) {
                String bizType = obj.getString("biztype");
                if (bizType.equals("9") || bizType.equals("A") || bizType.equals("B") || (bizType.equals("3") || bizType.equals("4") || bizType.equals("5")) && Objects.isNull(obj.getDynamicObject("aptitudeno"))) continue;
                SrmCommonUtil.recordAuditInfo((DynamicObject)obj);
            }
        }
    }
}

