/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.BlackEnterpriseUtil;
import kd.scm.srm.common.SrmAptitudeOpTemplate;
import kd.scm.srm.common.SrmBillEditUtil;
import kd.scm.srm.common.SrmBillVerifyUtil;
import kd.scm.srm.common.SrmBlackListUtil;

public class SrmCommonUnAuditOp
extends AbstractOperationServicePlugIn
implements SrmAptitudeOpTemplate {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("number");
        fieldKeys.add("biztype");
        fieldKeys.add("auditstatus");
        fieldKeys.add("supplier");
        fieldKeys.add("aptitudeno");
        fieldKeys.add("auditopinion");
        fieldKeys.add("auditor");
        fieldKeys.add("auditdate");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List validExtDataEntities = e.getValidExtDataEntities();
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            long supplierId;
            DynamicObject supplierObj;
            DynamicObject obj = extendedDataEntity.getDataEntity();
            String bizType = obj.getString("biztype");
            Map<String, Object> resultMap = SrmBillVerifyUtil.isReferencedByOther(bizType, SrmCommonUtil.getPkValue((DynamicObject)obj));
            if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                e.setCancel(true);
                e.setCancelMessage(resultMap.get("message").toString());
                return;
            }
            if ((bizType.equals("3") || bizType.equals("4") || bizType.equals("5") || bizType.equals("B")) && Objects.isNull(obj.getDynamicObject("aptitudeno"))) {
                obj.set("auditstatus", (Object)SrmSupplierStatusEnum.INITIAL.getValue());
                obj.set("auditor", null);
                obj.set("auditdate", null);
                continue;
            }
            String status = null;
            switch (bizType) {
                case "1": {
                    break;
                }
                case "2": {
                    break;
                }
                case "3": {
                    status = SrmSupplierStatusEnum.APTITUDE.getValue();
                    break;
                }
                case "4": {
                    break;
                }
                case "5": {
                    break;
                }
                case "6": {
                    break;
                }
            }
            if (status != null && (supplierObj = QueryRecordUtil.queryRecordSet((String)"srm_supplier", (String)"auditstatus", (String)"id", (Object)(supplierId = SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("supplier"))), null, null, null, null, null, null, null, (String)"loadBill", null)) != null && !supplierObj.getString("auditstatus").equals(SrmSupplierStatusEnum.SUCCESS.getValue())) {
                supplierObj.set("auditstatus", (Object)status);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supplierObj});
            }
            if (bizType.equals("9")) {
                QFilter[] filters = new QFilter[]{new QFilter("sourceid", "=", (Object)obj.getLong("id"))};
                DynamicObject[] Objs = BusinessDataServiceHelper.load((String)"srm_blackenterprise", (String)"id,number,enable", (QFilter[])filters);
                BlackEnterpriseUtil.enableSrmSupStatus(Objs);
                SrmBlackListUtil.deleteFromBlackList("srm_blackenterprise", obj.getLong("id"));
            }
            if (bizType.equals("A")) {
                SrmBlackListUtil.deleteFromBlackList("srm_blackperson", obj.getLong("id"));
            }
            if ((bizType.equals("3") || bizType.equals("4") || bizType.equals("5") || bizType.equals("6")) && !enableNewAccessFlow) {
                SrmBillEditUtil.setAptitudeStatus(bizType, obj, false);
            }
            obj.set("auditstatus", (Object)SrmSupplierStatusEnum.INITIAL.getValue());
            obj.set("auditor", null);
            obj.set("auditdate", null);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
            DynamicObject[] Objs;
            for (DynamicObject obj : Objs = e.getDataEntities()) {
                String bizType = obj.getString("biztype");
                if (bizType.equals("9") || bizType.equals("A") || bizType.equals("B") || (bizType.equals("3") || bizType.equals("4") || bizType.equals("5")) && Objects.isNull(obj.getDynamicObject("aptitudeno"))) continue;
                SrmCommonUtil.recordAuditInfo((DynamicObject)obj);
            }
            String bizType = Objs[0].getString("biztype");
            if (bizType.equals("9")) {
                BlackEnterpriseUtil.enableSrmSupStatus(Objs);
            }
        }
    }
}

