/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.formula.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.Grouper;
import kd.bos.algox.JobSession;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.srm.common.formula.SrmGetAutoScoreReq;
import kd.scm.srm.common.formula.model.CalFunctionModel;
import kd.scm.srm.common.formula.model.SrmAutoCalCtxModel;
import kd.scm.srm.common.formula.model.SrmFormulaModel;
import kd.scm.srm.common.formula.service.ISrmCalService;
import kd.scm.srm.common.formula.utils.SrmDataSetTranFormUtils;
import kd.scm.srm.common.formula.utils.SrmReduceGroupFunction;

public class SrmCalAlgoXService
implements ISrmCalService {
    private static final Log LOG = LogFactory.getLog(SrmCalAlgoXService.class);

    @Override
    public SrmGetAutoScoreReq queryDataSet(SrmFormulaModel req, DynamicObject dy, SrmAutoCalCtxModel ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.info("algox\u8ba1\u7b97\u4e2d\uff0creq={}", (Object)req.toString());
        }
        try (DataSet queryDataSetAlgox = this.queryDataSet(ctx);){
            if (queryDataSetAlgox != null) {
                DataSet finishDataSet = null;
                finishDataSet = StringUtils.isNotEmpty((String)ctx.getOrderby()) ? queryDataSetAlgox.orderBy(new String[]{ctx.getOrderby()}) : queryDataSetAlgox.copy();
                SrmGetAutoScoreReq autoFormulaModel = SrmDataSetTranFormUtils.dataSetChangeToMap(finishDataSet, req, ctx);
                if (LOG.isDebugEnabled()) {
                    LOG.info("algox\u8ba1\u7b97\u7ed3\u679c\uff0cautoFormulaModel={}", (Object)autoFormulaModel.toString());
                }
                SrmGetAutoScoreReq srmGetAutoScoreReq = autoFormulaModel;
                return srmGetAutoScoreReq;
            }
            SrmGetAutoScoreReq srmGetAutoScoreReq = null;
            return srmGetAutoScoreReq;
        }
    }

    @Override
    public List<SrmGetAutoScoreReq> queryDataSetBatch(SrmFormulaModel req, DynamicObject dy, SrmAutoCalCtxModel ctx) {
        try (DataSet queryDataSetAlgox = this.queryDataSet(ctx);){
            if (queryDataSetAlgox != null) {
                List<SrmGetAutoScoreReq> dataSetMap;
                DataSet finishDataSet = null;
                finishDataSet = StringUtils.isNotEmpty((String)ctx.getOrderby()) ? queryDataSetAlgox.orderBy(new String[]{ctx.getOrderby()}) : queryDataSetAlgox.copy();
                List<SrmGetAutoScoreReq> list = dataSetMap = SrmDataSetTranFormUtils.dataSetChangeToMapBatch(finishDataSet, req, dy, ctx);
                return list;
            }
            ArrayList<SrmGetAutoScoreReq> arrayList = new ArrayList<SrmGetAutoScoreReq>(1);
            return arrayList;
        }
    }

    public DataSet queryDataSet(SrmAutoCalCtxModel ctx) {
        LOG.info("==============Algox\u8ba1\u7b97\u5f00\u59cb==============");
        JobSession job = AlgoX.createSession((String)("SrmCalAlgoX_" + ctx.getMetadataCode()));
        ctx.setCurrentJob(job);
        List<QFilter> qFList = this.segmentQfilter(ctx);
        Input[] inputs = new Input[qFList.size()];
        for (int i = 0; i < qFList.size(); ++i) {
            OrmInput ormInput = new OrmInput("queryDataSet", ctx.getMetadataCode(), ctx.getQueryFields(), new QFilter[]{qFList.get(i)});
            inputs[i] = ormInput;
        }
        if (inputs.length == 0) {
            return null;
        }
        DataSetX dataX = null;
        dataX = job.fromInput(inputs);
        if (dataX == null) {
            return null;
        }
        dataX = this.transFormDataX(dataX, ctx);
        RowMeta rowMeta = dataX.getRowMeta();
        this.setDataType(rowMeta);
        DataSetOutput out = new DataSetOutput(rowMeta);
        String id = out.getId();
        dataX.output((Output)out);
        job.commit(ctx.getTimeOut().intValue(), TimeUnit.MINUTES);
        DataSet result = job.readDataSet(id);
        LOG.info("==============Algox\u8ba1\u7b97\u7ed3\u675f==============");
        return result;
    }

    private void setDataType(RowMeta rowMeta) {
        Field[] fields;
        for (Field field : fields = rowMeta.getFields()) {
            if (!DataType.UnknownType.getName().equals(field.getDataType().getName())) continue;
            field.setDataType((DataType)DataType.BigDecimalType);
        }
    }

    private DataSetX transFormDataX(DataSetX dataSetX, SrmAutoCalCtxModel ctx) {
        if (StringUtils.isNotEmpty((String)ctx.getOrderby())) {
            dataSetX.orderBy(new String[]{ctx.getOrderby()});
        }
        String groupFields = ctx.getGroupFields();
        List<CalFunctionModel> functions = ctx.getFunctions();
        if (StringUtils.isNotEmpty((String)groupFields) || !CollectionUtils.isEmpty(functions)) {
            String[] groupby = groupFields.split(",");
            RowMeta srcRowMeta = dataSetX.getRowMeta();
            RowMeta tarRowMeta = this.createTargetRowMeta(srcRowMeta, functions);
            Grouper grouper = dataSetX.groupBy(groupby);
            if (!CollectionUtils.isEmpty(functions)) {
                String functionName = functions.get(0).getFunctionName();
                String childExpr = functions.get(0).getChildExpr();
                String alias = functions.get(0).getAlias();
                dataSetX = "count".equals(functionName) ? grouper.count(childExpr, alias) : ("countDistinct".equals(functionName) ? grouper.count(childExpr, alias) : grouper.reduceGroup((GroupReduceFunction)new SrmReduceGroupFunction(srcRowMeta, tarRowMeta, functions)));
            }
        }
        Map<String, Object> params = ctx.getAfterFilterParams();
        String newAfterFilterExpr = ctx.getAfterFilterExpr();
        if (StringUtils.isNotEmpty((String)newAfterFilterExpr)) {
            dataSetX = CollectionUtils.isEmpty(params) ? dataSetX.filter(newAfterFilterExpr) : dataSetX.filter(newAfterFilterExpr, params);
        }
        return dataSetX;
    }

    private RowMeta createTargetRowMeta(RowMeta srcRowMeta, List<CalFunctionModel> functions) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        for (Field field : srcRowMeta.getFields()) {
            map.put(field.getName(), field.getDataType());
        }
        for (CalFunctionModel function : functions) {
            String alias = function.getAlias();
            if (map.containsKey(alias)) continue;
            map.put(alias, DataType.BigDecimalType);
        }
        String[] fieldArray = map.keySet().toArray(new String[map.size()]);
        DataType[] dataTypeArray = map.values().toArray(new DataType[map.size()]);
        RowMeta createRowMeta = RowMetaFactory.createRowMeta((String[])fieldArray, (DataType[])dataTypeArray);
        return createRowMeta;
    }

    private List<QFilter> segmentQfilter(SrmAutoCalCtxModel ctx) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(8);
        QFilter fs = ctx.getBeforeQFilter();
        filterList.add(fs);
        return filterList;
    }
}

