/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.formula.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.BinaryExpr;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.Operator;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.DateUtil;
import kd.scm.srm.common.formula.model.CRFormulaModel;
import kd.scm.srm.common.formula.utils.AutoFormulaUtils;

public class FormulaHelper {
    private static final String FOCUS = "focus";
    private static final Log log = LogFactory.getLog(AutoFormulaUtils.class);
    private static final String[] OPERATERS = new String[]{"+", "-", "*", "/", "!=", "<>", "<=", ">=", "=", "<", ">"};
    private static final String CURSOR_INDEX = "cursorIndex";
    private static final String CTRL_KEY = "ctrlKey";
    private static final String SET_TEXTAREA_CURSOR_POSITION = "setTextareaCursorPosition";
    private static final String FDESCRIPTION = "fdescription";
    private static final String FTRANEXPR = "ftranexpr";
    private static final String FEXPRESSION = "fexpression";
    private static final String TV_FIELDS = "tv_fields";
    private static final String HEADNODEID = "0";

    public static void insertExpression(IFormView view, String buttonKey, String textFieldKey, String str) {
        int cursorIndex;
        int pos = FormulaHelper.getCursorIndex(view, buttonKey, textFieldKey);
        String expression = (String)view.getModel().getValue(textFieldKey);
        if (StringUtils.isBlank((CharSequence)expression)) {
            expression = str;
            cursorIndex = str.length();
        } else {
            String insertStr = " " + str + " ";
            expression = FormulaHelper.insertCharacter(expression, insertStr, pos);
            cursorIndex = pos + insertStr.length();
        }
        view.getModel().setValue(textFieldKey, (Object)expression);
        HashMap<String, Object> cursorMap = new HashMap<String, Object>(8);
        cursorMap.put(CURSOR_INDEX, cursorIndex);
        cursorMap.put(CTRL_KEY, textFieldKey);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction(SET_TEXTAREA_CURSOR_POSITION, cursorMap);
    }

    public static void backSpaceExpression(IFormView view, String buttonKey, String textFieldKey) {
        String expression = (String)view.getModel().getValue(textFieldKey);
        if (!StringUtils.isBlank((CharSequence)expression)) {
            int cursorIndex = FormulaHelper.getCursorIndex(view, buttonKey, textFieldKey);
            String part1 = expression.substring(0, cursorIndex);
            String part2 = expression.substring(cursorIndex);
            String partDel = part1;
            for (String str : OPERATERS) {
                int lastIndex = partDel.lastIndexOf(str);
                if (lastIndex <= 0 || !"".equals((partDel = partDel.substring(lastIndex + str.length())).trim())) continue;
                partDel = str;
                break;
            }
            String[] fieldList = partDel.split(" ");
            for (int i = fieldList.length - 1; i >= 0; --i) {
                if ("".equals(fieldList[i].trim())) continue;
                partDel = fieldList[i];
                break;
            }
            expression = part1.substring(0, part1.lastIndexOf(partDel)) + part2;
            cursorIndex = part1.substring(0, part1.lastIndexOf(partDel)).length();
            view.getModel().setValue(textFieldKey, (Object)expression);
            HashMap<String, Object> cursorMap = new HashMap<String, Object>(8);
            cursorMap.put(CURSOR_INDEX, cursorIndex);
            cursorMap.put(CTRL_KEY, textFieldKey);
            IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            proxy.addAction(SET_TEXTAREA_CURSOR_POSITION, cursorMap);
        }
    }

    public static String insertCharacter(String pStr, String str, int pos) {
        int i;
        if (pStr.length() < pos) {
            pos = pStr.length();
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < pos; ++i) {
            sb.append(pStr.charAt(i));
        }
        sb.append(str);
        for (i = pos; i < pStr.length(); ++i) {
            sb.append(pStr.charAt(i));
        }
        return sb.toString();
    }

    public static int getCursorIndex(IFormView view, String buttonKey, String textFieldKey) {
        String textValue = (String)view.getModel().getValue(textFieldKey);
        int cursorIndex = StringUtils.isBlank((CharSequence)textValue) ? 0 : textValue.length();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Object listPostData = proxy.getViewState(buttonKey);
        if (listPostData instanceof Map) {
            Map map = (Map)listPostData;
            if (map.get(FOCUS) != null) {
                Map focus = (Map)map.get(FOCUS);
                if (focus.get(textFieldKey) != null) {
                    cursorIndex = (Integer)focus.get(textFieldKey);
                }
            } else if (map.get(textFieldKey) != null) {
                cursorIndex = (Integer)map.get(textFieldKey);
            }
        }
        return cursorIndex;
    }

    public static void setCursorIndex(IFormView view, String textFieldKey, int focusIndex) {
        HashMap<String, Object> cursorMap = new HashMap<String, Object>(8);
        cursorMap.put(CURSOR_INDEX, focusIndex);
        cursorMap.put(CTRL_KEY, textFieldKey);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction(SET_TEXTAREA_CURSOR_POSITION, cursorMap);
    }

    public static CRFormulaModel deserialize(String json) {
        CRFormulaModel formulaObj = null;
        formulaObj = StringUtils.isEmpty((CharSequence)json) ? new CRFormulaModel() : (CRFormulaModel)SerializationUtils.fromJsonString((String)json, CRFormulaModel.class);
        return formulaObj;
    }

    public static String tranExpression(String expression, String json) {
        String[] vars = FormulaHelper.extractVariables(expression);
        String tranExpression = FormulaHelper.tranExpression(expression, json, vars);
        return tranExpression;
    }

    public static String tranExpression(String expression, String json, String[] vars) {
        String expressionDesc = expression;
        if (vars == null || vars.length == 0 || StringUtils.isBlank((CharSequence)vars[0])) {
            return expressionDesc;
        }
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        }
        ArrayList<String> orderVars = new ArrayList<String>(10);
        for (String string : vars) {
            orderVars.add(string);
        }
        orderVars.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() < o2.length()) {
                    return 1;
                }
                return o2.compareTo(o1);
            }
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(16);
        int i = 1;
        for (String string : orderVars) {
            String tempVariable = String.format("###%s###", String.valueOf(i));
            String varCaption = string;
            TreeNode node = rootNode.getTreeNode(string, 5);
            if (node != null) {
                varCaption = node.getText();
            } else {
                String curNodeId;
                TreeNode curNode;
                String[] split = string.split("\\.", 2);
                if (split.length > 1 && (curNode = rootNode.getTreeNode(curNodeId = split[1], 5)) != null) {
                    varCaption = curNode.getText();
                }
            }
            tmpVariables.put(tempVariable, varCaption);
            expressionDesc = expressionDesc.replace(string, tempVariable);
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }

    public static void getFormulaObj(IDataModel model, CRFormulaModel formulaObj) {
        String expression = (String)model.getValue(FEXPRESSION);
        formulaObj.setExpression(expression);
        String desc = (String)model.getValue(FDESCRIPTION);
        formulaObj.getDescription().setItem(Lang.defaultLang().toString(), (Object)desc);
        String tranexpr = (String)model.getValue(FTRANEXPR);
        formulaObj.getLocaleExprTran().setItem(Lang.defaultLang().toString(), (Object)tranexpr);
    }

    public static void initData(IDataModel model, String conditonJson) {
        CRFormulaModel formulaObj = FormulaHelper.deserialize(conditonJson);
        model.setValue(FEXPRESSION, (Object)formulaObj.getExpression());
        if (!formulaObj.getLocaleExprTran().isEmpty()) {
            model.setValue(FTRANEXPR, (Object)formulaObj.getLocaleExprTran().getLocaleValue());
        }
    }

    public static void fillTreeNodes(IFormView view, String strJson) {
        TreeNode node = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)view.getControl(TV_FIELDS);
        tree.addNode(node);
    }

    public static void addTreeRootNode(IFormView view) {
        TreeNode root = new TreeNode("", HEADNODEID, ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5217\u8868", (String)"FormulaHelper_0", (String)"scm-srm-common", (Object[])new Object[0]));
        TreeView tree = (TreeView)view.getControl(TV_FIELDS);
        tree.addNode(root);
    }

    public static String[] extractVariables(String expression) {
        String[] vars = FormulaEngine.extractVariables((String)expression);
        return vars;
    }

    public static BigDecimal execFormula(String newExpr, Map<String, Object> varMap) {
        try {
            Set<Map.Entry<String, Object>> entrySet = varMap.entrySet();
            Boolean isDate = false;
            for (Map.Entry<String, Object> entry : entrySet) {
                Object value = entry.getValue();
                if (!(value instanceof Date)) continue;
                isDate = true;
            }
            if (isDate.booleanValue()) {
                return FormulaHelper.executeDate(newExpr, varMap);
            }
            Object curResult = FormulaEngine.execExcelFormula((String)newExpr, varMap);
            return new BigDecimal(curResult.toString());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private static BigDecimal executeDate(String newExpr, Map<String, Object> varMap) {
        Expr parseFormula = FormulaHelper.parseFormula(newExpr);
        if (parseFormula instanceof BinaryExpr) {
            BinaryExpr expr = (BinaryExpr)parseFormula;
            Expr left = expr.getLeft();
            Operator operator = expr.getOperator();
            Expr right = expr.getRight();
            Date dateLeft = null;
            dateLeft = left.toString().equals("now()") ? new Date() : (Date)varMap.get(left.toString());
            Date rightLeft = null;
            rightLeft = right.toString().equals("now()") ? new Date() : (Date)varMap.get(right.toString());
            if (Operator.MINUS.getName().equals(operator.getName())) {
                int daysBetween = DateUtil.daysBetween((Date)dateLeft, (Date)rightLeft);
                return new BigDecimal(daysBetween);
            }
        }
        log.warn("\u5f53\u524d\u8868\u8fbe\u5f0f\u4e0d\u7b26\u5408\u8ba1\u7b97\u903b\u8f91\uff0c\u4e0d\u652f\u6301\u8ba1\u7b97expr={}", (Object)newExpr);
        return null;
    }

    public static Expr parseFormula(String formula) {
        Expr filterFormula = null;
        if (StringUtils.isNotEmpty((CharSequence)formula)) {
            filterFormula = FormulaEngine.parseFormula((String)formula);
        }
        return filterFormula;
    }
}

