/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.formula.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.srm.common.enums.SrmCalResultStatus;
import kd.scm.srm.common.enums.SrmEvaDimensionEnum;
import kd.scm.srm.common.formula.SrmGetAutoScoreReq;
import kd.scm.srm.common.formula.model.SrmFormulaModel;
import kd.scm.srm.common.formula.utils.AutoFormulaUtils;
import kd.scm.srm.common.formula.utils.FormulaHelper;
import org.apache.commons.lang3.StringUtils;

public class SrmCalResultHelper {
    private static final Log LOG = LogFactory.getLog(SrmCalResultHelper.class);

    public static DynamicObject calFinalFormula(DynamicObject load, SrmFormulaModel req, String formula) {
        if (load != null) {
            DynamicObjectCollection dynamicObjectCollection = load.getDynamicObjectCollection("entryentity");
            if (!dynamicObjectCollection.isEmpty()) {
                for (DynamicObject dy : dynamicObjectCollection) {
                    Boolean bool = SrmCalResultHelper.filterData(req, dy);
                    if (!bool.booleanValue()) continue;
                    Map<String, Object> variableMap = SrmCalResultHelper.buildFormulaParam(dy);
                    try {
                        String status = dy.getString("status");
                        if (!SrmCalResultStatus.CAL_ERROR.getVal().equals(status)) {
                            dy.set("status", (Object)SrmCalResultStatus.CALED.getVal());
                        }
                        BigDecimal execExcelFormula = FormulaHelper.execFormula(formula, variableMap);
                        execExcelFormula = execExcelFormula.setScale(10, RoundingMode.HALF_UP);
                        dy.set("result", (Object)execExcelFormula);
                    }
                    catch (Exception e) {
                        dy.set("status", (Object)SrmCalResultStatus.CAL_ERROR.getVal());
                        dy.set("result", (Object)BigDecimal.ZERO);
                    }
                }
            }
            SrmCalResultHelper.saveCalResult(load);
        }
        return load;
    }

    public static List<SrmGetAutoScoreReq> getCalResultList(DynamicObject load, SrmFormulaModel req) {
        DynamicObjectCollection dynamicObjectCollection;
        ArrayList<SrmGetAutoScoreReq> list = new ArrayList<SrmGetAutoScoreReq>(8);
        if (load != null && !(dynamicObjectCollection = load.getDynamicObjectCollection("entryentity")).isEmpty()) {
            for (DynamicObject dy : dynamicObjectCollection) {
                Boolean bool = SrmCalResultHelper.filterData(req, dy);
                if (!bool.booleanValue()) continue;
                String status = dy.getString("status");
                Long scoretaskid = dy.getLong("scoretaskid");
                Long indexscoredetailid = dy.getLong("indexscoredetailid");
                Long supplierId = SrmCalResultHelper.getSupplierId(dy);
                Long materialId = SrmCalResultHelper.getMaterialId(dy);
                Long categoryId = SrmCalResultHelper.getCategoryId(dy);
                SrmGetAutoScoreReq autoFormulaResp = new SrmGetAutoScoreReq();
                autoFormulaResp.setEvaplanId(req.getEvaplanId());
                autoFormulaResp.setIndexScoreDetailId(indexscoredetailid);
                autoFormulaResp.setScoreTaskId(scoretaskid);
                autoFormulaResp.setIndexId(req.getIndexId());
                autoFormulaResp.setCategoryId(categoryId);
                autoFormulaResp.setMaterialId(materialId);
                autoFormulaResp.setSupplierId(supplierId);
                autoFormulaResp.setResult(dy.getBigDecimal("result"));
                if (!SrmCalResultStatus.CALED.getVal().equals(status)) continue;
                list.add(autoFormulaResp);
            }
        }
        return list;
    }

    private static Boolean filterData(SrmFormulaModel req, DynamicObject dy) {
        Long supplierId = SrmCalResultHelper.getSupplierId(dy);
        Long materialId = SrmCalResultHelper.getMaterialId(dy);
        Long categoryId = SrmCalResultHelper.getCategoryId(dy);
        Boolean bool = false;
        String evaDimension = req.getEvaDimension();
        bool = req.isBatch() ? (SrmEvaDimensionEnum.MATERIAL_DIMENSION.getVal().equals(evaDimension) ? Boolean.valueOf(req.getSupplierId() != null && supplierId.equals(req.getSupplierId()) && !CollectionUtils.isEmpty(req.getMaterialIds()) && req.getMaterialIds().containsKey(materialId)) : (SrmEvaDimensionEnum.CATEGORY_DIMENSION.getVal().equals(evaDimension) ? Boolean.valueOf(req.getSupplierId() != null && supplierId.equals(req.getSupplierId()) && !CollectionUtils.isEmpty(req.getCategoryIds()) && req.getCategoryIds().containsKey(categoryId)) : Boolean.valueOf(!CollectionUtils.isEmpty(req.getSupplierIds()) && req.getSupplierIds().containsKey(supplierId)))) : (SrmEvaDimensionEnum.MATERIAL_DIMENSION.getVal().equals(evaDimension) ? Boolean.valueOf(req.getSupplierId() != null && supplierId.equals(req.getSupplierId()) && req.getMaterialId() != null && materialId.equals(req.getMaterialId())) : (SrmEvaDimensionEnum.CATEGORY_DIMENSION.getVal().equals(evaDimension) ? Boolean.valueOf(req.getSupplierId() != null && supplierId.equals(req.getSupplierId()) && req.getCategoryId() != null && categoryId.equals(req.getCategoryId())) : Boolean.valueOf(req.getSupplierId() != null && supplierId.equals(req.getSupplierId()))));
        return bool;
    }

    private static Map<String, Object> buildFormulaParam(DynamicObject dy) {
        HashMap<String, Object> variableMap = new HashMap<String, Object>(8);
        BigDecimal result1 = dy.getBigDecimal("result1");
        BigDecimal result2 = dy.getBigDecimal("result2");
        BigDecimal result3 = dy.getBigDecimal("result3");
        BigDecimal result4 = dy.getBigDecimal("result4");
        BigDecimal result5 = dy.getBigDecimal("result5");
        variableMap.put("result1", result1);
        variableMap.put("result2", result2);
        variableMap.put("result3", result3);
        variableMap.put("result4", result4);
        variableMap.put("result5", result5);
        return variableMap;
    }

    public static DynamicObject getCalResult(Long orgId, Long evaplanId, Long formulaId, String evaDimension) {
        StringBuilder sb = new StringBuilder();
        sb.append("id,org,srmindex,evaplanname,evaplanid,calformula,formula,datefrom,dateto,evadimension,formulatran,").append("entryentity").append(".").append("indexscoredetailid").append(",").append("entryentity").append(".").append("scoretaskid").append(",").append("entryentity").append(".").append("supplier").append(",").append("entryentity").append(".").append("category").append(",").append("entryentity").append(".").append("material").append(",").append("entryentity").append(".").append("status").append(",").append("entryentity").append(".").append("result1").append(",").append("entryentity").append(".").append("result2").append(",").append("entryentity").append(".").append("result3").append(",").append("entryentity").append(".").append("result4").append(",").append("entryentity").append(".").append("result5").append(",").append("entryentity").append(".").append("result");
        QFilter filters = new QFilter("org", "=", (Object)orgId);
        filters.and("evaplanid", "=", (Object)evaplanId);
        filters.and("calformula", "=", (Object)formulaId);
        filters.and("evadimension", "=", (Object)evaDimension);
        DynamicObject load = BusinessDataServiceHelper.loadSingle((String)"srm_cal_result", (String)sb.toString(), (QFilter[])new QFilter[]{filters});
        return load;
    }

    public static DynamicObject getCalResult(SrmFormulaModel req) {
        StringBuilder sb = new StringBuilder();
        sb.append("id,org,srmindex,evaplanname,evaplanid,calformula,formula,datefrom,dateto,evadimension,formulatran,").append("entryentity").append(".").append("indexscoredetailid").append(",").append("entryentity").append(".").append("scoretaskid").append(",").append("entryentity").append(".").append("supplier").append(",").append("entryentity").append(".").append("category").append(",").append("entryentity").append(".").append("material").append(",").append("entryentity").append(".").append("status").append(",").append("entryentity").append(".").append("result1").append(",").append("entryentity").append(".").append("result2").append(",").append("entryentity").append(".").append("result3").append(",").append("entryentity").append(".").append("result4").append(",").append("entryentity").append(".").append("result5").append(",").append("entryentity").append(".").append("result");
        QFilter filters = new QFilter("org", "=", (Object)req.getOrgId());
        filters.and("evaplanid", "=", (Object)req.getEvaplanId());
        filters.and("calformula", "=", (Object)req.getFormulaId());
        filters.and("evadimension", "=", (Object)req.getEvaDimension());
        DynamicObject load = BusinessDataServiceHelper.loadSingle((String)"srm_cal_result", (String)sb.toString(), (QFilter[])new QFilter[]{filters});
        return load;
    }

    public static void saveOrNewCalResult(List<SrmGetAutoScoreReq> list, SrmFormulaModel model, String entityCode) {
        DynamicObject loadCal = SrmCalResultHelper.getCalResult(model);
        DynamicObject calDy = SrmCalResultHelper.saveOrNewCalResult(loadCal, list, model, "", entityCode);
        SrmCalResultHelper.updateStatus(calDy, model);
        SrmCalResultHelper.saveCalResult(calDy);
    }

    private static DynamicObject updateStatus(DynamicObject load, SrmFormulaModel req) {
        DynamicObjectCollection dynamicObjectCollection;
        if (load != null && !(dynamicObjectCollection = load.getDynamicObjectCollection("entryentity")).isEmpty()) {
            for (DynamicObject dy : dynamicObjectCollection) {
                String status = dy.getString("status");
                if (SrmCalResultStatus.CAL_ERROR.getVal().equals(status)) continue;
                dy.set("status", (Object)SrmCalResultStatus.CALED.getVal());
            }
        }
        return load;
    }

    public static DynamicObject saveOrNewCalResult(DynamicObject loadCal, List<SrmGetAutoScoreReq> list, SrmFormulaModel req, String formula, String entitycode) {
        for (SrmGetAutoScoreReq model : list) {
            loadCal = SrmCalResultHelper.saveOrNewCalResult(loadCal, model, req, formula, entitycode);
        }
        return loadCal;
    }

    public static DynamicObject saveOrNewCalResult(DynamicObject loadCal, SrmGetAutoScoreReq model, SrmFormulaModel req, String formula, String entityCode) {
        LOG.info("\u4fdd\u5b58\u5206\u6b65\u8ba1\u7b97\u7ed3\u679c\u5f00\u59cb\uff0csrmAutoFormulaReq={}", (Object)model.toString());
        Long orgId = req.getOrgId();
        String evaDimension = req.getEvaDimension();
        if (loadCal == null) {
            loadCal = SrmCalResultHelper.getCalResult(req);
        }
        if (loadCal != null) {
            loadCal.set("formula", (Object)formula);
            String tranFormula = SrmCalResultHelper.tranFormula(formula);
            loadCal.set("formulatran", (Object)tranFormula);
            loadCal.set("datefrom", (Object)req.getStartDate());
            loadCal.set("dateto", (Object)req.getEndDate());
            String evaplanName = SrmCalResultHelper.getEvaplanName(req.getEvaplanId());
            loadCal.set("evaplanname", (Object)evaplanName);
            loadCal.set("evadimension", (Object)evaDimension);
            Object srmindex = loadCal.get("srmindex");
            if (srmindex != null) {
                loadCal.set("srmindex_id", (Object)req.getIndexId());
            } else {
                loadCal.set("srmindex", (Object)req.getIndexId());
            }
            DynamicObjectCollection dynamicObjectCollection = loadCal.getDynamicObjectCollection("entryentity");
            DynamicObject dy1 = null;
            for (DynamicObject dy : dynamicObjectCollection) {
                String key;
                Long materialId = SrmCalResultHelper.getMaterialId(dy);
                Long supplierId = SrmCalResultHelper.getSupplierId(dy);
                String keyNew = AutoFormulaUtils.buildHashKey(orgId, evaDimension, model.getSupplierId(), model.getMaterialId());
                if (SrmEvaDimensionEnum.CATEGORY_DIMENSION.getVal().equals(evaDimension)) {
                    materialId = SrmCalResultHelper.getCategoryId(dy);
                    keyNew = AutoFormulaUtils.buildHashKey(orgId, evaDimension, model.getSupplierId(), model.getCategoryId());
                }
                if (!(key = AutoFormulaUtils.buildHashKey(orgId, evaDimension, supplierId, materialId)).equals(keyNew)) continue;
                dy.set("scoretaskid", (Object)model.getScoreTaskId());
                dy.set("indexscoredetailid", (Object)model.getIndexScoreDetailId());
                dy1 = dy;
                break;
            }
            if (dy1 == null) {
                SrmCalResultHelper.insertEntryEntity(model, entityCode, dynamicObjectCollection);
            } else {
                SrmCalResultHelper.setStatus(model, dy1);
                dy1.set(entityCode, (Object)model.getResult());
            }
        } else {
            loadCal = BusinessDataServiceHelper.newDynamicObject((String)"srm_cal_result");
            String evaplanName = SrmCalResultHelper.getEvaplanName(req.getEvaplanId());
            loadCal.set("org", (Object)orgId);
            loadCal.set("evaplanid", (Object)req.getEvaplanId());
            loadCal.set("calformula", (Object)req.getFormulaId());
            loadCal.set("srmindex", (Object)req.getIndexId());
            loadCal.set("datefrom", (Object)req.getStartDate());
            loadCal.set("dateto", (Object)req.getEndDate());
            loadCal.set("evaplanname", (Object)evaplanName);
            loadCal.set("evadimension", (Object)evaDimension);
            loadCal.set("billstatus", (Object)"C");
            loadCal.set("formula", (Object)formula);
            String tranFormula = SrmCalResultHelper.tranFormula(formula);
            loadCal.set("formulatran", (Object)tranFormula);
            String number = CodeRuleServiceHelper.getNumber((String)"srm_cal_result", (DynamicObject)loadCal, (String)String.valueOf(RequestContext.get().getOrgId()));
            loadCal.set("billno", (Object)number);
            DynamicObjectCollection dynamicObjectCollection = loadCal.getDynamicObjectCollection("entryentity");
            SrmCalResultHelper.insertEntryEntity(model, entityCode, dynamicObjectCollection);
        }
        LOG.info("\u4fdd\u5b58\u5206\u6b65\u8ba1\u7b97\u7ed3\u679c\u7ed3\u675f\uff0csrmAutoFormulaReq={}", (Object)model.toString());
        return loadCal;
    }

    public static void saveCalResult(DynamicObject load) {
        if (load != null) {
            SaveServiceHelper.saveOperate((String)"srm_cal_result", (DynamicObject[])new DynamicObject[]{load}, (OperateOption)OperateOption.create());
        }
    }

    private static Long getSupplierId(DynamicObject dy) {
        Long supplierId = 0L;
        Object supplierDy = dy.get("supplier");
        if (supplierDy != null) {
            supplierId = supplierDy instanceof Long ? (Long)supplierDy : (Long)((DynamicObject)supplierDy).getPkValue();
        }
        return supplierId;
    }

    private static Long getMaterialId(DynamicObject dy) {
        Long materialId = 0L;
        Object materialDy = dy.get("material");
        if (materialDy != null) {
            materialId = materialDy instanceof Long ? (Long)materialDy : (Long)((DynamicObject)materialDy).getPkValue();
        }
        return materialId;
    }

    private static Long getCategoryId(DynamicObject dy) {
        Long categoryId = 0L;
        Object categoryDy = dy.get("category");
        if (categoryDy != null) {
            categoryId = categoryDy instanceof Long ? (Long)categoryDy : (Long)((DynamicObject)categoryDy).getPkValue();
        }
        return categoryId;
    }

    private static String getEvaplanName(Object srmEvaplanPkId) {
        String selectFields = "id,billno,name";
        try {
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingleFromCache((String)"srm_evaplan", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(srmEvaplanPkId.toString()))});
            if (loadSingle == null) {
                loadSingle = BusinessDataServiceHelper.loadSingleFromCache((String)"srm_evaplan_batch", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(srmEvaplanPkId.toString()))});
            }
            if (loadSingle == null) {
                return "";
            }
            String name = loadSingle.getString("name");
            return name;
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String tranFormula(String formula) {
        if (StringUtils.isBlank((CharSequence)formula)) {
            return "";
        }
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"srm_cal_result");
        DynamicObject entryEntity = dy.getDynamicObjectCollection("entryentity").addNew();
        String json = AutoFormulaUtils.bulidNodesJson(entryEntity, "entryentity", true);
        String tranFormula = FormulaHelper.tranExpression(formula, json);
        return tranFormula;
    }

    private static void insertEntryEntity(SrmGetAutoScoreReq model, String entityCode, DynamicObjectCollection dynamicObjectCollection) {
        DynamicObject entryEntity = null;
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"srm_cal_result");
            entryEntity = dy.getDynamicObjectCollection("entryentity").addNew();
            if (entryEntity.containsProperty(entityCode)) {
                entryEntity.set(entityCode, (Object)model.getResult());
            }
            SrmCalResultHelper.setStatus(model, entryEntity);
            entryEntity.set("scoretaskid", (Object)model.getScoreTaskId());
            entryEntity.set("indexscoredetailid", (Object)model.getIndexScoreDetailId());
            if (model.getSupplierId() != null) {
                entryEntity.set("supplier", (Object)model.getSupplierId());
            }
            if (model.getMaterialId() != null) {
                entryEntity.set("material", (Object)model.getMaterialId());
            }
            if (model.getCategoryId() != null) {
                entryEntity.set("category", (Object)model.getCategoryId());
            }
            dynamicObjectCollection.add((Object)entryEntity);
        } else {
            entryEntity = dynamicObjectCollection.addNew();
            SrmCalResultHelper.setStatus(model, entryEntity);
            if (entryEntity.containsProperty(entityCode)) {
                entryEntity.set(entityCode, (Object)model.getResult());
            }
            entryEntity.set("scoretaskid", (Object)model.getScoreTaskId());
            entryEntity.set("indexscoredetailid", (Object)model.getIndexScoreDetailId());
            if (model.getSupplierId() != null) {
                entryEntity.set("supplier", (Object)model.getSupplierId());
            }
            if (model.getMaterialId() != null) {
                entryEntity.set("material", (Object)model.getMaterialId());
            }
            if (model.getCategoryId() != null) {
                entryEntity.set("category", (Object)model.getCategoryId());
            }
        }
    }

    private static void setStatus(SrmGetAutoScoreReq model, DynamicObject entryEntity) {
        if (model.getResult() != null) {
            entryEntity.set("status", (Object)SrmCalResultStatus.CALING.getVal());
        } else {
            entryEntity.set("status", (Object)SrmCalResultStatus.CAL_ERROR.getVal());
        }
    }
}

