/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AbstractSrmCategoryInvoke {
    private static final Log log = LogFactory.getLog(AbstractSrmCategoryInvoke.class);
    public static final String ORG = "org";
    public static final String SUPPLIER = "supplier";
    public static final String MODIFIER = "modifier";
    public static final String MODIFYTIME = "modifytime";
    public static final String ENTRYENTITY = "entryentity";
    public static final String TYPE = "type";
    public static final String MATERIAL = "material";
    public static final String MATERIALSORT = "materialsort";
    public static final String ID = "id";
    public static final String ENTRYID = "entryid";

    protected void updateSynchrosourcelist(List<Long> successIds, Boolean isSynchrosourcelist) {
        QFilter[] qFilters = new QFilter[]{new QFilter(ID, "in", successIds)};
        DynamicObject[] dbDy = BusinessDataServiceHelper.load((String)"srm_supcategory", (String)"id,synchrosourcelist", (QFilter[])qFilters);
        if (Objects.nonNull(dbDy) && dbDy.length > 0) {
            for (DynamicObject dynamicObject : dbDy) {
                dynamicObject.set("synchrosourcelist", (Object)isSynchrosourcelist);
            }
            SaveServiceHelper.update((DynamicObject[])dbDy);
        }
    }

    protected void updateSynchrosourcelistByMap(Map<Long, String> categoryMap) {
        QFilter[] qFilters = new QFilter[]{new QFilter(ID, "in", categoryMap.keySet())};
        DynamicObject[] dbDy = BusinessDataServiceHelper.load((String)"srm_supcategory", (String)"id,synchrosourcelist,sourcelistentryid", (QFilter[])qFilters);
        if (Objects.nonNull(dbDy) && dbDy.length > 0) {
            for (DynamicObject dynamicObject : dbDy) {
                dynamicObject.set("synchrosourcelist", (Object)Boolean.TRUE);
                dynamicObject.set("sourcelistentryid", (Object)categoryMap.get(dynamicObject.getLong(ID)));
            }
            SaveServiceHelper.update((DynamicObject[])dbDy);
        }
    }

    protected Map<String, Object> bulidResult(List<Map<String, Object>> req, int successNum, List<Map<String, Object>> failResult) {
        Map<String, Object> result = this.bulidResult(req, successNum);
        if (!CollectionUtils.isEmpty(failResult)) {
            StringBuilder resultMessage = new StringBuilder(16);
            for (Map<String, Object> fail : failResult) {
                resultMessage.append((String)fail.get("reason")).append("\n");
            }
            if (resultMessage.length() > 0) {
                result.put("message", resultMessage.toString());
            }
        }
        return result;
    }

    protected Map<String, Object> bulidResult(List<Map<String, Object>> req, int successNum) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(req)) {
            result.put("total", req.size());
            result.put("success", successNum);
        }
        return result;
    }

    protected Map<String, Object> dealResult(Map<String, Object> result, List<Map<String, Object>> req) {
        if (!CollectionUtils.isEmpty(result) && !CollectionUtils.isEmpty(req)) {
            log.info("AbstractSrmCategoryInvoke dealResult result:" + result.toString());
            ArrayList<Long> reqIds = new ArrayList<Long>(1024);
            for (Map<String, Object> reqMap : req) {
                Long reqId = (Long)reqMap.get(ID);
                reqIds.add(reqId);
            }
            Boolean success = (Boolean)result.get("success");
            if (!success.booleanValue() || null == result.get("data")) {
                log.info("AbstractSrmCategoryInvoke dealResult failMessage is null");
                this.updateSynchrosourcelist(reqIds, Boolean.FALSE);
                Map<String, Object> resultMap = this.bulidResult(req, 0);
                resultMap.put("message", result.get("message"));
                return resultMap;
            }
            List failMessage = (List)result.get("data");
            if (CollectionUtils.isEmpty((Collection)failMessage)) {
                log.info("AbstractSrmCategoryInvoke dealResult failMessage is null");
                this.updateSynchrosourcelist(reqIds, Boolean.FALSE);
                return this.bulidResult(req, 0);
            }
            ArrayList<Long> failIds = new ArrayList<Long>(24);
            HashMap<Long, String> category_ListMap = new HashMap<Long, String>(16);
            for (Map rspMap : failMessage) {
                Long id = (Long)rspMap.get(ID);
                if (!Boolean.parseBoolean(String.valueOf(rspMap.get("suceecss")))) {
                    failIds.add(id);
                    continue;
                }
                category_ListMap.put(id, String.valueOf(rspMap.get("sourcelistentryid")));
            }
            List successIds = reqIds.stream().filter(x -> !failIds.contains(x)).collect(Collectors.toList());
            log.info("SrmCateGoryInvokeUtil dealResult success Ids :" + successIds.toString());
            if (!CollectionUtils.isEmpty(successIds)) {
                this.updateSynchrosourcelistByMap(category_ListMap);
            }
            if (!CollectionUtils.isEmpty(failIds)) {
                this.updateSynchrosourcelist(failIds, Boolean.FALSE);
            }
            return this.bulidResult(req, successIds.size(), failMessage);
        }
        return null;
    }

    protected void upReqSupId(List<Map<String, Object>> req) {
        List supplierId = req.stream().map(x -> (Long)x.get(SUPPLIER)).collect(Collectors.toList());
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"srm_supplier", (String)"id,supplier.id", (QFilter[])new QFilter[]{new QFilter(ID, "in", supplierId)});
        Map<Long, Long> idMapSup = suppliers.stream().collect(Collectors.toMap(x -> x.getLong(ID), x -> x.getLong("supplier.id")));
        if (!CollectionUtils.isEmpty(idMapSup)) {
            for (Map<String, Object> reqMap : req) {
                reqMap.put(SUPPLIER, idMapSup.get(reqMap.get(SUPPLIER)));
            }
        }
    }
}

