/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.IParseEvtSource;
import kd.scm.common.util.UserPermissionByBillKey;

public class ParseSourceToSrmSup
implements IParseEvtSource {
    private static final Log log = LogFactory.getLog(ParseSourceToSrmSup.class);
    private static final Map<String, String> BILL_FORM_ID = new HashMap<String, String>(32);

    public ParseSourceToSrmSup() {
        BILL_FORM_ID.put("srm_samplenotify", "adm_samplenotify_in");
        BILL_FORM_ID.put("srm_supapprove", "adm_approve_in");
    }

    public String setBasedataName() {
        return "srm_supplier";
    }

    public String setOrgDataName() {
        return "bos_org";
    }

    public Set<Long> parseSourceToOthers(String billKey, String source) {
        log.info("billKey={},source={}", (Object)billKey, (Object)source);
        String fieldName = this.parseFieldNameByBillKey(source, billKey, "srm_supplier");
        String bosOrg = this.parseFieldNameByBillKey(source, billKey, "bos_org");
        return this.getResultByMap(billKey, source, fieldName, bosOrg);
    }

    public Map<String, Set<Long>> batchParseSourceToOthers(String billKey, String source, String fieldName, String bosOrg) {
        String bdSupplier = fieldName + ".bizpartner";
        String[] supplierKeys = bdSupplier.split("\\.");
        Map ids = this.parseUserIds(source, supplierKeys);
        for (Map.Entry entry : ids.entrySet()) {
            Long orgId = this.getOrgId(source, bosOrg, (String)entry.getKey());
            List adminSupUserIdsByBizPartner = BizPartnerUtil.getEnableAdminSupUserIdsByBizPartner((Set)((Set)entry.getValue()));
            Set parseSourceToUserIds = UserPermissionByBillKey.parseSourceToUserIds((String)billKey, (Long)orgId, (List)adminSupUserIdsByBizPartner, BILL_FORM_ID);
            ids.put(entry.getKey(), parseSourceToUserIds);
        }
        return ids;
    }
}

