/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SrmAttachUtil {
    private static Log log = LogFactory.getLog(SrmAttachUtil.class);

    public static BatchDownloadRequest.Dir buildAttachDir(DynamicObjectCollection attachment, String fileName) {
        BatchDownloadRequest.Dir dir = new BatchDownloadRequest.Dir(fileName);
        ArrayList<BatchDownloadRequest.File> fileList = new ArrayList<BatchDownloadRequest.File>();
        for (DynamicObject attach : attachment) {
            DynamicObject attachInfo = attach.getDynamicObject("fbasedataid");
            String url = attachInfo.getString("url");
            String path = StringUtils.substringAfter((String)url, (String)"path=");
            if (path.contains("&kdedcba")) {
                path = StringUtils.substringBefore((String)path, (String)"&kdedcba");
            }
            try {
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u7f16\u7801\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
            }
            String name = attachInfo.getString("name");
            BatchDownloadRequest.File file = new BatchDownloadRequest.File(name, path);
            fileList.add(file);
        }
        dir.setFiles(fileList.toArray(new BatchDownloadRequest.File[fileList.size()]));
        return dir;
    }
}

