/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.webapi.service.impl.portal;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.util.DateUtil;
import kd.scm.srm.webapi.util.SrmPortalStatusService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class SrmAbstractPortalService {
    private Log LOG = LogFactory.getLog(SrmAbstractPortalService.class);
    public String org;
    public String language;
    public DynamicObject compoent;
    public Long componentId;
    public JSONObject resultData = new JSONObject();
    JSONArray resultArrayData = new JSONArray();
    protected SrmPortalStatusService srmPortalStatusService = new SrmPortalStatusService();

    public SrmAbstractPortalService() {
    }

    public SrmAbstractPortalService(String language2) {
        this.language = language2;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public SrmAbstractPortalService(Long componentId, JSONArray resultArrayData) {
        this.componentId = componentId;
        this.resultArrayData = resultArrayData;
    }

    public SrmAbstractPortalService(String language2, Long componentId, JSONObject resultData) {
        this.language = language2;
        this.componentId = componentId;
        this.resultData = resultData;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language2) {
        this.language = language2;
    }

    public void setComponentId(Long componentId) {
        this.componentId = componentId;
    }

    public void packageResultInfo() {
        this.LOG.info("componentid is :" + this.componentId);
        DynamicObject dynamicObject = this.queryComponent();
        if (Objects.isNull(dynamicObject)) {
            this.LOG.info(this.componentId + ":component is null");
            return;
        }
        this.compoent = dynamicObject;
        try {
            this.bulidComponent();
        }
        catch (Exception e) {
            this.LOG.error("componentid is :" + this.componentId + ",packageResultInfo is fail:" + e.getMessage());
        }
    }

    protected void bulidComponent() {
    }

    protected DynamicObject queryComponent() {
        return null;
    }

    protected DynamicObjectCollection queryComponentConfig() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObjectCollection compconfigs = QueryServiceHelper.query((String)"srm_portal_compconfig", (String)"id,name,version,ismobile,topcomp,bottomcomp,number,entryentity.component,entryentity.component.group.compobject.number,entryentity.seq", (QFilter[])new QFilter[]{qFilter}, (String)"entryentity.seq asc");
        return compconfigs;
    }

    public Set<String> splitType(String type) {
        String[] splitNoticetype = type.split(",");
        Set<String> filterSplitNoticetype = Arrays.stream(splitNoticetype).filter(x -> !"".equals(x)).collect(Collectors.toSet());
        return filterSplitNoticetype;
    }

    public DynamicObject[] querySouNotice(String noticeType, Set<Long> srctypeids, String selects, Date datetimefrom, Date datetimeto, String name, int showmonth) {
        Calendar instance;
        Set<String> filterNoticetype = this.splitType(noticeType);
        QFilter qFilter = new QFilter("biztype", "in", filterNoticetype);
        List filterSrcType = filterNoticetype.stream().filter(x -> !"5".equals(x) && !"C".equals(x) && !"D".equals(x)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(srctypeids)) {
            qFilter.and(new QFilter("sourcetype", "in", srctypeids).or(new QFilter("biztype", "in", filterSrcType)));
        }
        qFilter.and(new QFilter("supscope", "=", (Object)"1"));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        if (Objects.nonNull(this.compoent)) {
            Boolean isfilter = this.compoent.getBoolean("isfilter");
            if (StringUtils.isNotEmpty((CharSequence)this.org) && isfilter.booleanValue()) {
                qFilter.and(new QFilter("org.number", "=", (Object)this.org));
            }
        }
        QFilter duedateFilter = new QFilter("duedate", "is not null", null).and(new QFilter("duedate", ">=", (Object)TimeServiceHelper.now()));
        duedateFilter.or(new QFilter("duedate", "is null", null));
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            QFilter nameFilter = new QFilter("noticetitle", "like", (Object)("%" + name + "%"));
            qFilter.and(nameFilter);
        }
        qFilter.and(duedateFilter);
        if (Objects.nonNull(datetimefrom) && Objects.nonNull(datetimeto)) {
            if (datetimefrom.equals(datetimeto)) {
                instance = Calendar.getInstance();
                instance.setTime(datetimeto);
                instance.add(7, 1);
                datetimeto = instance.getTime();
            }
            qFilter.and(new QFilter("billdate", ">=", (Object)datetimefrom)).and(new QFilter("billdate", "<=", (Object)datetimeto));
        }
        if (showmonth > 0) {
            instance = Calendar.getInstance();
            instance.setTime(TimeServiceHelper.now());
            instance.add(2, -showmonth);
            Date time = instance.getTime();
            qFilter.and(new QFilter("billdate", ">=", (Object)time));
        }
        DynamicObject[] sou_notices = BusinessDataServiceHelper.load((String)"sou_notice", (String)(selects + ",istop"), (QFilter[])new QFilter[]{qFilter}, (String)"billdate  desc");
        return sou_notices;
    }

    public DynamicObject[] queryBidNotice(String bidtype, String selects, Date datetimefrom, Date datetimeto, String name, int showmonth) {
        Calendar instance;
        Set<String> splitBidtype = this.splitType(bidtype);
        QFilter bidFilter = new QFilter("annotype", "in", splitBidtype);
        bidFilter.and(new QFilter("publishstatus", "=", (Object)"L"));
        bidFilter.and(new QFilter("status", "!=", (Object)"C"));
        if (Objects.nonNull(this.compoent)) {
            Boolean isfilter = this.compoent.getBoolean("isfilter");
            if (StringUtils.isNotEmpty((CharSequence)this.org) && isfilter.booleanValue()) {
                bidFilter.and(new QFilter("org.number", "=", (Object)this.org));
            }
        }
        if (Objects.nonNull(datetimefrom) && Objects.nonNull(datetimeto)) {
            if (datetimefrom.equals(datetimeto)) {
                instance = Calendar.getInstance();
                instance.setTime(datetimeto);
                instance.add(7, 1);
                datetimeto = instance.getTime();
            }
            bidFilter.and(new QFilter("publishdate", ">=", (Object)datetimefrom)).and(new QFilter("publishdate", "<=", (Object)datetimeto));
        }
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            bidFilter.and(new QFilter("annotitle", "like", (Object)("%" + name + "%")));
        }
        if (showmonth > 0) {
            instance = Calendar.getInstance();
            instance.setTime(TimeServiceHelper.now());
            instance.add(2, -showmonth);
            Date time = instance.getTime();
            bidFilter.and(new QFilter("publishdate", ">=", (Object)time));
        }
        DynamicObject[] bid_notices = BusinessDataServiceHelper.load((String)"bid_announcement", (String)selects, (QFilter[])new QFilter[]{bidFilter}, (String)"publishdate  desc");
        return bid_notices;
    }

    public JSONArray srmPortalNoticeDtoToJsonArray(JSONArray standardcardinfos, int max) {
        JSONArray jsonArray = new JSONArray();
        if (!CollectionUtils.isEmpty((Collection)standardcardinfos)) {
            Iterator iterator = standardcardinfos.iterator();
            while (iterator.hasNext()) {
                JSONObject next = (JSONObject)iterator.next();
                boolean istop = next.getBoolean("istop");
                if (!istop) continue;
                jsonArray.add((Object)next);
                iterator.remove();
            }
            jsonArray.sort((x, y) -> {
                if (Objects.nonNull(((JSONObject)y).get("publishtime")) && Objects.nonNull(((JSONObject)x).get("publishtime"))) {
                    return ((JSONObject)y).get("publishtime").toString().compareTo(((JSONObject)x).get("publishtime").toString());
                }
                return 1;
            });
            standardcardinfos.sort((x, y) -> {
                if (Objects.nonNull(((JSONObject)y).get("publishtime")) && Objects.nonNull(((JSONObject)x).get("publishtime"))) {
                    return ((JSONObject)y).get("publishtime").toString().compareTo(((JSONObject)x).get("publishtime").toString());
                }
                return 1;
            });
            jsonArray.addAll((Collection)standardcardinfos);
            if (jsonArray.size() > max) {
                List list = jsonArray.subList(0, max);
                return JSONArray.fromObject((Object)list);
            }
            return jsonArray;
        }
        return jsonArray;
    }

    public void bulidstandNotice(DynamicObject[] notices, JSONArray noticeDtos, String formid) {
        String domainUrlWidthouSlash = UrlService.getDomainContextUrl();
        if (Objects.nonNull(notices)) {
            for (DynamicObject notice : notices) {
                JSONObject srmPortalNoticeDto = new JSONObject();
                srmPortalNoticeDto.put((Object)"formId", (Object)formid);
                srmPortalNoticeDto.put((Object)"istop", (Object)Boolean.FALSE);
                if ("quo_notice".equals(formid)) {
                    boolean istop;
                    srmPortalNoticeDto.put((Object)"noticeId", (Object)notice.getString("id"));
                    String biztype = notice.getString("biztype");
                    long srcbillid = notice.getLong("srcbillid");
                    List<String> statusAndLeve = this.srmPortalStatusService.getStatus(biztype, srcbillid);
                    if (!CollectionUtils.isEmpty(statusAndLeve)) {
                        srmPortalNoticeDto.put((Object)"status", (Object)statusAndLeve.get(0));
                        if (statusAndLeve.size() > 1) {
                            srmPortalNoticeDto.put((Object)"statusleve", (Object)statusAndLeve.get(1));
                        }
                    }
                    srmPortalNoticeDto.put((Object)"type", (Object)biztype);
                    ILocaleString noticetitle = notice.getLocaleString("noticetitle");
                    if (Objects.nonNull(noticetitle)) {
                        srmPortalNoticeDto.put((Object)"noticename", (Object)noticetitle.getLocaleValue());
                    }
                    srmPortalNoticeDto.put((Object)"mobileurl", (Object)SrmAbstractPortalService.getPortalPathUrl(domainUrlWidthouSlash + "/mobile.html?form=mobsp_quonotice_view&billid=" + srmPortalNoticeDto.getString("noticeId") + "&userId=guest"));
                    Date billdate = notice.getDate("billdate");
                    if (Objects.nonNull(billdate)) {
                        srmPortalNoticeDto.put((Object)"publishtime", (Object)DateUtil.date2str((Date)billdate, (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    if (istop = notice.getBoolean("istop")) {
                        srmPortalNoticeDto.put((Object)"istop", (Object)istop);
                    }
                } else if ("bid_announcement".equals(formid)) {
                    Date billdate;
                    List<String> bidStauts;
                    srmPortalNoticeDto.put((Object)"noticeId", (Object)notice.getString("id"));
                    String annotype = notice.getString("annotype");
                    QFilter filterSupscope = new QFilter("bidmode.opentenderflag", "=", (Object)true).and(new QFilter("id", "=", (Object)notice.getLong("bidproject")));
                    DynamicObject bid_projectObj = QueryServiceHelper.queryOne((String)"bid_project", (String)"id,currentstep", (QFilter[])new QFilter[]{filterSupscope});
                    if (Objects.nonNull(bid_projectObj) && !CollectionUtils.isEmpty(bidStauts = this.srmPortalStatusService.getBidStauts(bid_projectObj.getString("id"))) && bidStauts.size() > 1) {
                        srmPortalNoticeDto.put((Object)"statusleve", (Object)bidStauts.get(0));
                        srmPortalNoticeDto.put((Object)"status", (Object)bidStauts.get(1));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)annotype) && "bidproject".equals(annotype)) {
                        if (Objects.nonNull(bid_projectObj)) {
                            srmPortalNoticeDto.put((Object)"noticeId", (Object)bid_projectObj.getString("id"));
                        }
                        srmPortalNoticeDto.put((Object)"formId", (Object)"ten_announcement_detail");
                    } else if (StringUtils.isNotEmpty((CharSequence)annotype) && "decision".equals(annotype)) {
                        srmPortalNoticeDto.put((Object)"formId", (Object)"bid_announcement_preview");
                    }
                    srmPortalNoticeDto.put((Object)"type", (Object)annotype);
                    ILocaleString noticetitle = notice.getLocaleString("annotitle");
                    if (Objects.nonNull(noticetitle)) {
                        srmPortalNoticeDto.put((Object)"noticename", (Object)noticetitle.getLocaleValue());
                    }
                    if (Objects.nonNull(billdate = notice.getDate("publishdate"))) {
                        srmPortalNoticeDto.put((Object)"publishtime", (Object)DateUtil.date2str((Date)billdate, (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    srmPortalNoticeDto.put((Object)"mobileurl", (Object)SrmAbstractPortalService.getPortalPathUrl(domainUrlWidthouSlash + "/index.html?formId=" + srmPortalNoticeDto.getString("formId") + "&noticeId=" + srmPortalNoticeDto.getString("noticeId") + "&userId=guest"));
                }
                srmPortalNoticeDto.put((Object)"orgnumber", (Object)notice.getString("org.number"));
                srmPortalNoticeDto.put((Object)"orgname", (Object)notice.getString("org.name"));
                srmPortalNoticeDto.put((Object)"url", (Object)SrmAbstractPortalService.getPortalPathUrl(domainUrlWidthouSlash + "/index.html?formId=" + srmPortalNoticeDto.getString("formId") + "&noticeId=" + srmPortalNoticeDto.getString("noticeId") + "&userId=guest"));
                if ("bid_announcement".equals(formid)) {
                    String url = srmPortalNoticeDto.getString("url");
                    srmPortalNoticeDto.put((Object)"url", (Object)(url + "&announcementId=" + notice.getString("id")));
                }
                noticeDtos.add((Object)srmPortalNoticeDto);
            }
        }
    }

    public JSONArray getComFieldMapValue(String entity, String comFieldKey, String noticetype) {
        JSONArray types = new JSONArray();
        Set<String> noticetypes = this.splitType(noticetype);
        DynamicObject billObj = BusinessDataServiceHelper.newDynamicObject((String)entity);
        if (Objects.isNull(billObj)) {
            return types;
        }
        IDataEntityProperty property = (IDataEntityProperty)billObj.getDynamicObjectType().getProperties().get((Object)comFieldKey);
        if (Objects.isNull(property)) {
            return types;
        }
        if (property instanceof ComboProp) {
            List comboItems = ((ComboProp)property).getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                String value = comboItem.getValue();
                LocaleString name = comboItem.getName();
                for (String type : noticetypes) {
                    if (!type.equals(value)) continue;
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put((Object)"name", (Object)name.toString());
                    jsonObject.put((Object)"key", (Object)value);
                    types.add((Object)jsonObject);
                }
            }
        }
        return types;
    }

    public static String getPortalPathUrl(String url) {
        AppParam appParam = new AppParam();
        appParam.setViewType("15");
        appParam.setAppId("XV1IC150UR4");
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        appParam.setOrgId(Long.valueOf(rootOrgId));
        Map systemMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        Object portallink = systemMap.get("portallink");
        if (Objects.nonNull(portallink) && "true".equals(portallink.toString())) {
            String tempUrl = "";
            if (url.startsWith("http://")) {
                tempUrl = url.substring(7, url.length());
            } else if (url.startsWith("https://")) {
                tempUrl = url.substring(8, url.length());
            }
            String[] split = tempUrl.split("/");
            if (split.length > 1) {
                StringBuilder patchUrl = new StringBuilder(32);
                for (int i = 1; i < split.length; ++i) {
                    patchUrl.append("/").append(split[i]);
                }
                return patchUrl.toString();
            }
        }
        return url;
    }
}

