/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.srm.common.SrmScoreUtil;
import kd.scm.srm.common.formula.SrmGetAutoScoreReq;
import kd.scm.srm.common.formula.SrmGetAutoScoreResp;

public class SrmAutoScoreResultService {
    private static final Log LOG = LogFactory.getLog(SrmAutoScoreResultService.class);

    public SrmGetAutoScoreResp autoScoreResult(List<SrmGetAutoScoreReq> srmAutoScoreReqs) {
        SrmGetAutoScoreResp rsp = new SrmGetAutoScoreResp();
        if (CollectionUtils.isEmpty(srmAutoScoreReqs)) {
            LOG.info("SrmAutoScoreService autoScoreResult srmAutoScoreReqs is null");
            rsp.setSuccess(Boolean.FALSE);
            rsp.setMessage(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u81ea\u52a8\u8bc4\u4f30\u7ed3\u679c\u8fd4\u56de\u53c2\u6570\u5f02\u5e38\u3002", (String)"SrmAutoScoreResultService_0", (String)"scm-srm-mservice", (Object[])new Object[0]), (String)"SrmAutoScoreService_1", (String)"scm-srm-common", (Object[])new Object[0]));
            return rsp;
        }
        LOG.info("SrmAutoScoreService autoScoreResult srmAutoScoreReqs is :" + srmAutoScoreReqs.toString());
        Map<Long, List<SrmGetAutoScoreReq>> detaiIdMap = srmAutoScoreReqs.stream().collect(Collectors.groupingBy(x -> x.getIndexScoreDetailId()));
        HashSet<Long> scoreIds = new HashSet<Long>(12);
        HashSet<Long> taskbillids = new HashSet<Long>(12);
        HashSet<Long> indexIds = new HashSet<Long>(12);
        for (SrmGetAutoScoreReq srmAutoScoreReq : srmAutoScoreReqs) {
            scoreIds.add(srmAutoScoreReq.getScoreTaskId());
            taskbillids.add(srmAutoScoreReq.getEvaplanId());
            indexIds.add(srmAutoScoreReq.getIndexId());
        }
        DynamicObject[] indexDys = BusinessDataServiceHelper.load((String)"srm_index", (String)"id,property,scoretype,entryentity1.isgenericrule,entryentity1.category,entryentity1.material,subentryentity1.item1,subentryentity1.valuefrom1,subentryentity1.valueto1,subentryentity1.itemscore1,subentryentity1.veto1", (QFilter[])new QFilter[]{new QFilter("id", "in", indexIds)});
        HashMap<Long, DynamicObject> indexMap = new HashMap<Long, DynamicObject>(12);
        for (DynamicObject indexDy : indexDys) {
            indexMap.put(indexDy.getLong("id"), indexDy);
        }
        DynamicObject[] detailRows = BusinessDataServiceHelper.load((String)"srm_score_detail", (String)"id,value,scorerscored,score,scorerscore,scorerveto", (QFilter[])new QFilter[]{new QFilter("id", "in", detaiIdMap.keySet())});
        if (Objects.nonNull(detailRows) && detailRows.length == 0) {
            LOG.info("SrmAutoScoreService autoScoreResult scoreDetailRows is null");
            rsp.setSuccess(Boolean.FALSE);
            rsp.setMessage(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u81ea\u52a8\u8bc4\u4f30\u7ed3\u679c\u8fd4\u56de\u53c2\u6570\u5f02\u5e38\u3002", (String)"SrmAutoScoreResultService_0", (String)"scm-srm-mservice", (Object[])new Object[0]), (String)"SrmAutoScoreService_1", (String)"scm-srm-common", (Object[])new Object[0]));
            return rsp;
        }
        this.writeToScore(detaiIdMap, scoreIds, taskbillids, indexMap, detailRows);
        rsp.setSuccess(Boolean.TRUE);
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToScore(Map<Long, List<SrmGetAutoScoreReq>> detaiIdMap, Set<Long> scoreIds, Set<Long> taskbillids, Map<Long, DynamicObject> indexMap, DynamicObject[] detailRows) {
        String lockKey = "/scm/srm/serivce/srmautoscore/" + taskbillids.iterator().next();
        DLock lock = DLock.create((String)lockKey);
        lock.lock();
        try {
            this.saveDetail(detailRows, detaiIdMap, indexMap);
            SrmScoreUtil.setScoreStatus(scoreIds);
            SrmScoreUtil.setEvaplanStatus(taskbillids);
        }
        finally {
            lock.unlock();
        }
    }

    public void saveDetail(DynamicObject[] detailRows, Map<Long, List<SrmGetAutoScoreReq>> detaiIdMap, Map<Long, DynamicObject> indexMap) {
        for (DynamicObject detailRow : detailRows) {
            long id = detailRow.getLong("id");
            List<SrmGetAutoScoreReq> groupSrmAutoScoreReqs = detaiIdMap.get(id);
            if (CollectionUtils.isEmpty(groupSrmAutoScoreReqs)) continue;
            BigDecimal result = groupSrmAutoScoreReqs.get(0).getResult();
            Long indexId = groupSrmAutoScoreReqs.get(0).getIndexId();
            Long categoryId = groupSrmAutoScoreReqs.get(0).getCategoryId();
            Long materialId = groupSrmAutoScoreReqs.get(0).getMaterialId();
            DynamicObject indexDy = indexMap.get(indexId);
            if (!Objects.isNull(indexDy)) {
                DynamicObjectCollection rowRules = indexDy.getDynamicObjectCollection("entryentity1");
                String property = indexDy.getString("property");
                String scoretype = indexDy.getString("scoretype");
                if ("2".equals(property) && "9".equals(scoretype)) {
                    detailRow.set("value", (Object)result);
                    detailRow.set("score", (Object)result);
                    detailRow.set("scorerscore", (Object)result);
                } else {
                    Map<String, Object> scoreMap = SrmAutoScoreResultService.getScore(rowRules, result, categoryId, materialId);
                    detailRow.set("value", (Object)result);
                    detailRow.set("score", scoreMap.get("score"));
                    detailRow.set("scorerscore", scoreMap.get("score"));
                    detailRow.set("scorerveto", scoreMap.get("scorerveto"));
                }
            } else {
                detailRow.set("value", (Object)result);
            }
            detailRow.set("scorerscored", (Object)true);
        }
        LOG.info("dealresult is : " + detailRows.toString());
        SRMStoreDataTraceHelper.updateStoreData((DynamicObject[])detailRows);
    }

    private static Map<String, Object> getScore(DynamicObjectCollection ruleRows, BigDecimal value, Long categoryId, Long materialId) {
        Optional<DynamicObject> findFirst;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("score", BigDecimal.valueOf(-1L));
        resultMap.put("scorerveto", "9");
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            return resultMap;
        }
        DynamicObjectCollection realSubRule = null;
        if (materialId != null && materialId != 0L) {
            realSubRule = SrmAutoScoreResultService.getRuleByMatch(ruleRows, materialId, "material");
        }
        if (realSubRule == null && categoryId != null && categoryId != 0L) {
            realSubRule = SrmAutoScoreResultService.getRuleByMatch(ruleRows, categoryId, "category");
        }
        if (realSubRule == null && (findFirst = ruleRows.stream().filter(row -> row.getBoolean("isgenericrule")).findFirst()).isPresent()) {
            DynamicObject genericruleDy = findFirst.get();
            realSubRule = genericruleDy.getDynamicObjectCollection("subentryentity1");
        }
        if (realSubRule == null) {
            return resultMap;
        }
        for (DynamicObject row2 : realSubRule) {
            if (value.compareTo(row2.getBigDecimal("valuefrom1")) < 0 || value.compareTo(row2.getBigDecimal("valueto1")) >= 0) continue;
            resultMap.put("score", row2.getBigDecimal("itemscore1"));
            resultMap.put("scorerveto", row2.getBigDecimal("veto1"));
            break;
        }
        return resultMap;
    }

    private static DynamicObjectCollection getRuleByMatch(DynamicObjectCollection ruleRows, Long propId, String propName) {
        DynamicObjectCollection realSubRule = null;
        for (DynamicObject row : ruleRows) {
            DynamicObjectCollection subRows = row.getDynamicObjectCollection("subentryentity1");
            Object propObj = row.get(propName);
            if (propObj == null || propObj instanceof Long && (Long)propObj == 0L) continue;
            Long propPkValue = null;
            if (propObj instanceof DynamicObject) {
                propPkValue = (Long)((DynamicObject)propObj).getPkValue();
            } else if (propObj instanceof Long) {
                propPkValue = (Long)propObj;
            }
            if (propPkValue == null || propId.compareTo(propPkValue) != 0) continue;
            realSubRule = subRows;
            break;
        }
        return realSubRule;
    }
}

