/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.srm.common.formula.SrmAutoFormulaReq;
import kd.scm.srm.common.formula.SrmAutoFormulaResp;
import kd.scm.srm.common.formula.utils.SrmAutoCalGroupOrgUtil;
import kd.scm.srm.service.autocal.SrmAutoCalServiceImpl;

public class SrmAutoScoreService {
    private static final Log LOG = LogFactory.getLog(SrmAutoScoreService.class);

    public DynamicObjectCollection queryScoreByAutoIndex(Long evaplanId, List<Long> autoIndex) {
        String select = "id,entry.index.id entryid,entry.subentry.id detailid,entry.index.formulaid formulaid,material,supplier,category";
        StringBuilder sb = new StringBuilder(select);
        String groupOrgKey = SrmAutoCalGroupOrgUtil.getGroupOrgKey();
        if (StringUtils.isNotBlank((String)groupOrgKey)) {
            sb.append(",").append(groupOrgKey).append(" groupOrg");
        }
        QFilter taskidQFilter = new QFilter("taskbillid", "=", (Object)evaplanId);
        QFilter indexFilter = new QFilter("entry.index", "in", autoIndex);
        DynamicObjectCollection scores = QueryServiceHelper.query((String)"srm_score", (String)sb.toString(), (QFilter[])new QFilter[]{taskidQFilter, indexFilter});
        return scores;
    }

    public DynamicObjectCollection queryScoreById(List<Long> scoreIds) {
        String select = "id,taskbillid,entry.index.id entryid,entry.index.scoretype scoretype,entry.subentry.id detailid,entry.index.formulaid formulaid,material,supplier,category";
        StringBuilder sb = new StringBuilder(select);
        String groupOrgKey = SrmAutoCalGroupOrgUtil.getGroupOrgKey();
        if (StringUtils.isNotBlank((String)groupOrgKey)) {
            sb.append(",").append(groupOrgKey).append(" groupOrg");
        }
        DynamicObjectCollection scores = QueryServiceHelper.query((String)"srm_score", (String)sb.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", scoreIds)});
        return scores;
    }

    public void pushAutoScoreTaskByTaskId(List<Long> scores) {
        LOG.info("begain pushAutoScoreTaskByTaskId  score is :" + scores.toString());
        if (scores.size() == 0) {
            LOG.info("pushAutoScoreTaskByTaskId score is null");
            return;
        }
        DynamicObjectCollection dynamicObjects = this.queryScoreById(scores);
        List autoScore = dynamicObjects.stream().filter(x -> "9".equals(x.getString("scoretype"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(autoScore)) {
            LOG.info("pushAutoScoreTaskByTaskId autoScore is null");
            return;
        }
        Map<Long, List<DynamicObject>> taskbillidMap = autoScore.stream().collect(Collectors.groupingBy(x -> x.getLong("taskbillid")));
        DynamicObjectCollection evaplanDy = QueryServiceHelper.query((String)"srm_evaplan", (String)"id,evamethod,dateto,datefrom,org.id", (QFilter[])new QFilter[]{new QFilter("id", "in", taskbillidMap.keySet())});
        if (CollectionUtils.isEmpty((Collection)evaplanDy)) {
            evaplanDy = QueryServiceHelper.query((String)"srm_evaplan_batch", (String)"id,evamethod,datefrom,dateto,org.id", (QFilter[])new QFilter[]{new QFilter("id", "in", taskbillidMap.keySet())});
        }
        Map<Long, List<DynamicObject>> evaplanDyMapId = evaplanDy.stream().collect(Collectors.groupingBy(x -> x.getLong("id")));
        taskbillidMap.forEach((k, v) -> {
            List evaplans = (List)evaplanDyMapId.get(k);
            if (!CollectionUtils.isEmpty((Collection)evaplans)) {
                this.pushAutoTask((DynamicObject)evaplans.get(0), (List<DynamicObject>)v);
            }
        });
    }

    public SrmAutoFormulaResp pushAutoscoreTask(DynamicObject evaplanDy, List<DynamicObject> scores) {
        LOG.info("pushAutoscoreTask evaplanDy:" + evaplanDy.toString() + " scores : " + scores.toString());
        String evamethod = evaplanDy.getString("evamethod");
        Date dateto = evaplanDy.getDate("dateto");
        Date dateform = evaplanDy.getDate("datefrom");
        long org = evaplanDy.getLong("org.id");
        SrmAutoFormulaReq req = new SrmAutoFormulaReq();
        req.setEndDate(dateto);
        req.setEvaDimension(evamethod);
        req.setEvaplanId(Long.valueOf(evaplanDy.getLong("id")));
        req.setOrgId(Long.valueOf(org));
        req.setStartDate(dateform);
        String groupOrgKey = SrmAutoCalGroupOrgUtil.getGroupOrgKey();
        ArrayList<SrmAutoFormulaReq.SrmAutoFormulaData> srmAutoFormulaDataList = new ArrayList<SrmAutoFormulaReq.SrmAutoFormulaData>(12);
        LOG.info("pushAutoscoreTask scores.size():" + scores.size());
        for (DynamicObject score : scores) {
            SrmAutoFormulaReq.SrmAutoFormulaData srmAutoFormulaData = new SrmAutoFormulaReq.SrmAutoFormulaData();
            long indexId = score.getLong("entryid");
            long detailid = score.getLong("detailid");
            long formulaid = score.getLong("formulaid");
            long material = score.getLong("material");
            long id = score.getLong("id");
            long supplier = score.getLong("supplier");
            long category = score.getLong("category");
            srmAutoFormulaData.setIndexId(Long.valueOf(indexId));
            srmAutoFormulaData.setFormulaId(Long.valueOf(formulaid));
            srmAutoFormulaData.setIndexScoreDetailId(Long.valueOf(detailid));
            srmAutoFormulaData.setMaterialId(Long.valueOf(material));
            srmAutoFormulaData.setCategoryId(Long.valueOf(category));
            srmAutoFormulaData.setScoreTaskId(Long.valueOf(id));
            srmAutoFormulaData.setSupplierId(Long.valueOf(supplier));
            if (StringUtils.isNotBlank((String)groupOrgKey) && score.containsProperty("groupOrg")) {
                Object groupOrgObj = score.get("groupOrg");
                if (groupOrgObj instanceof DynamicObject) {
                    Object groupOrgId = ((DynamicObject)groupOrgObj).get("id");
                    srmAutoFormulaData.setGroupOrgId((Long)groupOrgId);
                } else if (groupOrgObj instanceof Long) {
                    srmAutoFormulaData.setGroupOrgId((Long)groupOrgObj);
                }
            }
            if (srmAutoFormulaData.getGroupOrgId() == null || srmAutoFormulaData.getGroupOrgId() == 0L) {
                srmAutoFormulaData.setGroupOrgId(Long.valueOf(org));
            }
            srmAutoFormulaDataList.add(srmAutoFormulaData);
        }
        req.setData(srmAutoFormulaDataList);
        LOG.info("pushAutoscoreTask srmAutoFormulaDataList.size():" + srmAutoFormulaDataList.size());
        LOG.info("pushAutoscoreTask req:" + req.toString());
        SrmAutoFormulaResp srmAutoFormulaResp = new SrmAutoCalServiceImpl().doAutoCal(req);
        LOG.info("pushAutoscoreTask srmAutoFormulaResp:" + srmAutoFormulaResp.toString());
        return srmAutoFormulaResp;
    }

    public void pushAutoTask(DynamicObject evaplanDy, List<DynamicObject> scores) {
        try {
            Boolean success;
            SrmAutoFormulaResp srmAutoFormulaResp = this.pushAutoscoreTask(evaplanDy, scores);
            if (Objects.nonNull(srmAutoFormulaResp) && !(success = srmAutoFormulaResp.getSuccess()).booleanValue()) {
                throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u81ea\u52a8\u8bc4\u4f30\u6307\u6807\u4e0b\u53d1\u5931\u8d25\uff1a%1", (String)"SrmAutoScoreService_0", (String)"scm-srm-mservice", (Object[])new Object[0]), (String)"SrmAutoScoreService_0", (String)"scm-srm-mservice", (Object[])new Object[]{srmAutoFormulaResp.getMessage()}));
            }
        }
        catch (Exception e) {
            LOG.error("pushAutoTask error is " + e.getMessage());
            throw new KDBizException(e.getMessage());
        }
    }
}

