/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class SrmCategoryEffectDataUpgradeService
implements IUpgradeService {
    private Log log = LogFactory.getLog(this.getClass());
    public static int PAGE_SIZE = 1000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setLog("begin to update srm  effectdate");
        DBRoute dbRoute = new DBRoute(dbKey);
        this.updateSrmsupcategory(dbRoute);
        this.updateSrmAptitudeexam(dbRoute);
        this.updateSrmSupApprove(dbRoute);
        this.updatetSrmcategorychg(dbRoute);
        this.updateSrmcategorychgSrcID(dbRoute);
        result.setLog("end to update srm  effectdate");
        return result;
    }

    private void updateSrmSupApprove(DBRoute dbRoute) {
        StringBuilder sql = new StringBuilder();
        sql.append("select t1.fid,t1.fbillno,t2.fid,t2.fentryid,t3.fcreatetime from t_pur_approve t1 left join t_pur_aptitude_A t3 on t1.faptitudenoid = t3.fid  left join t_pur_approveentry t2 on t1.fid=t2.fid where t1.fauditstatus in ('B') and t2.feffectdate is null and t2.fexpirydate is null");
        try (DataSet rows = DB.queryDataSet((String)"SrmCategoryEffectDataUpgradeService.updatetSrmcategorychgSrcID", (DBRoute)dbRoute, (String)sql.toString(), null);){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(32);
            for (Row row : rows) {
                Date fcreatetime = row.getDate("fcreatetime");
                if (Objects.isNull(fcreatetime)) continue;
                Long fentryid = row.getLong("fentryid");
                Date crrYearLasteDay = this.getCrrYearLasteDay();
                Object[] objects = new Object[]{fcreatetime, crrYearLasteDay, fentryid};
                paramsList.add(objects);
            }
            if (paramsList.size() > 0) {
                DB.executeBatch((DBRoute)dbRoute, (String)"update t_pur_approveentry set feffectdate = ?,fexpirydate = ? where FEntryID = ?", paramsList);
            }
        }
    }

    private void updateSrmcategorychgSrcID(DBRoute dbRoute) {
        StringBuilder sql = new StringBuilder();
        sql.append("select t1.FEntryID,t3.fid from t_pur_categorychgentry t1 join t_pur_categorychg t2 on t1.fid=t2.fid left join t_pur_supcategory t3 on t1.fmaterial = t3.fmaterial and t1.fcategoryid = t3.fcategoryid and t2.fsupplierid = t3.fsupplierid and t2.forgid = t3.forgid where t2.fauditstatus in ('A','B') and (t1.fsupcategoryid = 0 or t1.fsupcategoryid is null)");
        try (DataSet rows = DB.queryDataSet((String)"SrmCategoryEffectDataUpgradeService.updatetSrmcategorychgSrcID", (DBRoute)dbRoute, (String)sql.toString(), null);){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(32);
            for (Row row : rows) {
                Long fid = row.getLong("fid");
                Long entryID = row.getLong("FEntryID");
                if (!Objects.nonNull(fid) || 0L == fid) continue;
                Object[] objects = new Object[]{fid, entryID};
                paramsList.add(objects);
            }
            if (paramsList.size() > 0) {
                DB.executeBatch((DBRoute)dbRoute, (String)"update t_pur_categorychgentry set fsupcategoryid = ? where FEntryID = ?", paramsList);
            }
        }
    }

    private void updatetSrmcategorychg(DBRoute dbRoute) {
        StringBuilder sql = new StringBuilder();
        sql.append("select t1.fid,t1.feffectdate,t1.fexpirydate,t1.FEntryID,t2.fauditstatus,t2.fbillno,t3.fcreatetime from t_pur_categorychgentry t1 join  t_pur_categorychg t2 on t1.fid = t2.fid join t_pur_categorychg_A t3 on t3.fid = t2.fid where t2.fauditstatus in ('B') and t1.feffectdate is null and t1.fexpirydate is null");
        try (DataSet rows = DB.queryDataSet((String)"SrmCategoryEffectDataUpgradeService.updatetSrmcategorychg", (DBRoute)dbRoute, (String)sql.toString(), null);){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(32);
            Date crrYearLasteDay = this.getCrrYearLasteDay();
            for (Row row : rows) {
                Long entryID = row.getLong("FEntryID");
                Date createtime = row.getDate("fcreatetime");
                if (Objects.isNull(createtime)) continue;
                Object[] objects = new Object[]{createtime, crrYearLasteDay, entryID};
                paramsList.add(objects);
            }
            if (paramsList.size() > 0) {
                DB.executeBatch((DBRoute)dbRoute, (String)"update t_pur_categorychgentry set feffectdate = ?,fexpirydate = ? where FEntryID = ?", paramsList);
            }
        }
    }

    private void updateSrmAptitudeexam(DBRoute dbRoute) {
        StringBuilder sql = new StringBuilder();
        sql.append("select t1.fid,t1.feffectdate,t1.fexpirydate,t1.FEntryID,t2.fauditstatus,t2.fhasapprove,t2.fbillno,t3.fcreatetime from t_pur_aptitudeentry t1 join  t_pur_aptitude t2 on t1.fid = t2.fid join t_pur_aptitude_A t3 on t3.fid = t2.fid where t2.fauditstatus in ('B','C') and t2.fhasapprove='0' and t1.feffectdate is null and t1.fexpirydate is null");
        try (DataSet rows = DB.queryDataSet((String)"SrmCategoryEffectDataUpgradeService.updateSrmAptitudeexam", (DBRoute)dbRoute, (String)sql.toString(), null);){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(32);
            Date crrYearLasteDay = this.getCrrYearLasteDay();
            for (Row row : rows) {
                Long entryID = row.getLong("FEntryID");
                Date createtime = row.getDate("fcreatetime");
                if (Objects.isNull(createtime)) continue;
                Object[] objects = new Object[]{createtime, crrYearLasteDay, entryID};
                paramsList.add(objects);
            }
            if (paramsList.size() > 0) {
                DB.executeBatch((DBRoute)dbRoute, (String)"update t_pur_aptitudeentry set feffectdate = ?,fexpirydate = ? where FEntryID = ?", paramsList);
            }
        }
    }

    private void updateSrmsupcategory(DBRoute dbRoute) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fid,feffectdate,fexpirydate,fmodifytime from t_pur_supcategory where feffectdate is null AND fexpirydate is null");
        try (DataSet rows = DB.queryDataSet((String)"SrmCategoryEffectDataUpgradeService.upsrm_supcategory", (DBRoute)dbRoute, (String)sql.toString(), null);){
            HashMap<Long, Date> data = new HashMap<Long, Date>(32);
            ArrayList<Long> idlists = new ArrayList<Long>(32);
            for (Row row : rows) {
                Long fid = row.getLong("fid");
                Date fmodifytime = row.getDate("fmodifytime");
                if (Objects.isNull(fmodifytime)) continue;
                data.put(fid, fmodifytime);
                idlists.add(fid);
            }
            int count = idlists.size();
            int totalPages = count / PAGE_SIZE;
            if (count % PAGE_SIZE != 0) {
                ++totalPages;
            }
            Date crrYearLasteDay = this.getCrrYearLasteDay();
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>(32);
                List subIdList = (pageIndex + 1) * PAGE_SIZE > idlists.size() ? idlists.subList(pageIndex * PAGE_SIZE, idlists.size()) : idlists.subList(pageIndex * PAGE_SIZE, (pageIndex + 1) * PAGE_SIZE);
                for (Long id : subIdList) {
                    Date modifyDate = (Date)data.get(id);
                    Object[] objects = new Object[]{modifyDate, crrYearLasteDay, id};
                    paramsList.add(objects);
                }
                if (paramsList.size() <= 0) continue;
                this.inserDb(dbRoute, paramsList);
            }
        }
    }

    private Date getCrrYearLasteDay() {
        Date lastDate = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            lastDate = simpleDateFormat.parse("2099-12-31");
        }
        catch (ParseException e1) {
            this.log.error("\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a" + e1.getMessage());
        }
        return lastDate;
    }

    private void inserDb(DBRoute dbRoute, List<Object[]> paramsList) {
        DB.executeBatch((DBRoute)dbRoute, (String)"update t_pur_supcategory set feffectdate = ?,fexpirydate = ? where fid = ?", paramsList);
    }
}

