/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service.autocal;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.CollectionUtils;
import kd.scm.common.thread.ThreadPoolServiceFactory;
import kd.scm.srm.common.formula.SrmAutoFormulaReq;
import kd.scm.srm.common.formula.SrmAutoFormulaResp;
import kd.scm.srm.common.formula.utils.AutoFormulaUtils;
import kd.scm.srm.common.formula.utils.ScDataHandleLogInfoUtils;
import kd.scm.srm.common.formula.utils.UpdateParamConfigUtils;
import kd.scm.srm.common.sdk.SrmAutoCalGroupOrgService;
import kd.scm.srm.service.ISrmAutoCalService;
import kd.scm.srm.service.autocal.SrmAutoCalContext;
import kd.scm.srm.service.autocal.SrmConditionAutoCal;
import kd.scm.srm.service.autocal.SrmFormulaAutoCal;
import kd.scm.srm.service.autocal.SrmPluginAutoCal;
import kd.sdk.scm.srm.extpoint.ISrmAutoCalGroupOrgService;

public class SrmAutoCalServiceImpl
implements ISrmAutoCalService {
    private static final String SCM_SRM_SERIVCE_SRMAUTOCALSERVICE = "/scm/srm/serivce/srmautocalservice/";
    private static final Log LOG = LogFactory.getLog(SrmAutoCalServiceImpl.class);
    private Boolean isBatch = false;
    private Boolean isAlgox = false;
    private Integer timeout = 30;

    public String doAutoCal(String params) {
        LOG.info("SrmAutoCalServiceImpl doAutoCal param:{} ", (Object)params);
        SrmAutoFormulaReq req = (SrmAutoFormulaReq)JSON.parseObject((String)params, SrmAutoFormulaReq.class);
        SrmAutoFormulaResp resp = this.doAutoCal(req);
        return JSON.toJSONString((Object)resp);
    }

    private void initParam() {
        this.isBatch = UpdateParamConfigUtils.isBatch();
        this.isAlgox = UpdateParamConfigUtils.isAlgoX();
        this.timeout = UpdateParamConfigUtils.getTimeOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SrmAutoFormulaResp doAutoCal(SrmAutoFormulaReq req) {
        Long evaplanId = req.getEvaplanId();
        try (TraceSpan create = Tracer.create((String)"SrmAutoCalServiceImpl.doAutoCal", (String)evaplanId.toString());){
            LOG.info("\u5f00\u59cb\u8ba1\u7b97\uff0cevaplanId={}", (Object)evaplanId);
            this.initParam();
            this.doAudoCal(req);
            LOG.info("\u7ed3\u675f\u8ba1\u7b97\uff0cevaplanId={}", (Object)evaplanId);
        }
        catch (Throwable e) {
            LOG.error("\u8c03\u7528\u8ba1\u7b97\u5f02\u5e38 exception=.", e);
            ScDataHandleLogInfoUtils.error((Object)req, (String)"", (Throwable)e);
            SrmAutoFormulaResp srmAutoFormulaResp = new SrmAutoFormulaResp(e.getMessage());
            return srmAutoFormulaResp;
        }
        finally {
            LOG.info("\u8ba1\u7b97\u7ed3\u675f...");
        }
        String loadKDString = ResManager.loadKDString((String)"\u8c03\u7528\u6210\u529f,\u6b63\u5728\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7b49\u5f85\u3002", (String)"SrmAutoCalServiceImpl_1", (String)"scm-srm-mservice", (Object[])new Object[0]);
        return new SrmAutoFormulaResp(loadKDString);
    }

    private void doAudoCal(SrmAutoFormulaReq srmAutoFormulaReq) {
        String jsonStr = JSON.toJSONString((Object)srmAutoFormulaReq);
        LOG.info("\u5f00\u59cb\u8ba1\u7b97\u53c2\u6570\u4e3a={}", (Object)jsonStr);
        Long evaplanId = srmAutoFormulaReq.getEvaplanId();
        List datas = srmAutoFormulaReq.getData();
        LOG.info("doAudoCal srmAutoFormulaDataList.size():" + datas.size());
        Map<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> map = datas.stream().collect(Collectors.groupingBy(SrmAutoFormulaReq.SrmAutoFormulaData::getIndexId));
        LOG.info("doAudoCal mapIndexId.size():" + map.size());
        SrmAutoCalGroupOrgService defPlugin = new SrmAutoCalGroupOrgService();
        PluginProxy pluginProxy = PluginProxy.create((Object)defPlugin, ISrmAutoCalGroupOrgService.class, (String)"SCM_SRM_AUTOCALGROUPORG_EXT", null);
        for (Map.Entry<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> entry : map.entrySet()) {
            ThreadPoolServiceFactory.create().execute(() -> {
                Long indexId = (Long)entry.getKey();
                LOG.info("\u5f53\u524d\u6267\u884c\u7684\u6307\u6807\u4e3a\uff1aevaplanId={},indexId={}", (Object)evaplanId, (Object)indexId);
                List value = (List)entry.getValue();
                SrmAutoFormulaReq srmAutoFormulaReqCopy = (SrmAutoFormulaReq)JSON.parseObject((String)jsonStr, SrmAutoFormulaReq.class);
                Long orgId = srmAutoFormulaReq.getOrgId();
                pluginProxy.callReplaceIfPresent(p -> {
                    Long groupOrgId = p.getGroupOrg(indexId, orgId);
                    if (groupOrgId != null && groupOrgId != 0L) {
                        srmAutoFormulaReqCopy.setOrgId(groupOrgId);
                        LOG.info("\u5f53\u524d\u6307\u6807\u4e3a\u96c6\u56e2\u8bc4\u4f30\u6307\u6807:indexId={},orgId={},groupOrgId={}", new Object[]{indexId, orgId, groupOrgId});
                    }
                    return null;
                });
                srmAutoFormulaReqCopy.setData(value);
                this.execute(srmAutoFormulaReqCopy, evaplanId, indexId);
            }, "scm.srm.srmautocalservice");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(SrmAutoFormulaReq srmAutoFormulaReq, Long evaplanId, Long indexId) {
        String mutexId = indexId.toString();
        List data = srmAutoFormulaReq.getData();
        if (CollectionUtils.isEmpty((Collection)data)) {
            LOG.info("\u672a\u67e5\u8be2\u5230\u3002evaplanId={},indexId={}", (Object)evaplanId, (Object)indexId);
            return;
        }
        Long formulaId = ((SrmAutoFormulaReq.SrmAutoFormulaData)data.get(0)).getFormulaId();
        DynamicObject calFormulaDy = AutoFormulaUtils.getCalFormulaById((Long)formulaId);
        if (calFormulaDy == null) {
            LOG.info("\u672a\u67e5\u8be2\u5230\u5df2\u5ba1\u6838\u901a\u8fc7\u5e76\u4e14\u53ef\u7528\u7684\u8ba1\u7b97\u6a21\u578b\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002evaplanId={},formulaId={}", (Object)evaplanId, (Object)formulaId);
            return;
        }
        String calmethod = calFormulaDy.getString("calmethod");
        AutoFormulaUtils.checkAutoFormulaReq((SrmAutoFormulaReq)srmAutoFormulaReq, (String)calmethod);
        String lockKey = SCM_SRM_SERIVCE_SRMAUTOCALSERVICE + mutexId;
        LOG.info("\u5f53\u524d\u6267\u884c\u6307\u6807\u9501\u4e3a\uff1aevaplanId={},indexId={}", (Object)evaplanId, (Object)indexId);
        DLock lock = DLock.create((String)lockKey);
        try {
            lock.lock();
            LOG.info("\u5f53\u524d\u6267\u884c\u6307\u6807\u4e3a\uff1aevaplanId={},indexId={}", (Object)evaplanId, (Object)indexId);
            this.execCalFormula(srmAutoFormulaReq, formulaId, calFormulaDy, calmethod);
        }
        finally {
            lock.unlock();
        }
    }

    private void execCalFormula(SrmAutoFormulaReq srmAutoFormulaReq, Long formulaId, DynamicObject calFormulaDy, String calmethod) {
        SrmAutoCalContext context = null;
        switch (calmethod) {
            case "A": {
                context = new SrmAutoCalContext(new SrmFormulaAutoCal());
                break;
            }
            case "B": {
                context = new SrmAutoCalContext(new SrmPluginAutoCal());
                break;
            }
            case "C": {
                context = new SrmAutoCalContext(new SrmConditionAutoCal());
                break;
            }
        }
        if (context == null) {
            return;
        }
        context.initSrmContextParam(this.isBatch, this.isAlgox, this.timeout);
        context.execCalFormula(srmAutoFormulaReq, calFormulaDy, formulaId);
    }
}

