/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service.autocal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scm.srm.common.formula.SrmAutoFormulaReq;
import kd.scm.srm.common.formula.SrmGetAutoScoreReq;
import kd.scm.srm.common.formula.model.SrmFormulaModel;
import kd.scm.srm.common.formula.utils.ScDataHandleLogInfoUtils;
import kd.scm.srm.common.formula.utils.SrmCalResultHelper;
import kd.scm.srm.service.autocal.SrmAutoCal;
import kd.scm.srm.service.autocal.model.SrmContextParam;
import kd.sdk.scm.srm.extpoint.ISrmAutoCalPluginService;
import kd.sdk.scm.srm.extpoint.dto.SrmAutoScoreReq;

public class SrmPluginAutoCal
extends SrmAutoCal {
    @Override
    public void acceptCalFormula(SrmAutoFormulaReq srmAutoFormulaReq, DynamicObject formulaDy, SrmContextParam param, Long formulaId) {
        LOG.info("\u5f00\u59cb\u8c03\u7528\u8ba1\u7b97\u516c\u5f0f\u6309\u63d2\u4ef6\u8ba1\u7b97+formulaId={},param={}", (Object)formulaId, (Object)JSON.toJSONString((Object)param));
        String config = "";
        try (TraceSpan create = Tracer.create((String)"SrmAutoCalServiceImpl.plugin", (String)srmAutoFormulaReq.getEvaplanId().toString());){
            String pluginName = formulaDy.getString("pluginname");
            LOG.info("\u5f00\u59cb\u8c03\u7528\u63d2\u4ef6\u8ba1\u7b97");
            Long evaplanId = srmAutoFormulaReq.getEvaplanId();
            List srmAutoFormulaDatas = srmAutoFormulaReq.getData();
            ISrmAutoCalPluginService calQtyPlugin = (ISrmAutoCalPluginService)TypesContainer.createInstance((String)pluginName);
            SrmAutoScoreReq srmAutoScoreReq = this.buildPluginReq(srmAutoFormulaReq, srmAutoFormulaDatas, evaplanId);
            LOG.info("\u8bf7\u6c42\u63d2\u4ef6\u8bf7\u6c42\u53c2\u6570,result={}", (Object)JSON.toJSONString((Object)srmAutoScoreReq));
            List list = calQtyPlugin.doAutoCal(srmAutoScoreReq);
            String result = JSON.toJSONString((Object)list);
            LOG.info("\u8bf7\u6c42\u63d2\u4ef6\u8fd4\u56de\u7ed3\u679c,result={}", (Object)result);
            List listReq = JSONArray.parseArray((String)result, SrmGetAutoScoreReq.class);
            SrmFormulaModel model = this.buildSaveRespModel(srmAutoScoreReq);
            SrmCalResultHelper.saveOrNewCalResult((List)listReq, (SrmFormulaModel)model, (String)"result");
            this.doAutoScoreResult(listReq);
            String loadKDString = ResManager.loadKDString((String)"\u63d2\u4ef6\u8ba1\u7b97\u7ed3\u675f:", (String)"SrmAutoCalServiceImpl_5", (String)"scm-srm-mservice", (Object[])new Object[0]);
            ScDataHandleLogInfoUtils.info((Object)srmAutoFormulaReq, (String)config, (String)loadKDString, (Object)listReq);
        }
        catch (Exception e) {
            LOG.error("\u8c03\u7528\u63d2\u4ef6\u5f02\u5e38", (Throwable)e);
            ScDataHandleLogInfoUtils.error((Object)srmAutoFormulaReq, (String)config, (Throwable)e);
        }
    }

    private SrmFormulaModel buildSaveRespModel(SrmAutoScoreReq srmAutoScoreReq) {
        SrmFormulaModel model = new SrmFormulaModel();
        model.setEndDate(srmAutoScoreReq.getEndDate());
        model.setEvaDimension(srmAutoScoreReq.getEvaDimension());
        model.setOrgId(srmAutoScoreReq.getOrgId());
        model.setStartDate(srmAutoScoreReq.getStartDate());
        model.setEvaplanId(srmAutoScoreReq.getEvaplanId());
        Long indexId = 0L;
        Long formulaId = 0L;
        for (SrmAutoScoreReq.SrmAutoCalData srmAutoFormulaData : srmAutoScoreReq.getData()) {
            if (srmAutoFormulaData == null) continue;
            indexId = srmAutoFormulaData.getIndexId();
            formulaId = srmAutoFormulaData.getFormulaId();
            break;
        }
        model.setFormulaId(formulaId);
        model.setIndexId(indexId);
        return model;
    }

    private SrmAutoScoreReq buildPluginReq(SrmAutoFormulaReq srmAutoFormulaReq, List<SrmAutoFormulaReq.SrmAutoFormulaData> srmAutoFormulaDatas, Long evaplanId) {
        String dataStr = JSON.toJSONString(srmAutoFormulaDatas);
        List data = JSONArray.parseArray((String)dataStr, SrmAutoScoreReq.SrmAutoCalData.class);
        Long orgId = srmAutoFormulaReq.getOrgId();
        String evaDimension = srmAutoFormulaReq.getEvaDimension();
        Date startDate = srmAutoFormulaReq.getStartDate();
        Date endDate = srmAutoFormulaReq.getEndDate();
        SrmAutoScoreReq srmAutoScoreReq = new SrmAutoScoreReq();
        srmAutoScoreReq.setOrgId(orgId);
        srmAutoScoreReq.setEvaDimension(evaDimension);
        srmAutoScoreReq.setEvaplanId(evaplanId);
        srmAutoScoreReq.setEndDate(endDate);
        srmAutoScoreReq.setStartDate(startDate);
        srmAutoScoreReq.setData(data);
        return srmAutoScoreReq;
    }
}

