/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service.autoeva;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.srm.common.autoeva.SrmAutoEvaTplUtil;
import kd.scm.srm.service.ISrmAutoEvaTplPushService;

public class SrmAutoEvaTplPushService
implements ISrmAutoEvaTplPushService {
    private Log log = LogFactory.getLog(this.getClass());

    public void opPush(List<String> sourceBillIds, Long tplId, Date date) {
        if (sourceBillIds == null || sourceBillIds.isEmpty() || tplId == 0L) {
            return;
        }
        QFilter qf = new QFilter("id", "=", (Object)tplId);
        DynamicObject srm_autoevatpl = QueryServiceHelper.queryOne((String)"srm_autoevatpl", (String)this.getSelectFields(), (QFilter[])new QFilter[]{qf});
        DynamicObjectCollection tplScorerEntry = QueryServiceHelper.query((String)"srm_autoevatpl", (String)this.getEntryScorerSelectsFields(), (QFilter[])new QFilter[]{qf});
        String billobjectNumber = srm_autoevatpl.getString("billobject.number");
        String pushtype = srm_autoevatpl.getString("pushtype");
        String evaorgvalue = srm_autoevatpl.getString("evaorgvalue");
        String suppliervalue = srm_autoevatpl.getString("suppliervalue");
        HashSet<Long> scourceIdSet = new HashSet<Long>(16);
        for (String string : sourceBillIds) {
            long scourceId = Long.parseLong(string);
            scourceIdSet.add(scourceId);
        }
        HashSet<String> selectFields = new HashSet<String>(16);
        selectFields.add(evaorgvalue);
        selectFields.add(suppliervalue);
        selectFields.add("billno");
        selectFields.add("id");
        for (DynamicObject tplEntryRow : tplScorerEntry) {
            String scorervalue = tplEntryRow.getString("entryentity.scorervalue");
            if (!StringUtils.isNotBlank((CharSequence)scorervalue)) continue;
            selectFields.add(scorervalue);
        }
        QFilter qFilter = this.getFilterGrid(srm_autoevatpl);
        DynamicObjectCollection sourceBills = this.getSourceBills(billobjectNumber, scourceIdSet, selectFields, qFilter);
        ArrayList<String> autoTplList = new ArrayList<String>(10);
        autoTplList.add(String.valueOf(tplId));
        Map<Long, DynamicObject> execLogs = this.batchCreateExecLog(autoTplList, date, sourceBillIds);
        ArrayList<DynamicObject> evaplanBills = new ArrayList<DynamicObject>(10);
        HashMap<Long, DynamicObject> tarbillexecLogsMap = new HashMap<Long, DynamicObject>(16);
        DynamicObject targetBill = new DynamicObject();
        for (DynamicObject sourceBill : sourceBills) {
            long scourceId = sourceBill.getLong("id");
            DynamicObject execLog = execLogs.get(scourceId);
            try {
                long schemeId = srm_autoevatpl.getLong("scheme");
                long gradeId = srm_autoevatpl.getLong("grade");
                Long pkValue = srm_autoevatpl.getLong("id");
                HashSet<Object> pkValues = new HashSet<Object>(8);
                pkValues.add(pkValue);
                List<DynamicObject> targetBills = this.batchPushTargetBill(pkValues, pushtype);
                evaplanBills.addAll(targetBills);
                if (targetBills != null && !targetBills.isEmpty()) {
                    targetBill = targetBills.get(0);
                }
                long evaorgvalueObj = sourceBill.getLong(evaorgvalue);
                long suppliervalueObj = sourceBill.getLong(suppliervalue);
                long targetBillId = targetBill.getLong("id");
                tarbillexecLogsMap.put(targetBillId, execLog);
                targetBill.set("org", (Object)evaorgvalueObj);
                this.setDefaultValue(srm_autoevatpl, targetBill, date);
                DynamicObjectCollection targetBillSupplierEntry = targetBill.getDynamicObjectCollection("entryentity");
                targetBillSupplierEntry.clear();
                DynamicObject newRow = targetBillSupplierEntry.addNew();
                targetBill.set("evamethod", (Object)"C");
                String sourceBillno = sourceBill.getString("billno");
                newRow.set("bizbilltype", (Object)billobjectNumber);
                newRow.set("bizbillno", (Object)sourceBillno);
                newRow.set("supplier", (Object)suppliervalueObj);
                if (pushtype.equals("srm_evaplan")) {
                    DynamicObjectCollection entry_scorer = targetBill.getDynamicObjectCollection("entry_scorer");
                    entry_scorer.clear();
                    this.handleEntryScorer(tplScorerEntry, entry_scorer, sourceBill);
                } else if (pushtype.equals("srm_evaplan_batch")) {
                    DynamicObjectCollection entryentity = targetBill.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entryRow : entryentity) {
                        entryRow.set("scheme", (Object)schemeId);
                        entryRow.set("grade", (Object)gradeId);
                        entryRow.set("weightstrategy", (Object)"B");
                        DynamicObjectCollection subentryentity = entryRow.getDynamicObjectCollection("subentryentity");
                        this.handleEntryScorer(tplScorerEntry, subentryentity, sourceBill);
                    }
                }
                this.updateLogStatus(execLog, "B", null);
            }
            catch (Exception e) {
                evaplanBills.remove(targetBill);
                this.updateLogStatus(execLog, "A", ExceptionUtil.wrapExceptionErrorInfo((Throwable)e));
            }
        }
        try {
            HashMap<Long, StringBuilder> errMsgMap = new HashMap<Long, StringBuilder>(16);
            HashSet<Long> successPkIdsSet = new HashSet<Long>(16);
            this.handleSaveTarBillErrMsgMap(successPkIdsSet, errMsgMap, evaplanBills, pushtype);
            this.updateLogsTarBillno(successPkIdsSet, tarbillexecLogsMap, evaplanBills);
            this.batchUpdateLogsStatus(tarbillexecLogsMap, errMsgMap, null);
            Collection<DynamicObject> values = execLogs.values();
            DynamicObject[] execLogsArr = values.toArray(new DynamicObject[values.size()]);
            SaveServiceHelper.save((DynamicObject[])execLogsArr);
        }
        catch (Exception e) {
            this.log.info("\u7ee9\u6548\u8bc4\u4f30\u5355\u636e\u64cd\u4f5c\u89e6\u53d1\u51fa\u73b0\u5f02\u5e38\uff0c\u89e6\u53d1\u65f6\u95f4" + TimeServiceHelper.now() + "\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
    }

    private void handleEntryScorer(DynamicObjectCollection tplScorerEntry, DynamicObjectCollection entry_scorer, DynamicObject sourceBill) {
        for (DynamicObject tplEntryRow : tplScorerEntry) {
            long indexclass = tplEntryRow.getLong("entryentity.indexclass");
            String scorervaluetype = tplEntryRow.getString("entryentity.scorervaluetype");
            String scorervalue = tplEntryRow.getString("entryentity.scorervalue");
            long scorer = tplEntryRow.getLong("entryentity.scorer");
            BigDecimal scorerweight = tplEntryRow.getBigDecimal("entryentity.scorerweight");
            this.setScorerEntry(entry_scorer, sourceBill, indexclass, scorervaluetype, scorervalue, scorer, scorerweight);
        }
    }

    private Map<Long, DynamicObject> batchCreateExecLog(List<String> autoTplList, Date date, List<String> sourceBillIds) {
        HashMap<Long, DynamicObject> execLogs = new HashMap<Long, DynamicObject>(16);
        Map<Long, Long> tplLogMap = this.getTplLogMap(autoTplList);
        if (sourceBillIds == null || sourceBillIds.isEmpty()) {
            for (String tplId : autoTplList) {
                DynamicObject execLog = this.newDynamicObject("srm_autoevatpl_log");
                execLog.set("tplid", (Object)tplId);
                execLog.set("exectplversion", (Object)tplLogMap.get(Long.parseLong(tplId)));
                execLog.set("execdate", (Object)date);
                execLog.set("logdate", (Object)TimeServiceHelper.now());
                execLog.set("sourcebillid", null);
                execLog.set("execstatus", (Object)"C");
                execLogs.put(Long.parseLong(tplId), execLog);
            }
        } else {
            String tplId = autoTplList.get(0);
            for (String sourceBillId : sourceBillIds) {
                DynamicObject execLog = this.newDynamicObject("srm_autoevatpl_log");
                execLog.set("tplid", (Object)tplId);
                execLog.set("exectplversion", (Object)tplLogMap.get(Long.parseLong(tplId)));
                execLog.set("execdate", (Object)date);
                execLog.set("logdate", (Object)TimeServiceHelper.now());
                execLog.set("sourcebillid", (Object)sourceBillId);
                execLog.set("execstatus", (Object)"C");
                execLogs.put(Long.parseLong(sourceBillId), execLog);
            }
        }
        return execLogs;
    }

    private Map<Long, Long> getTplLogMap(List<String> tplIds) {
        DynamicObjectCollection tpls = QueryServiceHelper.query((String)"srm_autoevatpl_ver", (String)"id,tplid,version", (QFilter[])new QFilter[]{new QFilter("tplid", "in", tplIds)});
        HashMap<Long, Long> tpllogMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> tplVerMap = new HashMap<Long, Long>(16);
        for (DynamicObject tpl : tpls) {
            long id = tpl.getLong("id");
            long tplid = tpl.getLong("tplid");
            long version = tpl.getLong("version");
            if (!tplVerMap.containsKey(tplid)) {
                tplVerMap.put(tplid, version);
                tpllogMap.put(tplid, id);
                continue;
            }
            if (tplVerMap.get(tplid) == null || (Long)tplVerMap.get(tplid) >= version) continue;
            tplVerMap.put(tplid, version);
            tpllogMap.put(tplid, id);
        }
        return tpllogMap;
    }

    private void updateLogStatus(DynamicObject execLog, String status, String exceptionMsg) {
        execLog.set("execstatus", (Object)status);
        if (StringUtils.isNotBlank((CharSequence)exceptionMsg) && exceptionMsg.length() >= 2000) {
            exceptionMsg = exceptionMsg.substring(0, 1999);
        }
        execLog.set("exceptionMsg", (Object)exceptionMsg);
    }

    private List<DynamicObject> batchPushTargetBill(Set<Object> pkValues, String targetBillName) {
        if (pkValues.isEmpty()) {
            return null;
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("srm_autoevatpl");
        pushArgs.setTargetEntityNumber(targetBillName);
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(10);
        for (Object pkValue : pkValues) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue(pkValue);
            selectedRowList.add(row);
        }
        pushArgs.setSelectedRows(selectedRowList);
        ArrayList<DynamicObject> targetData = new ArrayList(10);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!result.isSuccess()) {
            StringBuilder message = new StringBuilder();
            result.getBillReports().forEach(rowx -> message.append(rowx.getFailMessage()));
            message.append(ResManager.loadKDString((String)"botp\u51fa\u73b0\u5f02\u5e38\u3002", (String)"SrmAutoEvaTplPushService_2", (String)"scm-srm-mservice", (Object[])new Object[0]));
            throw new KDException(message.toString());
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetBillName);
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
            }
        };
        targetData = result.loadTargetDataObjects(refDataProvider, mainType);
        return targetData;
    }

    private DynamicObjectCollection getSourceBills(String billobjectNumber, Set<Long> scourceIds, Set<String> selectFields, QFilter filterGrid) {
        if (StringUtils.isBlank((CharSequence)billobjectNumber) || scourceIds == null || scourceIds.isEmpty()) {
            StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"getSourceBill\u65b9\u6cd5\u5165\u53c2\u5f02\u5e38\u3002", (String)"SrmAutoEvaTplPushService_4", (String)"scm-srm-mservice", (Object[])new Object[0]));
            msg.append(billobjectNumber);
            msg.append("@scourceId");
            msg.append(scourceIds);
            throw new KDException(msg.toString());
        }
        StringBuilder select = new StringBuilder();
        for (String field : selectFields) {
            if (select.length() != 0) {
                select.append(",");
            }
            select.append(field);
        }
        return QueryServiceHelper.query((String)billobjectNumber, (String)select.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", scourceIds), filterGrid});
    }

    private DynamicObject newDynamicObject(String pushtype) {
        return BusinessDataServiceHelper.newDynamicObject((String)pushtype);
    }

    private void setScorerEntry(DynamicObjectCollection entry_scorer, DynamicObject sourceBill, long indexclass, String scorervaluetype, String scorervalue, long scorer, BigDecimal weight) {
        DynamicObject newRow = entry_scorer.addNew();
        newRow.set("indexclass", (Object)indexclass);
        newRow.set("scorerweight", (Object)weight);
        if ("1".equals(scorervaluetype)) {
            newRow.set("scorer", (Object)scorer);
        } else if ("2".equals(scorervaluetype)) {
            long scorervalueId = sourceBill.getLong(scorervalue);
            newRow.set("scorer", (Object)scorervalueId);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void regularPush(Date date, Long retryTplId, boolean isRetry) {
        if (date == null) {
            return;
        }
        QFilter qf = new QFilter("exectype", "=", (Object)"1");
        qf.and("enable", "=", (Object)true);
        qf.and("expiringdate", ">=", (Object)date);
        qf.and("effectivedate", "<=", (Object)date);
        if (isRetry) {
            qf.and("id", "=", (Object)retryTplId);
        }
        DynamicObjectCollection srm_autoevatpls = QueryServiceHelper.query((String)"srm_autoevatpl", (String)this.getSelectFields(), (QFilter[])new QFilter[]{qf});
        int index = 0;
        HashMap<String, DynamicObject> autotplMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject srm_autoevatpl : srm_autoevatpls) {
            String execTag = this.getExecTag(srm_autoevatpl, date, ++index);
            if (!StringUtils.isNotBlank((CharSequence)execTag)) continue;
            autotplMap.put(execTag, srm_autoevatpl);
        }
        if (!isRetry) {
            Set execTagSet = autotplMap.keySet();
            DynamicObjectCollection tplCol = QueryServiceHelper.query((String)"srm_autoevatpl_log", (String)"id,tag", (QFilter[])new QFilter[]{new QFilter("tag", "in", execTagSet)});
            for (DynamicObject dynamicObject : tplCol) {
                String tag = dynamicObject.getString("tag");
                if (!StringUtils.isNotBlank((CharSequence)tag)) continue;
                autotplMap.remove(tag);
            }
        }
        HashSet<Object> pushEvaplanBatchPkSet = new HashSet<Object>(16);
        HashSet<Object> pushEvaplanPkSet = new HashSet<Object>(16);
        for (Map.Entry entry : autotplMap.entrySet()) {
            DynamicObject srm_autoevatpl = (DynamicObject)entry.getValue();
            String pushtype = srm_autoevatpl.getString("pushtype");
            if ("srm_evaplan_batch".equals(pushtype)) {
                pushEvaplanBatchPkSet.add(srm_autoevatpl.getLong("id"));
                continue;
            }
            if (!"srm_evaplan".equals(pushtype)) continue;
            pushEvaplanPkSet.add(srm_autoevatpl.getLong("id"));
        }
        int evaplanBatchIndex = 0;
        boolean bl = false;
        try {
            List<DynamicObject> srm_evaplan_batch = this.batchPushTargetBill(pushEvaplanBatchPkSet, "srm_evaplan_batch");
            List<DynamicObject> srm_evaplan = this.batchPushTargetBill(pushEvaplanPkSet, "srm_evaplan");
            DynamicObjectCollection tplScorerEntry = QueryServiceHelper.query((String)"srm_autoevatpl", (String)this.getEntryScorerSelectsFields(), (QFilter[])new QFilter[]{qf});
            ArrayList<String> autoTplList = new ArrayList<String>(10);
            for (DynamicObject tpl : autotplMap.values()) {
                String id = tpl.getString("id");
                autoTplList.add(id);
            }
            Map<Long, DynamicObject> execLogs = this.batchCreateExecLog(autoTplList, date, null);
            HashMap<Long, DynamicObject> tarbillexecLogsMap = new HashMap<Long, DynamicObject>(16);
            HashMap<Long, String> tarbillExecTagMap = new HashMap<Long, String>(16);
            DynamicObject targetBill = null;
            String pushtype = "srm_evaplan_batch";
            for (Map.Entry entry : autotplMap.entrySet()) {
                void var11_16;
                String execTag = (String)entry.getKey();
                DynamicObject srm_autoevatpl = (DynamicObject)entry.getValue();
                long tplId = srm_autoevatpl.getLong("id");
                DynamicObject execLog = execLogs.get(tplId);
                execLog.set("tag", (Object)execTag);
                try {
                    DynamicObjectCollection entryentity;
                    String tplName = srm_autoevatpl.getString("name");
                    boolean autogetvalue = srm_autoevatpl.getBoolean("autogetvalue");
                    Date lastExecDate = this.getlastExecDate(srm_autoevatpl, date);
                    pushtype = srm_autoevatpl.getString("pushtype");
                    long orgId = srm_autoevatpl.getLong("org");
                    String timevalue = srm_autoevatpl.getString("timevalue");
                    String timerange = srm_autoevatpl.getString("timerange");
                    String suppliervalue = srm_autoevatpl.getString("suppliervalue");
                    String categoryvalue = srm_autoevatpl.getString("categoryvalue");
                    String materialvalue = srm_autoevatpl.getString("materialvalue");
                    long schemeId = srm_autoevatpl.getLong("scheme");
                    long gradeId = srm_autoevatpl.getLong("grade");
                    String billobjectNumber = srm_autoevatpl.getString("billobject.number");
                    if ("srm_evaplan_batch".equals(pushtype)) {
                        targetBill = srm_evaplan_batch.get(evaplanBatchIndex++);
                    } else if ("srm_evaplan".equals(pushtype)) {
                        targetBill = srm_evaplan.get((int)var11_16++);
                    }
                    if (targetBill == null) continue;
                    tarbillexecLogsMap.put(targetBill.getLong("id"), execLog);
                    tarbillExecTagMap.put(targetBill.getLong("id"), execTag);
                    this.setDefaultValue(srm_autoevatpl, targetBill, lastExecDate);
                    targetBill.set("org", (Object)orgId);
                    HashSet<Long> supplierSet = new HashSet<Long>(16);
                    if (pushtype.equals("srm_evaplan")) {
                        entryentity = targetBill.getDynamicObjectCollection("entryentity");
                        for (DynamicObject entryRow : entryentity) {
                            long supplierId = entryRow.getLong("supplier.id");
                            if (supplierId == 0L) continue;
                            supplierSet.add(supplierId);
                        }
                        if (autogetvalue) {
                            QFilter timeFilter = this.getTimeFilter(srm_autoevatpl, lastExecDate, timerange, timevalue);
                            QFilter filterGrid = this.getFilterGrid(srm_autoevatpl);
                            supplierSet.addAll(this.getSupplierTypeTimeExec(billobjectNumber, suppliervalue, timeFilter, filterGrid));
                        }
                        entryentity.clear();
                        for (Long supplierId : supplierSet) {
                            DynamicObject newRow = entryentity.addNew();
                            newRow.set("supplier", (Object)supplierId);
                        }
                    } else {
                        if (autogetvalue) {
                            entryentity = targetBill.getDynamicObjectCollection("entryentity");
                            entryentity.clear();
                            String evamethod = srm_autoevatpl.getString("evamethod");
                            QFilter timeFilter = this.getTimeFilter(srm_autoevatpl, lastExecDate, timerange, timevalue);
                            QFilter filterGrid = this.getFilterGrid(srm_autoevatpl);
                            Set<String> evaObjectList = this.getEvaObjectTypeTimeExec(billobjectNumber, evamethod, suppliervalue, categoryvalue, materialvalue, timeFilter, filterGrid);
                            for (String evaObject : evaObjectList) {
                                DynamicObject newRow = entryentity.addNew();
                                String[] split = evaObject.split("-");
                                if (StringUtils.isNotBlank((CharSequence)split[0])) {
                                    newRow.set("supplier", (Object)Long.parseLong(split[0]));
                                }
                                if ("D".equals(evamethod) && StringUtils.isNotBlank((CharSequence)split[1])) {
                                    newRow.set("category", (Object)Long.parseLong(split[1]));
                                }
                                if ("B".equals(evamethod) && StringUtils.isNotBlank((CharSequence)split[2])) {
                                    newRow.set("material", (Object)Long.parseLong(split[2]));
                                }
                                newRow.set("scheme", (Object)schemeId);
                                newRow.set("grade", (Object)gradeId);
                            }
                            this.setBatchScorerEntry(entryentity, tplScorerEntry, tplId);
                        }
                        entryentity = targetBill.getDynamicObjectCollection("entryentity");
                        for (DynamicObject entryRow : entryentity) {
                            String weightstrategy = entryRow.getString("weightstrategy");
                            if (!StringUtils.isBlank((CharSequence)weightstrategy)) continue;
                            entryRow.set("weightstrategy", (Object)"B");
                        }
                    }
                    this.updateLogStatus(execLog, "B", null);
                }
                catch (Exception e) {
                    if (pushtype.equals("srm_evaplan")) {
                        --var11_16;
                        srm_evaplan.remove(targetBill);
                    } else if (pushtype.equals("srm_evaplan_batch")) {
                        --evaplanBatchIndex;
                        srm_evaplan_batch.remove(targetBill);
                    }
                    String errInfo = ExceptionUtil.wrapExceptionErrorInfo((Throwable)e);
                    this.updateLogStatus(execLog, "A", execTag + e.getMessage() + errInfo);
                }
            }
            HashMap<Long, StringBuilder> errMsgMap = new HashMap<Long, StringBuilder>(16);
            HashSet<Long> successPkIdsSet = new HashSet<Long>(16);
            this.handleSaveTarBillErrMsgMap(successPkIdsSet, errMsgMap, srm_evaplan, "srm_evaplan");
            this.handleSaveTarBillErrMsgMap(successPkIdsSet, errMsgMap, srm_evaplan_batch, "srm_evaplan_batch");
            this.updateLogsTarBillno(successPkIdsSet, tarbillexecLogsMap, srm_evaplan);
            this.updateLogsTarBillno(successPkIdsSet, tarbillexecLogsMap, srm_evaplan_batch);
            this.batchUpdateLogsStatus(tarbillexecLogsMap, errMsgMap, tarbillExecTagMap);
            Collection<DynamicObject> values = execLogs.values();
            DynamicObject[] execLogsArr = values.toArray(new DynamicObject[values.size()]);
            SaveServiceHelper.save((DynamicObject[])execLogsArr);
        }
        catch (Exception e) {
            this.log.error("\u7ee9\u6548\u8bc4\u4f30\u6a21\u677f\u5b9a\u671f\u89e6\u53d1\u51fa\u73b0\u5f02\u5e38\uff0c\u89e6\u53d1\u65f6\u95f4" + TimeServiceHelper.now() + "\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
    }

    private void batchUpdateLogsStatus(Map<Long, DynamicObject> tarbillexecLogsMap, Map<Long, StringBuilder> errMsgMap, Map<Long, String> tarbillExecTagMap) {
        for (Map.Entry<Long, DynamicObject> entry : tarbillexecLogsMap.entrySet()) {
            Long pkValue = entry.getKey();
            DynamicObject execLog = entry.getValue();
            StringBuilder stringBuilder = errMsgMap.get(pkValue);
            if (stringBuilder == null || stringBuilder.length() <= 0) continue;
            if (tarbillExecTagMap != null) {
                execLog.set("tag", (Object)tarbillExecTagMap.get(pkValue));
            }
            this.updateLogStatus(execLog, "A", stringBuilder.toString());
        }
    }

    private void handleSaveTarBillErrMsgMap(Set<Long> successPkIdsSet, Map<Long, StringBuilder> errMsgMap, List<DynamicObject> srm_evaplan, String evaplanName) {
        if (srm_evaplan != null && !srm_evaplan.isEmpty()) {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)evaplanName, (DynamicObject[])srm_evaplan.toArray(new DynamicObject[srm_evaplan.size()]), null);
            List successPkIds = operationResult.getSuccessPkIds();
            for (Object id : successPkIds) {
                successPkIdsSet.add(Long.parseLong(id.toString()));
            }
            for (IOperateInfo info : operationResult.getAllErrorOrValidateInfo()) {
                Long pkValue = Long.parseLong(info.getPkValue().toString());
                StringBuilder msg = errMsgMap.get(pkValue);
                String message = info.getMessage();
                if (msg == null) {
                    msg = new StringBuilder(message);
                } else {
                    msg.append(message);
                }
                errMsgMap.put(pkValue, msg);
            }
        }
    }

    private void updateLogsTarBillno(Set<Long> successPkIdsSet, Map<Long, DynamicObject> tarbillexecLogsMap, List<DynamicObject> srm_evaplan) {
        if (srm_evaplan == null || srm_evaplan.isEmpty()) {
            return;
        }
        for (DynamicObject evaplan : srm_evaplan) {
            long id = evaplan.getLong("id");
            String billno = evaplan.getString("billno");
            DynamicObject execLog = tarbillexecLogsMap.get(id);
            if (execLog == null || !successPkIdsSet.contains(id)) continue;
            execLog.set("targetbillno", (Object)billno);
        }
    }

    private String getExecTag(DynamicObject srm_autoevatpl, Date date, int index) {
        long tplId = srm_autoevatpl.getLong("id");
        String tplName = srm_autoevatpl.getString("name");
        String number = srm_autoevatpl.getString("number");
        String repeatunit = srm_autoevatpl.getString("repeatunit");
        Date lastExecDate = this.getlastExecDate(srm_autoevatpl, date);
        if (lastExecDate != null) {
            String execTag = this.getIsExecTag(lastExecDate, number, repeatunit);
            return execTag;
        }
        return null;
    }

    private Date getlastExecDate(DynamicObject srm_autoevatpl, Date date) {
        long tplId = srm_autoevatpl.getLong("id");
        String tplName = srm_autoevatpl.getString("name");
        String repeatunit = srm_autoevatpl.getString("repeatunit");
        int repeatnumber = srm_autoevatpl.getInt("repeatnumber");
        int execday = srm_autoevatpl.getInt("execday");
        Date startTime = SrmAutoEvaTplUtil.getStartTime((DynamicObject)srm_autoevatpl);
        int exectime = srm_autoevatpl.getInt("exectime");
        if (exectime != -1) {
            int exechour = exectime / 3600;
            int execminute = exectime / 60 % 60;
            int execsecond = exectime % 60;
            startTime.setHours(exechour);
            startTime.setMinutes(execminute);
            startTime.setSeconds(execsecond);
        }
        if (startTime == null || startTime.after(date) || StringUtils.isBlank((CharSequence)repeatunit) || !"4".equals(repeatunit) && repeatnumber == 0) {
            return null;
        }
        Date lastExecDate = startTime;
        while (startTime.before(date)) {
            lastExecDate = startTime;
            if (StringUtils.isNotBlank((CharSequence)repeatunit) && repeatunit.equals("3")) {
                startTime = KDDateUtils.addDays((Date)startTime, (int)repeatnumber);
            } else if (StringUtils.isNotBlank((CharSequence)repeatunit) && repeatunit.equals("2")) {
                startTime = KDDateUtils.addMonths((Date)startTime, (int)repeatnumber);
            } else if (StringUtils.isNotBlank((CharSequence)repeatunit) && repeatunit.equals("1")) {
                startTime = KDDateUtils.addYears((Date)startTime, (int)repeatnumber);
            } else if (StringUtils.isNotBlank((CharSequence)repeatunit) && repeatunit.equals("4")) {
                startTime = KDDateUtils.addMonths((Date)startTime, (int)3);
            }
            if ((long)execday != 32L || "3".equals(repeatunit) || "4".equals(repeatunit)) continue;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startTime);
            int actualMaximum = calendar.getActualMaximum(5);
            startTime.setDate(actualMaximum);
        }
        return lastExecDate;
    }

    private void setBatchScorerEntry(DynamicObjectCollection entryentity, DynamicObjectCollection tplScorerEntry, Long tplId) {
        for (DynamicObject entryRow : entryentity) {
            DynamicObjectCollection subentryentity = entryRow.getDynamicObjectCollection("subentryentity");
            subentryentity.clear();
            for (DynamicObject tplScorerRow : tplScorerEntry) {
                long queryTplId = tplScorerRow.getLong("id");
                if (tplId != queryTplId) continue;
                long indexclass = tplScorerRow.getLong("entryentity.indexclass");
                long scorer = tplScorerRow.getLong("entryentity.scorer");
                if (indexclass == 0L || scorer == 0L) continue;
                BigDecimal scorerweight = tplScorerRow.getBigDecimal("entryentity.scorerweight");
                DynamicObject newSubEntryEntityRow = subentryentity.addNew();
                newSubEntryEntityRow.set("indexclass", (Object)indexclass);
                newSubEntryEntityRow.set("scorer", (Object)scorer);
                newSubEntryEntityRow.set("scorerweight", (Object)scorerweight);
            }
        }
    }

    private Set<Long> getSupplierTypeTimeExec(String billobjectNumber, String suppliervalue, QFilter timeFilter, QFilter filterGrid) {
        HashSet<Long> supplierSet = new HashSet<Long>(16);
        String select = "id," + suppliervalue;
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)billobjectNumber, (String)select, (QFilter[])new QFilter[]{timeFilter, filterGrid});
        for (DynamicObject sourceBill : sourceBills) {
            long supplierId = sourceBill.getLong(suppliervalue);
            supplierSet.add(supplierId);
        }
        return supplierSet;
    }

    private Set<String> getEvaObjectTypeTimeExec(String billobjectNumber, String evamethod, String suppliervalue, String categoryvalue, String materialvalue, QFilter timeFilter, QFilter filterGrid) {
        DynamicObjectCollection sourceBills;
        HashSet<String> res = new HashSet<String>(10);
        String select = "id," + suppliervalue;
        if ("D".equals(evamethod) && StringUtils.isNotBlank((CharSequence)categoryvalue)) {
            select = select + "," + categoryvalue;
        }
        if ("B".equals(evamethod) && StringUtils.isNotBlank((CharSequence)materialvalue)) {
            select = select + "," + materialvalue;
        }
        if ((sourceBills = QueryServiceHelper.query((String)billobjectNumber, (String)select, (QFilter[])new QFilter[]{timeFilter, filterGrid})) == null || sourceBills.isEmpty()) {
            return res;
        }
        for (DynamicObject sourceBill : sourceBills) {
            StringBuilder evaObjectStr = new StringBuilder();
            long supplierId = sourceBill.getLong(suppliervalue);
            evaObjectStr.append(supplierId);
            if ("A".equals(evamethod)) {
                evaObjectStr.append("--");
            } else if ("D".equals(evamethod)) {
                long categoryId = sourceBill.getLong(categoryvalue);
                evaObjectStr.append("-");
                evaObjectStr.append(categoryId);
                evaObjectStr.append("-");
            } else if ("B".equals(evamethod)) {
                long materialId = sourceBill.getLong(materialvalue);
                evaObjectStr.append("--");
                evaObjectStr.append(materialId);
            }
            res.add(evaObjectStr.toString());
        }
        return res;
    }

    private QFilter getTimeFilter(DynamicObject srm_autoevatpl, Date lastExecDate, String timerange, String timevalue) {
        QFilter qf = null;
        if ("1".equals(timerange)) {
            Date startdate = srm_autoevatpl.getDate("startdate");
            Date enddate = srm_autoevatpl.getDate("enddate");
            enddate = KDDateUtils.addDays((Date)enddate, (int)1);
            qf = new QFilter(timevalue, ">=", (Object)startdate);
            qf.and(timevalue, "<=", (Object)enddate);
        } else if ("2".equals(timerange)) {
            String repeatunit = srm_autoevatpl.getString("repeatunit");
            int repeatnumber = srm_autoevatpl.getInt("repeatnumber");
            Date date = null;
            lastExecDate.setHours(0);
            lastExecDate.setMinutes(0);
            lastExecDate.setSeconds(0);
            if ("1".equals(repeatunit)) {
                date = KDDateUtils.addYears((Date)lastExecDate, (int)(-1 * repeatnumber));
            } else if ("2".equals(repeatunit)) {
                date = KDDateUtils.addMonths((Date)lastExecDate, (int)(-1 * repeatnumber));
            } else if ("3".equals(repeatunit)) {
                date = KDDateUtils.addDays((Date)lastExecDate, (int)(-1 * repeatnumber));
            } else if ("4".equals(repeatunit)) {
                date = KDDateUtils.addMonths((Date)lastExecDate, (int)-3);
            }
            qf = new QFilter(timevalue, ">=", (Object)date);
            qf.and(timevalue, "<=", (Object)lastExecDate);
        }
        return qf;
    }

    private QFilter getFilterGrid(DynamicObject srm_autoevatpl) {
        String filtertext_tag = srm_autoevatpl.getString("filtertext_tag");
        if (StringUtils.isBlank((CharSequence)filtertext_tag)) {
            return null;
        }
        return QFilter.fromSerializedString((String)filtertext_tag);
    }

    private String getIsExecTag(Date lastExecDate, String number, String repeatunit) {
        StringBuilder tag = new StringBuilder(number);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(lastExecDate);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        if ("1".equals(repeatunit)) {
            tag.append("-");
            tag.append(year);
        } else if ("2".equals(repeatunit)) {
            tag.append("-");
            tag.append(year);
            tag.append("-");
            tag.append(month);
        } else if ("3".equals(repeatunit) || "4".equals(repeatunit)) {
            tag.append("-");
            tag.append(year);
            tag.append("-");
            tag.append(month);
            tag.append("-");
            tag.append(day);
        }
        return tag.toString();
    }

    private void setDefaultValue(DynamicObject srm_autoevatpl, DynamicObject targetBill, Date date) {
        String name = srm_autoevatpl.getString("name");
        long evatype = srm_autoevatpl.getLong("evatype");
        StringBuilder targetName = new StringBuilder(name);
        targetBill.set("name", (Object)targetName.toString());
        int finishdateoffset = srm_autoevatpl.getInt("finishdateoffset");
        Date billdate = date;
        Date finishdate = KDDateUtils.addDays((Date)date, (int)finishdateoffset);
        targetBill.set("billdate", (Object)billdate);
        targetBill.set("finishdate", (Object)finishdate);
        targetBill.set("evatype", (Object)evatype);
    }

    private String getSelectFields() {
        return "id,number,name,timevalue,org,pushtype,repeatnumber,repeatunit,execmonth,execday,evatype,evamethod,scheme,scheme.name,grade,effectivedate,expiringdate,exectime,autogetvalue,billobject,billobject.number,op,evaorgvalue,suppliervalue,timerange,startdate,enddate,finishdatetype,finishdateoffset,filtertext,filtertext_tag,categoryvalue,materialvalue";
    }

    private String getEntryScorerSelectsFields() {
        return "id,entryentity.indexclass,entryentity.scorervaluetype,entryentity.scorervalue,entryentity.scorer,entryentity.scorerweight";
    }

    private String getEntrySupplierSelectsFields() {
        return "entryentity1.supplier,entryentity1.suppliernote";
    }

    private String getEntryEvaObjectScorerSelectsFields() {
        return "evasupentry.evacategory,evasupentry.evamaterial,evasupentry.evasupplier,evasupentry.evascheme,evasupentry.weightstrategy,evasupentry.evagrade,evasupentry.evasupnote";
    }

    private String getEntrySubEvaObjectSelectsFields() {
        return "evasupentry.evascorerentry.evaindexclass,evasupentry.evascorerentry.evascorer,evasupentry.evascorerentry.evascorerweight";
    }

    public void pushEvaPlanBatch() {
    }

    @Deprecated
    public void push(String sourceBillId, long tplId, Date date) {
    }

    @Deprecated
    public void push(Date date, boolean isRetry) {
    }
}

