/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service.edit;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;

public class SrmEvaluatPaneSearchService {
    private String org;
    private String name;

    public SrmEvaluatPaneSearchService() {
    }

    public SrmEvaluatPaneSearchService(String org, String name, String supplierName) {
        this.org = org;
        this.name = name;
    }

    public QFilter[] bulidEvaplanQfilters(String org_fiter, String name_fiter) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        ArrayList<String> orgs = this.strtoList(this.org);
        ArrayList<String> names = this.strtoList(this.name);
        QFilter orgFilter = this.getSearchFilter(orgs, org_fiter);
        QFilter nameFilter = this.getSearchFilter(names, name_fiter);
        if (Objects.nonNull(orgFilter)) {
            qFilters.add(orgFilter);
        }
        if (Objects.nonNull(nameFilter)) {
            qFilters.add(nameFilter);
        }
        if (qFilters.size() > 0) {
            QFilter qFilter = this.bulidOrFilterByLists(qFilters);
            return new QFilter[]{qFilter};
        }
        return null;
    }

    private QFilter bulidOrFilterByLists(List<QFilter> qFilters) {
        if (CollectionUtils.isEmpty(qFilters)) {
            return null;
        }
        if (qFilters.size() == 1) {
            return qFilters.get(0);
        }
        if (qFilters.size() > 1) {
            QFilter qFilter = qFilters.get(0);
            qFilters.remove(0);
            for (QFilter filter : qFilters) {
                qFilter.or(filter);
            }
            return qFilter;
        }
        return null;
    }

    private QFilter getSearchFilter(ArrayList<String> orgFilters, String name) {
        QFilter ofilter = null;
        if (CollectionUtils.isEmpty(orgFilters)) {
            return ofilter;
        }
        for (String filter : orgFilters) {
            if (ofilter == null) {
                ofilter = new QFilter(name, "like", (Object)("%" + filter + "%"));
                continue;
            }
            ofilter.or(new QFilter(name, "like", (Object)("%" + filter + "%")));
        }
        return ofilter;
    }

    public ArrayList<String> strtoList(String filterString) {
        String substring;
        String[] fileterArray;
        ArrayList<String> fileterList = new ArrayList<String>(1);
        if (StringUtils.isNotEmpty((CharSequence)filterString) && filterString.length() > 1 && (fileterArray = (substring = filterString.substring(1, filterString.length() - 1)).split(",")).length > 0) {
            for (String fileter : fileterArray) {
                fileterList.add(fileter);
            }
            return fileterList;
        }
        return fileterList;
    }
}

