/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service.edit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.JacksonJsonUtil;

public class SrmScoreRptDyService {
    public Object[] getScoreIds(Map<String, Object> param) {
        Object[] score_id = new Object[]{};
        try {
            if (Objects.nonNull(param.get("score_Id"))) {
                score_id = (Object[])JacksonJsonUtil.fromJSON((String)param.get("score_Id").toString(), Object[].class);
            }
        }
        catch (IOException e1) {
            BizLog.log((String)("SrmScoreRptDyService getScoreIds is fail e:" + e1));
        }
        return score_id;
    }

    public DynamicObjectCollection queryReptByIds(Map<String, Object> param) {
        Object[] scoreIds = this.getScoreIds(param);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)scoreIds)};
        DynamicObjectCollection queryRept = QueryServiceHelper.query((String)"srm_scorerpt", (String)"id,supplier,calgrade,sumscore,billno", (QFilter[])qFilters);
        return queryRept;
    }

    public List<Long> getSupplierIds(DynamicObjectCollection queryRept) {
        ArrayList<Long> suIds = new ArrayList<Long>(16);
        if (!CollectionUtils.isEmpty((Collection)queryRept)) {
            for (DynamicObject supDyo : queryRept) {
                suIds.add(supDyo.getLong("supplier"));
            }
        }
        return suIds;
    }

    public Map<Long, DynamicObject> supplierMapDyo(Map<String, Object> param) {
        DynamicObjectCollection queryRept = this.queryReptByIds(param);
        Map<Long, DynamicObject> supplierMapDyo = new HashMap<Long, DynamicObject>(16);
        if (!CollectionUtils.isEmpty((Collection)queryRept)) {
            supplierMapDyo = queryRept.stream().collect(Collectors.toMap(x -> x.getLong("supplier"), x -> x));
        }
        return supplierMapDyo;
    }
}

