/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.MessageUtil;

public class SrmScoreRptMessageService {
    public void sendmsg(List<Long> billIds, String opKey, String nowEntryType) {
        DynamicObjectCollection billObj = this.getBillObject(billIds, "srm_scorerpt");
        Map<Long, List<Long>> partneridMapAdminUserId = this.getBizpartneridMapAdminUserId((List<DynamicObject>)billObj);
        List<Long> userIds = this.getBillSupAdmins(partneridMapAdminUserId);
        Set<Long> enableUserId = this.filterUnableUser(userIds);
        for (DynamicObject obj : billObj) {
            Map<String, Object> msgParam = this.toSupAdminMap(obj, partneridMapAdminUserId, enableUserId);
            List recIds = (List)msgParam.get("receiveUserIds");
            if (recIds.isEmpty()) continue;
            Object name = obj.get("org.name");
            msgParam.put("title", ResManager.loadKDString((String)"\u8bc4\u4f30\u62a5\u544a\u901a\u77e5", (String)"SrmScoreRptMessageService_0", (String)"scm-srm-mservice", (Object[])new Object[0]));
            msgParam.put("entityNumber", "srm_scorerpt");
            if (!"confirm".equals(opKey) && !"agree".equals(opKey)) continue;
            if ("srm_review".equals(nowEntryType) || "srm_reviewdy".equals(nowEntryType)) {
                msgParam.put("content", ResManager.loadResFormat((String)ResManager.loadKDString((String)"%1 \u6709\u65b0\u53d1\u5e03\u7684\u8bc4\u4f30\u62a5\u544a\uff0c\u62a5\u544a\u72b6\u6001\u4e3a\u201c\u521d\u5ba1\u901a\u8fc7\u201d\uff0c\u8bf7\u60a8\u67e5\u9605\u3002", (String)"SrmScoreRptMessageService_1", (String)"scm-srm-mservice", (Object[])new Object[0]), (String)"SrmScoreptSendMsgOp_1", (String)"scm-srm-opplugin", (Object[])new Object[]{name}));
                msgParam.put("tplScene", "srmscorerptreviewconfirm");
            }
            if ("srm_approve".equals(nowEntryType) || "srm_approvedy".equals(nowEntryType) || "srm_directapprove".equals(nowEntryType)) {
                msgParam.put("content", ResManager.loadResFormat((String)ResManager.loadKDString((String)"%1 \u6709\u65b0\u53d1\u5e03\u7684\u8bc4\u4f30\u62a5\u544a\uff0c\u62a5\u544a\u72b6\u6001\u4e3a\u201c\u6838\u51c6\u901a\u8fc7\u201d\uff0c\u8bf7\u60a8\u67e5\u9605\u3002", (String)"SrmScoreRptMessageService_2", (String)"scm-srm-mservice", (Object[])new Object[0]), (String)"SrmScoreptSendMsgOp_2", (String)"scm-srm-opplugin", (Object[])new Object[]{name}));
                msgParam.put("tplScene", "srmscorerptapproveconfirm");
            }
            MessageUtil.sendMessage(msgParam, (boolean)false);
        }
    }

    public DynamicObjectCollection getBillObject(List<Long> billIds, String entityType) {
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)entityType, (String)this.getSql(), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        return dynamicObjectCollection;
    }

    public String getSql() {
        return "id,creator.id,org.name,billno,supplier.bizpartner.id,supplier.name";
    }

    public Map<Long, List<Long>> getBizpartneridMapAdminUserId(List<DynamicObject> list) {
        Map<Long, List<Long>> map = new HashMap<Long, List<Long>>();
        ArrayList<Long> bizpartnerids = new ArrayList<Long>();
        for (DynamicObject obj : list) {
            Object bizpartnerid = obj.get("supplier.bizpartner.id");
            if (null == bizpartnerid) continue;
            bizpartnerids.add((Long)bizpartnerid);
        }
        if (!bizpartnerids.isEmpty()) {
            map = BizPartnerUtil.getAdminSupUsersByBizPartners(bizpartnerids);
        }
        return map;
    }

    public Set<Long> filterUnableUser(List<Long> userIds) {
        HashSet<Long> idSet = new HashSet<Long>();
        QFilter filter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        filter.and(new QFilter("id", "in", userIds));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])filters);
        for (DynamicObject obj : objs) {
            Long pk = (Long)obj.get("id");
            idSet.add(pk);
        }
        return idSet;
    }

    public List<Long> getBillSupAdmins(Map<Long, List<Long>> partneridMapAdminUsers) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        partneridMapAdminUsers.forEach((k, v) -> userIds.addAll((Collection<Long>)v));
        return userIds;
    }

    public Map<String, Object> toSupAdminMap(DynamicObject obj, Map<Long, List<Long>> map, Set<Long> enableUserId) {
        Object pkvalue = obj.get("id");
        Object bizpartnerid = obj.get("supplier.bizpartner.id");
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        List<Long> userIds = map.get((Long)bizpartnerid);
        if (null != userIds) {
            for (Long userId : userIds) {
                if (!enableUserId.contains(userId)) continue;
                receiveUserIds.add(userId);
            }
        }
        return this.getBaseMsgParamMap(receiveUserIds, pkvalue);
    }

    public Map<String, Object> getBaseMsgParamMap(List<Long> receiveUserIds, Object pkvalue) {
        HashMap<String, Object> msgParam = new HashMap<String, Object>(16);
        msgParam.put("receiveUserIds", receiveUserIds);
        msgParam.put("pkId", pkvalue);
        msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
        return msgParam;
    }
}

