/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service.list;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmEvaPlanStatusEnum;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.SrmCommonUtil;

public class SrmScoreRptListService {
    public void dealReviewReurnData(HashMap<String, Object> returnData, Object[] primaryKeyValues, boolean directapprove) {
        if (Objects.nonNull(returnData) && returnData.size() > 0 && Objects.nonNull(primaryKeyValues)) {
            String cfmOption = returnData.get("cfmOption").toString();
            String result = returnData.get("result").toString();
            DynamicObject[] reports = BusinessDataServiceHelper.load((String)"srm_scorerpt", (String)"id,bizstatus,suggestion,calgrade,supgrade,reviewer,reviewdate,taskbillid,trialresult", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
            if (Objects.nonNull(reports) && reports.length > 0) {
                HashSet<Long> taskIds = new HashSet<Long>(1);
                for (DynamicObject report : reports) {
                    String bizstatus = report.getString("bizstatus");
                    if (directapprove && !"D".equals(bizstatus)) continue;
                    report.set("suggestion", (Object)cfmOption);
                    if (directapprove) {
                        long calgradeId = report.getLong("calgrade.id");
                        report.set("supgrade", (Object)calgradeId);
                    } else {
                        Long supgrade = Long.parseLong(returnData.get("supgrade").toString());
                        report.set("supgrade", (Object)supgrade);
                    }
                    report.set("reviewer", (Object)Long.parseLong(RequestContext.get().getUserId()));
                    report.set("reviewdate", (Object)TimeServiceHelper.now());
                    if ("reject".equals(result)) {
                        report.set("bizstatus", (Object)SrmScoreStatusEnum.UNTRIALED.getValue());
                        report.set("trialresult", (Object)"C");
                    } else {
                        report.set("bizstatus", (Object)SrmScoreStatusEnum.TRIALED.getValue());
                        report.set("trialresult", (Object)"B");
                    }
                    taskIds.add(report.getLong("taskbillid"));
                }
                SaveServiceHelper.update((DynamicObject[])reports);
                if (taskIds.size() > 0) {
                    SrmCommonUtil.setEvaPlanStatus(taskIds, (String)SrmEvaPlanStatusEnum.TRIALED.getValue(), (String)SrmScoreStatusEnum.TRIALED.getValue(), (String)SrmScoreStatusEnum.UNTRIALED.getValue());
                }
            }
        }
    }

    public void dealApproveReurnData(HashMap<String, Object> returnData, Object[] primaryKeyValues, boolean directapprove) {
        if (Objects.nonNull(returnData) && returnData.size() > 0 && Objects.nonNull(primaryKeyValues)) {
            String cfmOption = returnData.get("cfmOption").toString();
            String result = returnData.get("result").toString();
            DynamicObject[] reports = BusinessDataServiceHelper.load((String)"srm_scorerpt", (String)"id,bizstatus,auditopinion,calgrade,supgrade,auditgrade,approver,approvedate,taskbillid,auditresult", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
            if (Objects.nonNull(reports) && reports.length > 0) {
                HashSet<Long> taskIds = new HashSet<Long>(1);
                for (DynamicObject report : reports) {
                    report.set("auditopinion", (Object)cfmOption);
                    String bizstatus = report.getString("bizstatus");
                    if (directapprove && ("D".equals(bizstatus) || "F".equals(bizstatus))) {
                        long calgradeId = report.getLong("calgrade.id");
                        report.set("auditgrade", (Object)calgradeId);
                    } else if (directapprove && "E".equals(bizstatus)) {
                        long supgradeId = report.getLong("supgrade.id");
                        report.set("auditgrade", (Object)supgradeId);
                    } else {
                        Long supgrade = Long.parseLong(returnData.get("supgrade").toString());
                        report.set("auditgrade", (Object)supgrade);
                    }
                    report.set("approver", (Object)Long.parseLong(RequestContext.get().getUserId()));
                    report.set("approvedate", (Object)TimeServiceHelper.now());
                    if ("reject".equals(result)) {
                        report.set("bizstatus", (Object)SrmScoreStatusEnum.UNAPPROVED.getValue());
                        report.set("auditresult", (Object)"C");
                    } else {
                        report.set("bizstatus", (Object)SrmScoreStatusEnum.APPROVED.getValue());
                        report.set("auditresult", (Object)"B");
                    }
                    taskIds.add(report.getLong("taskbillid"));
                }
                SaveServiceHelper.update((DynamicObject[])reports);
                if (taskIds.size() > 0) {
                    SrmCommonUtil.setEvaPlanStatus(taskIds, (String)SrmEvaPlanStatusEnum.APPROVED.getValue(), (String)SrmScoreStatusEnum.APPROVED.getValue(), (String)SrmScoreStatusEnum.UNAPPROVED.getValue());
                }
            }
        }
    }
}

