/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.report.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.OrgUtil;

public class SrmQualificationReportEditPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        ReportList reportlistap;
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        BasedataEdit supplier = (BasedataEdit)this.getControl("supplier");
        if (Objects.nonNull(org)) {
            org.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if (Objects.nonNull(supplier)) {
            supplier.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if (Objects.nonNull(reportlistap = (ReportList)this.getControl("reportlistap"))) {
            reportlistap.addHyperClickListener(this::hyperLinkClick);
        }
    }

    public void afterCreateNewData(EventObject e) {
        long orgId = RequestContext.get().getOrgId();
        this.getModel().setValue("org", (Object)orgId);
        if (this.isNewQualification()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"aptitudetypefilter"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"newaptitudetypefilter"});
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columns = event.getColumns();
        ArrayList<String> needHideList = new ArrayList<String>();
        if (this.isNewQualification()) {
            needHideList.add("aptitudetype");
            this.hideColumn(columns, needHideList);
        } else {
            needHideList.add("aptitudetype1");
            needHideList.add("quaclass");
            this.hideColumn(columns, needHideList);
        }
    }

    private boolean isNewQualification() {
        return QueryServiceHelper.exists((String)"pur_updateparamconfig", (QFilter[])new QFilter[]{new QFilter("paramkey", "=", (Object)"enableNewQualification").and(new QFilter("paramvalue", "=", (Object)"Y"))});
    }

    private void hideColumn(List<AbstractReportColumn> columns, List<String> needHideList) {
        for (AbstractReportColumn column : columns) {
            ReportColumn column11 = (ReportColumn)column;
            String fieldKey = column11.getFieldKey();
            if (!needHideList.contains(fieldKey)) continue;
            column11.setHide(true);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Long org;
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("org".equals(fieldKey)) {
            List orgids = OrgUtil.getAllPurViewPermissionOrgs((String)"srm_supplier");
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgids));
        }
        if ("supplier".equals(fieldKey) && Objects.nonNull(org = Long.valueOf(this.getModel().getDataEntity().getLong("org_id")))) {
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"srm_supplier", (Long)org);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName;
        DynamicObject rowData = hyperLinkClickEvent.getRowData();
        DynamicObject supplier = rowData.getDynamicObject("supplier");
        if (!Objects.nonNull(supplier)) {
            return;
        }
        switch (fieldName = hyperLinkClickEvent.getFieldName()) {
            case "supplier": {
                OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"srm_supplier", (Object)supplier.getPkValue(), (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
                break;
            }
            case "attachment": {
                this.openAttachment(rowData);
                break;
            }
        }
    }

    private void openAttachment(DynamicObject rowData) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"srm_supplier", (String)this.buildSelectField(), (QFilter[])this.buildFilter(rowData));
        DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entry_aptitude");
        DynamicObject supplierEntity = new DynamicObject();
        for (DynamicObject apptitudeEntry : entry) {
            String aptitudetype = (String)apptitudeEntry.get("aptitudetype");
            if (aptitudetype == null || !aptitudetype.equals(rowData.getString("aptitudetype"))) continue;
            supplierEntity = apptitudeEntry;
        }
        DynamicObjectCollection attcoll = supplierEntity.getDynamicObjectCollection("attachmentfield");
        ArrayList<Object> list = new ArrayList<Object>();
        for (DynamicObject attachment : attcoll) {
            list.add(attachment.get("fbasedataid_id"));
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("v", list);
        value.put("l", true);
        value.put("r", 3);
        value.put("tempAttPageId", this.getView().getPageId());
        value.put("maxAtmCount", 20);
        value.put("maxAtmSize", 10);
        value.put("sortField", "uploadTime");
        value.put("sortType", "ASC");
        value.put("entityNum", dynamicObject.getDataEntityType().getName());
        value.put("logEntityNum", dynamicObject.getDataEntityType().getName());
        Object pkValue = dynamicObject.getPkValue();
        value.put("billPkId", pkValue == null ? "" : pkValue.toString());
        value.put("attKey", "attachmentfield");
        value.put("k", "attachmentfield");
        value.put("tableName", "t_pur_regsupaptitude_fj");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("srm_attachment_download");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParams(value);
        this.getView().showForm(formShowParameter);
    }

    public String buildSelectField() {
        return "id,entry_aptitude.attachmentfield,entry_aptitude.aptitudetype";
    }

    public QFilter[] buildFilter(DynamicObject rowData) {
        DynamicObject supplier = rowData.getDynamicObject("supplier");
        long supplierId = (Long)supplier.getPkValue();
        DynamicObject createorg = rowData.getDynamicObject("createorg");
        String aptitudetype = rowData.getString("aptitudetype");
        QFilter filter = new QFilter("id", "=", (Object)supplierId);
        if (aptitudetype != null && !aptitudetype.equals("")) {
            filter.and(new QFilter("entry_aptitude.aptitudetype", "=", (Object)aptitudetype));
        }
        if (createorg != null) {
            filter.and(new QFilter("createorg", "=", (Object)createorg.getLong("id")));
        }
        return new QFilter[]{filter};
    }
}

