/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.report.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class SrmEvaplanReportListPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterItemInfo evplanFilterItem = reportQueryParam.getFilter().getFilterItem("evplan.id");
        if (Objects.isNull(evplanFilterItem)) {
            DataSet rows = QueryServiceHelper.queryDataSet((String)"SrmEvaplanReportListPlugin", (String)"srm_score", (String)" ", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)0)}, (String)" ");
            return rows;
        }
        Object id = evplanFilterItem.getValue();
        QFilter[] qFilters = new QFilter[]{new QFilter("taskbillid", "=", id)};
        DynamicObjectCollection schemeDys = QueryServiceHelper.query((String)"srm_score", (String)"entry.index", (QFilter[])qFilters);
        DynamicObject evaplan = QueryServiceHelper.queryOne((String)"srm_evaplan", (String)"id,evamethod", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
        if (CollectionUtils.isEmpty((Collection)schemeDys) || Objects.isNull(evaplan)) {
            DataSet rows = QueryServiceHelper.queryDataSet((String)"SrmEvaplanReportListPlugin", (String)"srm_score", (String)" ", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)0)}, (String)" ");
            return rows;
        }
        String evamethod = evaplan.getString("evamethod");
        Set<Long> indexIds = schemeDys.stream().map(x -> x.getLong("entry.index")).distinct().collect(Collectors.toSet());
        String selectFieldSql = this.bulidSelectFieldSql(indexIds, evamethod);
        String sql = this.bulidQuerySql(Long.valueOf(id.toString()), selectFieldSql, evamethod);
        DataSet dataSet = DB.queryDataSet((String)"SrmEvaplanReportListPlugin", (DBRoute)new DBRoute("scm"), (String)sql);
        return dataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        ReportQueryParam queryParam = this.getQueryParam();
        FilterItemInfo evplan = queryParam.getFilter().getFilterItem("evplan.id");
        if (Objects.isNull(evplan)) {
            return columns;
        }
        DynamicObject evaplanDy = QueryServiceHelper.queryOne((String)"srm_evaplan", (String)"entryentity.supplier", (QFilter[])new QFilter[]{new QFilter("id", "=", evplan.getValue())});
        if (Objects.nonNull(evaplanDy)) {
            Object supId = evaplanDy.get("entryentity.supplier");
            QFilter[] qFilters = new QFilter[]{new QFilter("supplier", "=", supId).and("taskbillid", "=", evplan.getValue())};
            DynamicObjectCollection schemeDys = QueryServiceHelper.query((String)"srm_score", (String)this.selectScoreIndexField(), (QFilter[])qFilters);
            Iterator iterator = schemeDys.iterator();
            ArrayList<Long> indexIds = new ArrayList<Long>(12);
            while (iterator.hasNext()) {
                DynamicObject score = (DynamicObject)iterator.next();
                long indexId = score.getLong("entry.index");
                if (indexIds.contains(indexId)) {
                    iterator.remove();
                    continue;
                }
                indexIds.add(indexId);
            }
            ArrayList<ReportColumnGroup> typrGroups = new ArrayList<ReportColumnGroup>();
            this.addIdexTypeGroup(schemeDys, typrGroups);
            this.addIndexClassGroup(schemeDys, typrGroups);
            this.addIndexColum(schemeDys, typrGroups);
            columns.addAll(2, typrGroups);
        }
        return columns;
    }

    protected String selectScoreIndexField() {
        return "entry.index,entry.index.number,entry.index.name,entry.index.indextype,entry.index.indextype.name,entry.index.indextype.number,entry.index.indexclass,entry.index.indexclass.number,entry.index.indexclass.name";
    }

    protected String bulidQuerySql(Long taskId, String selectStr, String evaMathed) {
        StringBuilder sqlStr = new StringBuilder(16);
        sqlStr.append("SELECT ");
        sqlStr.append(selectStr);
        sqlStr.append(" FROM T_PUR_SCORE A LEFT JOIN t_pur_scoreentry C ON C.FId=A.FId LEFT JOIN T_PUR_SCORE_a D ON D.FId=A.FId");
        sqlStr.append(" WHERE A.ftaskbillid = ");
        sqlStr.append(taskId);
        sqlStr.append(" group by A.FSupplierID,A.FmaterialId ");
        sqlStr.append(" ORDER BY sunscore DESC");
        return sqlStr.toString();
    }

    protected String bulidSelectFieldSql(Set<Long> indexIds, String evaMathed) {
        StringBuilder selectSqlStr = new StringBuilder(16);
        if ("B".equals(evaMathed)) {
            selectSqlStr.append("A.FmaterialId AS \"material\",");
            selectSqlStr.append("max(A.FSupplierID) AS \"supplier\",");
        } else {
            selectSqlStr.append("A.FSupplierID AS \"supplier\",");
            selectSqlStr.append("max(A.FmaterialId) AS \"material\",");
        }
        for (Long indexId : indexIds) {
            selectSqlStr.append(" max(case when C.FIndexID=");
            selectSqlStr.append(indexId);
            selectSqlStr.append(" then C.ffinalscore end ) AS \"");
            selectSqlStr.append(indexId);
            selectSqlStr.append("\",");
        }
        selectSqlStr.append("max(A.FSumScore) AS \"sunscore\",");
        selectSqlStr.append("max(A.fcalgradeid) AS \"grade\",");
        selectSqlStr.append("max(A.FSupGradeID) AS \"supgrade\",");
        selectSqlStr.append("max(D.FSuggestion) AS \"suggestion\",");
        selectSqlStr.append("max(A.fauditgradeid) AS \"auditgrade\",");
        selectSqlStr.append("max(D.fauditopinion) AS \"auditopinion\"");
        return selectSqlStr.toString();
    }

    protected void addIdexTypeGroup(DynamicObjectCollection schemeDys, List<ReportColumnGroup> typrGroups) {
        if (!CollectionUtils.isEmpty((Collection)schemeDys)) {
            ArrayList<Long> indexTypeIds = new ArrayList<Long>(24);
            for (DynamicObject schemeDy : schemeDys) {
                Long indexTypeId = schemeDy.getLong("entry.index.indextype");
                String indextypeName = schemeDy.getString("entry.index.indextype.name");
                if (indexTypeIds.contains(indexTypeId)) continue;
                ReportColumnGroup typeGroup = new ReportColumnGroup();
                typeGroup.setCaption(new LocaleString(indextypeName));
                typeGroup.setFieldKey(indexTypeId.toString());
                indexTypeIds.add(indexTypeId);
                typrGroups.add(typeGroup);
            }
        }
    }

    protected void addIndexClassGroup(DynamicObjectCollection schemeDys, List<ReportColumnGroup> columns) {
        if (!CollectionUtils.isEmpty((Collection)schemeDys)) {
            ArrayList<Long> exitIndexClassIds = new ArrayList<Long>(24);
            for (DynamicObject schemeDy : schemeDys) {
                Long indexTypeId = schemeDy.getLong("entry.index.indextype");
                Long indexClassId = schemeDy.getLong("entry.index.indexclass");
                String indexclassName = schemeDy.getString("entry.index.indexclass.name");
                for (ReportColumnGroup column : columns) {
                    String fieldKey = column.getFieldKey();
                    if (!indexTypeId.toString().equals(fieldKey) || indexTypeId == 0L || exitIndexClassIds.contains(indexClassId)) continue;
                    ReportColumnGroup indexClassGroup = new ReportColumnGroup();
                    indexClassGroup.setCaption(new LocaleString(indexclassName));
                    indexClassGroup.setFieldKey(indexClassId.toString());
                    column.getChildren().add(indexClassGroup);
                    exitIndexClassIds.add(indexClassId);
                }
            }
        }
    }

    protected void addIndexColum(DynamicObjectCollection schemeDys, List<ReportColumnGroup> columns) {
        if (!CollectionUtils.isEmpty((Collection)schemeDys)) {
            for (DynamicObject schemeDy : schemeDys) {
                Long indexTypeId = schemeDy.getLong("entry.index.indextype");
                Long indexClassId = schemeDy.getLong("entry.index.indexclass");
                Long indexId = schemeDy.getLong("entry.index");
                String indexName = schemeDy.getString("entry.index.name");
                for (ReportColumnGroup column : columns) {
                    String fieldKey = column.getFieldKey();
                    if (!indexTypeId.toString().equals(fieldKey) || indexTypeId == 0L) continue;
                    List indexClassGroups = column.getChildren();
                    for (AbstractReportColumn indexClassGroup : indexClassGroups) {
                        if (!(indexClassGroup instanceof ReportColumnGroup)) continue;
                        ReportColumnGroup indexReportColumnGroup = (ReportColumnGroup)indexClassGroup;
                        String indexGroupFiledKey = indexReportColumnGroup.getFieldKey();
                        if (!indexClassId.toString().equals(indexGroupFiledKey) || indexClassId == 0L) continue;
                        ReportColumn indexColum = new ReportColumn();
                        indexColum.setCaption(new LocaleString(indexName));
                        indexColum.setFieldKey(indexId.toString());
                        indexColum.setFieldType("text");
                        indexReportColumnGroup.getChildren().add(indexColum);
                    }
                }
            }
        }
    }
}

