/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.report.list;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class SrmQualificationReportListPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterInfo filter = reportQueryParam.getFilter();
        QFilter[] qFilters = this.bulidQfilter(filter);
        return QueryServiceHelper.queryDataSet((String)"SrmQualificationReportListPlugin", (String)"srm_supplier", (String)this.bulidSelectField(), (QFilter[])qFilters, (String)"entry_aptitude.dateto asc,id");
    }

    protected String bulidSelectField() {
        String attachment = ResManager.loadKDString((String)"\u4e0b\u8f7d", (String)"ScmSrmReport_0", (String)"scm-srm-report", (Object[])new Object[0]);
        return "id supplier,createorg,name,auditstatus,supplier bdsupplier,enable,entry_aptitude.aptitudetype aptitudetype,entry_aptitude.aptitudename aptitudename,entry_aptitude.issueorg issueorg,entry_aptitude.aptitudetype1 aptitudetype1,entry_aptitude.aptitudenumber aptitudenumber,entry_aptitude.aptitudegrade aptitudegrade,entry_aptitude.issuedate issuedate,entry_aptitude.dateto dateto,entry_aptitude.checkdate checkdate,entry_aptitude.aptitudenote aptitudenote,'" + attachment + "' attachment";
    }

    protected QFilter[] bulidQfilter(FilterInfo filter) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        QFilter supByOrgQfilter = this.bulidSupplierIdByOrg(filter);
        QFilter supQfilter = this.bulidSupplerFilter(filter);
        QFilter aptitudetypeQfilter = this.bulidAptitudetypeFilter(filter);
        QFilter newaptitudetypeQfilter = this.bulidNewAptitudetypeFilter(filter);
        QFilter toDateqFilter = this.bulidTodateQfilter(filter);
        if (Objects.nonNull(supByOrgQfilter)) {
            qFilters.add(supByOrgQfilter);
        }
        if (Objects.nonNull(supQfilter)) {
            qFilters.add(supQfilter);
        }
        if (Objects.nonNull(aptitudetypeQfilter)) {
            qFilters.add(aptitudetypeQfilter);
        }
        if (Objects.nonNull(newaptitudetypeQfilter)) {
            qFilters.add(newaptitudetypeQfilter);
        }
        if (Objects.nonNull(toDateqFilter)) {
            qFilters.add(toDateqFilter);
        }
        QFilter[] qFiltersArray = qFilters.toArray(new QFilter[qFilters.size()]);
        return qFiltersArray;
    }

    private QFilter bulidTodateQfilter(FilterInfo filter) {
        FilterItemInfo todate = filter.getFilterItem("todate");
        QFilter qFilter = null;
        if (Objects.nonNull(todate)) {
            Integer todateValue = (Integer)todate.getValue();
            Date today = TimeServiceHelper.today();
            Calendar instance = Calendar.getInstance();
            instance.setTime(today);
            instance.add(5, todateValue);
            Date addDate = instance.getTime();
            qFilter = new QFilter("entry_aptitude.dateto", "<=", (Object)addDate);
            return qFilter;
        }
        return qFilter;
    }

    private QFilter bulidSupplierIdByOrg(FilterInfo filter) {
        DynamicObject orgValue;
        FilterItemInfo org = filter.getFilterItem("org");
        QFilter qFilter = null;
        if (Objects.nonNull(org) && Objects.nonNull(orgValue = (DynamicObject)org.getValue())) {
            qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"srm_supplier", (Long)orgValue.getLong("id"));
            return qFilter;
        }
        return qFilter;
    }

    private QFilter bulidSupplerFilter(FilterInfo filter) {
        DynamicObjectCollection supplierValues;
        FilterItemInfo supplier = filter.getFilterItem("supplierfilter");
        QFilter qFilter = null;
        if (Objects.nonNull(supplier) && !CollectionUtils.isEmpty((Collection)(supplierValues = (DynamicObjectCollection)supplier.getValue()))) {
            List ids = supplierValues.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
            qFilter = new QFilter("id", "in", ids);
        }
        return qFilter;
    }

    private QFilter bulidAptitudetypeFilter(FilterInfo filter) {
        String aptitudetypeValue;
        FilterItemInfo aptitudetypefilter = filter.getFilterItem("aptitudetypefilter");
        QFilter qFilter = null;
        if (Objects.nonNull(aptitudetypefilter) && !StringUtils.isEmpty((Object)(aptitudetypeValue = (String)aptitudetypefilter.getValue()))) {
            String[] splits = aptitudetypeValue.split(",");
            List list = CollectionUtils.arrayToList((Object)splits);
            List collect = list.stream().filter(x -> !"".equals(x)).collect(Collectors.toList());
            qFilter = new QFilter("entry_aptitude.aptitudetype", "in", collect);
            return qFilter;
        }
        return qFilter;
    }

    private QFilter bulidNewAptitudetypeFilter(FilterInfo filter) {
        DynamicObjectCollection newaptitudetypeFilters;
        FilterItemInfo newaptitudetypeFilter = filter.getFilterItem("newaptitudetypefilter");
        QFilter qFilter = null;
        if (Objects.nonNull(newaptitudetypeFilter) && !CollectionUtils.isEmpty((Collection)(newaptitudetypeFilters = (DynamicObjectCollection)newaptitudetypeFilter.getValue()))) {
            List ids = newaptitudetypeFilters.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
            qFilter = new QFilter("entry_aptitude.aptitudetype1.id", "in", ids);
        }
        return qFilter;
    }
}

