/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.report.list;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class SrmScoredQueryReportList
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterItemInfo userFilterItem = reportQueryParam.getFilter().getFilterItem("userid");
        FilterItemInfo evadatefromFilterItem = reportQueryParam.getFilter().getFilterItem("evadatefrom");
        FilterItemInfo evadatetoFilterItem = reportQueryParam.getFilter().getFilterItem("evadateto");
        if (Objects.isNull(userFilterItem)) {
            DataSet rows = QueryServiceHelper.queryDataSet((String)"SrmScoredQueryReportList", (String)"srm_score", (String)" ", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)0)}, (String)" ");
            return rows;
        }
        Object id = userFilterItem.getValue();
        Date evadatefrom = null;
        Date evadateto = null;
        if (evadatefromFilterItem != null && evadatetoFilterItem != null) {
            evadatefrom = evadatefromFilterItem.getDate();
            evadateto = evadatetoFilterItem.getDate();
        }
        ArrayList<Date> params = new ArrayList<Date>(10);
        if (evadatefrom != null) {
            params.add(evadatefrom);
        }
        if (evadateto != null) {
            evadateto = this.dateAddOne(evadateto);
            params.add(evadateto);
        }
        String selectFieldSql = this.bulidSelectFieldSql();
        String sql = this.bulidQuerySql(Long.valueOf(id.toString()), selectFieldSql, evadatefrom, evadateto);
        DataSet dataSet = DB.queryDataSet((String)"SrmScoredQueryReportList", (DBRoute)new DBRoute("scm"), (String)sql, (Object[])params.toArray());
        return dataSet;
    }

    protected String bulidSelectFieldSql() {
        StringBuilder selectSqlStr = new StringBuilder(16);
        selectSqlStr.append("A.fbillno as \"billno\",");
        selectSqlStr.append("A.fname as \"name\",");
        selectSqlStr.append("A.fbizbilltypeid as \"bizbilltype\",");
        selectSqlStr.append("A.fperiod as \"period\",");
        selectSqlStr.append("A.fsupplierid as \"supplier\",");
        selectSqlStr.append("A.fbizbillno as \"bizbillno\",");
        selectSqlStr.append("A.fbilldate as \"billdate\",");
        selectSqlStr.append("A.fplandate as \"plandate\",");
        selectSqlStr.append("A.ffinishdate as \"finishdate\",");
        selectSqlStr.append("A.fbizstatus as \"bizstatus\",");
        selectSqlStr.append("A.fevatypeid as \"evatype\",");
        selectSqlStr.append("A.forgid as \"org\",");
        selectSqlStr.append("A.fcategoryid as \"category\",");
        selectSqlStr.append("A.fmaterialid as \"material\",");
        selectSqlStr.append("A.fschemeid as \"scheme\",");
        selectSqlStr.append("A.fgradeid as \"grade\",");
        selectSqlStr.append("B.findexid as \"evaindex\",");
        selectSqlStr.append("B.fveto as \"veto\",");
        selectSqlStr.append("B.fweight as \"indexweight\",");
        selectSqlStr.append("C.faccordance as \"accordance\",");
        selectSqlStr.append("C.fabstain as \"abstain\",");
        selectSqlStr.append("C.fvalue as \"value\",");
        selectSqlStr.append("C.fscore as \"score\",");
        selectSqlStr.append("C.fscorerscore as \"scorerscore\",");
        selectSqlStr.append("C.fveto as \"scorerveto\",");
        selectSqlStr.append("C.fnote as \"note\",");
        selectSqlStr.append("C.fscorerid as \"scorer\",");
        selectSqlStr.append("C.fweight as \"scorerweight\"");
        return selectSqlStr.toString();
    }

    protected String bulidQuerySql(Long userId, String selectStr, Date evadatefrom, Date evadateto) {
        StringBuilder sqlStr = new StringBuilder(16);
        sqlStr.append("SELECT ");
        sqlStr.append(selectStr);
        sqlStr.append(" from T_PUR_SCORE A join t_pur_scoreentry B on A.fid = B.fid  join t_pur_scoredetail C on B.fentryid = C.fentryid ");
        sqlStr.append(" where C.fscorerid = ");
        sqlStr.append(userId);
        sqlStr.append(" and C.fscored = '1' ");
        if (evadatefrom != null) {
            sqlStr.append(" and A.fbilldate >= ? ");
        }
        if (evadateto != null) {
            sqlStr.append(" and A.fbilldate <= ? ");
        }
        sqlStr.append(" ORDER BY A.fbilldate DESC ");
        return sqlStr.toString();
    }

    private Date dateAddOne(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, 1);
        date = calendar.getTime();
        return date;
    }
}

