/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillListUtil;
import kd.scm.srm.common.util.SrmCategoryConfigUtil;

public class SrmAdmitancePanelPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
HyperLinkClickListener,
SearchEnterListener,
EntryGridBindDataListener {
    private static int NODE_MAX_COUNT = 5;
    private static final String REG_STATUS = "regstatus";
    private static final String APTITUDEEXAM_STATUS = "aptitudeexamstatus";
    private static final String SCENEEXAM_STATUS = "sceneexamstatus";
    private static final String SAMPLEEXAM_STATUS = "sampleexamstatus";
    private static final String MATERIALEXAM_STATUS = "materialexamstatus";
    private static final String SUPAPPROVE_STATUS = "supapprovestatus";
    private static final String SUPREG_BILLID = "supregbillid";
    private static final String APTITUDE_BILLID = "aptitudebillid";
    private static final String SCENE_BILLID = "scenebillid";
    private static final String SAMPLE_BILLID = "samplebillid";
    private static final String MATERIALEXAM_BILLID = "materialexambillid";
    private static final String SUPAPPROVE_BILLID = "supapprovebillid";
    private static final String[] numPanelPros = new String[]{"pendingsubmitrfinumpanel", "supregnumpanel", "aptitudenumpanel", "scenenumpanel", "samplenumpanel", "matexamnumpanel", "approvenumpanel"};
    private static final String[] cellPanelPros = new String[]{"supregpanel", "admittypepanel", "scenepanel", "samplepanel", "materialexampanel", "supapprovepanel", "nodestatuspanel1", "nodestatuspanel2", "nodestatuspanel3", "nodestatuspanel4", "nodestatuspanel5"};
    private static final String[] PANEL_PROS = new String[]{"supregpanel", "admittypepanel", "scenepanel", "samplepanel", "materialexampanel", "supapprovepanel", "supregnumpanel", "aptitudenumpanel", "scenenumpanel", "samplenumpanel", "matexamnumpanel", "approvenumpanel", "pendingsubmitrfinumpanel", "nodestatuspanel1", "nodestatuspanel2", "nodestatuspanel3", "nodestatuspanel4", "nodestatuspanel5"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addClickListener((ClickListener)this);
        grid.addItemClickListener((ItemClickListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        grid.addDataBindListener((EntryGridBindDataListener)this);
        for (String panel : PANEL_PROS) {
            Container container = (Container)this.getControl(panel);
            container.addClickListener((ClickListener)this);
        }
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        Vector vector = (Vector)this.getControl("refresh");
        vector.addClickListener((ClickListener)this);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        this.getNodeShowList(enableNewAccessFlow);
    }

    public void click(EventObject evt) {
        int i;
        super.click(evt);
        String key = null;
        Object obj = evt.getSource();
        if (null != obj) {
            Container source;
            if (obj instanceof Container) {
                source = (Container)evt.getSource();
                key = source.getKey();
            } else if (obj instanceof Vector) {
                source = (Vector)evt.getSource();
                key = source.getKey();
            }
        } else {
            return;
        }
        boolean isNumPanel = false;
        boolean isCellPanel = false;
        for (i = 0; i < numPanelPros.length; ++i) {
            if (!numPanelPros[i].equals(key)) continue;
            isNumPanel = true;
            break;
        }
        for (i = 0; i < cellPanelPros.length; ++i) {
            if (!cellPanelPros[i].equals(key)) continue;
            isCellPanel = true;
            break;
        }
        if (isNumPanel) {
            this.numPanelClick(key);
        } else if (isCellPanel) {
            this.rowClick(key);
        } else if ("refresh".equals(key)) {
            IPageCache cache = this.getPageCache();
            this.initData(true, true);
            this.initNumData();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"SrmAdmitancePanelPlugin_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
        }
    }

    private void numPanelClick(String key) {
        IPageCache cache = this.getPageCache();
        cache.remove("isFilterApti");
        if ("supregnumpanel".equals(key)) {
            this.initData(true, false);
        } else if ("aptitudenumpanel".equals(key)) {
            cache.put("isFilterApti", "1");
            this.initData(false, true);
        } else if ("scenenumpanel".equals(key)) {
            this.reBuilderData("srm_sceneexam");
        } else if ("samplenumpanel".equals(key)) {
            this.reBuilderData("srm_sampleexam");
        } else if ("matexamnumpanel".equals(key)) {
            this.reBuilderData("srm_materialexam");
        } else if ("approvenumpanel".equals(key)) {
            this.reBuilderData("srm_supapprove");
        } else if ("pendingsubmitrfinumpanel".equals(key)) {
            HashMap<String, Object> customerParamMap = new HashMap<String, Object>(1);
            customerParamMap.put("fromAdmitancePanelFlag", Boolean.TRUE);
            String searchText = cache.get("searchText");
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                customerParamMap.put("searchText", searchText);
            }
            OpenFormUtil.openListPage((IFormView)this.getView(), (String)"srm_issuerfi", (ShowType)ShowType.MainNewTabPage, customerParamMap, null, null);
        }
    }

    private void reBuilderData(String entityKey) {
        QFilter filter = new QFilter("auditstatus", "=", (Object)"A");
        filter.or(new QFilter("auditstatus", "=", (Object)"B"));
        IPageCache cache = this.getPageCache();
        String searchText = cache.get("searchText");
        if (null != searchText && searchText.trim().length() > 0) {
            filter.and("supplier.name", "like", (Object)("%" + searchText + "%"));
        }
        DynamicObjectCollection sceneObjs = this.getObjs(entityKey, filter);
        ArrayList<Long> aptiIdList = new ArrayList<Long>();
        for (DynamicObject obj : sceneObjs) {
            long apiObj = obj.getLong("aptitudeno");
            if (0L == apiObj) continue;
            aptiIdList.add(apiObj);
        }
        QFilter aptiFilter = new QFilter("id", "in", aptiIdList);
        DynamicObjectCollection aptObjs = this.getAptitudeExamObjs(aptiFilter);
        this.bindData(aptObjs, "srm_aptitudeexam");
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        List<String> nodeShowList = this.getNodeShowList(enableNewAccessFlow);
        if (enableNewAccessFlow) {
            this.matchExamStatusWithNewNodeFlow(aptObjs, nodeShowList);
        } else {
            this.matchExamStatus(aptObjs);
        }
    }

    private void matchExamStatusWithNewNodeFlow(DynamicObjectCollection aptitudeObjects, List<String> nodeShowList) {
        Map<Long, Map<String, Map<String, Date>>> nodeStatusMap = this.getNodeStatusMap(aptitudeObjects);
        this.matchExamStatus(nodeStatusMap, nodeShowList);
        this.getView().updateView();
    }

    protected List<String> getNodeShowList(boolean enableNewAccessFlow) {
        ArrayList<String> nodeShowList = new ArrayList<String>();
        int nodeindex = 0;
        if (enableNewAccessFlow) {
            List<String> objectNumbers = this.getPresetNodeNumber();
            Map<String, String> nodeMap = this.getNodeMap();
            for (Map.Entry<String, String> entry : nodeMap.entrySet()) {
                Label nodelabel;
                if (!objectNumbers.contains(entry.getKey()) && (nodelabel = (Label)this.getControl("nodelabelap" + ++nodeindex)) != null) {
                    nodeShowList.add(entry.getKey());
                    nodelabel.setText(entry.getValue());
                }
                if (nodeindex < NODE_MAX_COUNT) continue;
                break;
            }
        }
        if (nodeindex < NODE_MAX_COUNT) {
            CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < rowCount; ++i) {
                for (int j = nodeindex + 1; j <= NODE_MAX_COUNT; ++j) {
                    cardEntry.setChildVisible(false, i, new String[]{"nodestatuspanel" + j});
                }
            }
            Container nodepanel = (Container)this.getControl("cardentryflexpanelap");
            for (int j = nodeindex + 1; j <= NODE_MAX_COUNT; ++j) {
                nodepanel.deleteControls(new String[]{"nodeflexpanel" + j});
            }
        }
        return nodeShowList;
    }

    private void matchExamStatus(Map<Long, Map<String, Map<String, Date>>> nodeStatusMap, List<String> newNodeList) {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("entryentity");
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject row = model.getEntryRowEntity("entryentity", i);
            Long srcBillId = row.getLong(APTITUDE_BILLID);
            Map<String, Map<String, Date>> nodeMap = nodeStatusMap.get(srcBillId);
            if (nodeMap == null || nodeMap.isEmpty()) continue;
            this.setNodeStatus("srm_sceneexam", nodeMap, i, SCENEEXAM_STATUS, "sceneexamdate", null);
            this.setNodeStatus("srm_sampleexam", nodeMap, i, SAMPLEEXAM_STATUS, "sampleexamdate", null);
            this.setNodeStatus("srm_materialexam", nodeMap, i, MATERIALEXAM_STATUS, "materialexamdate", null);
            int index = 0;
            if (!newNodeList.isEmpty()) {
                for (String objectnumber : newNodeList) {
                    this.setNodeStatus(objectnumber, nodeMap, i, "nodestatus" + ++index, "nodebilldate" + index, "nodeentitykey" + index);
                }
            }
            this.setNodeStatus("srm_supapprove", nodeMap, i, SUPAPPROVE_STATUS, "approveexamdate", null);
        }
    }

    private void setNodeStatus(String objectnumber, Map<String, Map<String, Date>> nodeMap, int rowindex, String statusKey, String dateKey, String nodeentitykey) {
        IDataModel model = this.getModel();
        Map<String, Date> node = nodeMap.get(objectnumber);
        if (node != null && !node.isEmpty()) {
            for (Map.Entry<String, Date> entry : node.entrySet()) {
                String status = entry.getKey();
                Date billdate = entry.getValue();
                if (!"1".equals(status)) {
                    status = "2";
                }
                model.setValue(statusKey, (Object)status, rowindex);
                if (billdate != null) {
                    model.setValue(dateKey, (Object)DateUtil.date2str((Date)billdate, (String)"yyyy-MM-dd"), rowindex);
                }
                if (!StringUtils.isNotBlank((CharSequence)nodeentitykey)) continue;
                model.setValue(nodeentitykey, (Object)objectnumber, rowindex);
            }
        }
    }

    private Map<Long, Map<String, Map<String, Date>>> getNodeStatusMap(DynamicObjectCollection aptitudeObjects) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject aptitude : aptitudeObjects) {
            String auditstatus = aptitude.getString("auditstatus");
            if (!"C".equals(auditstatus)) continue;
            idSet.add(aptitude.getLong("id"));
        }
        DynamicObjectCollection srm_aptitudeexams = QueryServiceHelper.query((String)"srm_aptitudeexam", (String)"id,entry_node.nodestatus,entry_node.nodebilldate,entry_node.accessnode,entry_node.accessnode.bizobject", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
        HashMap<Long, Map<String, Map<String, Date>>> nodeStatusMap = new HashMap<Long, Map<String, Map<String, Date>>>(16);
        for (DynamicObject srm_aptitudeexam : srm_aptitudeexams) {
            HashMap<String, Date> stringDateMap;
            long billId = srm_aptitudeexam.getLong("id");
            String nodestatus = srm_aptitudeexam.getString("entry_node.nodestatus");
            Date nodebilldate = srm_aptitudeexam.getDate("entry_node.nodebilldate");
            String bizobject = srm_aptitudeexam.getString("entry_node.accessnode.bizobject");
            HashMap<String, HashMap<String, Date>> stringMapMap = (HashMap<String, HashMap<String, Date>>)nodeStatusMap.get(billId);
            if (stringMapMap == null) {
                stringMapMap = new HashMap<String, HashMap<String, Date>>(16);
            }
            if ((stringDateMap = (HashMap<String, Date>)stringMapMap.get(bizobject)) == null) {
                stringDateMap = new HashMap<String, Date>(16);
            }
            stringDateMap.put(nodestatus, nodebilldate);
            stringMapMap.put(bizobject, stringDateMap);
            nodeStatusMap.put(billId, stringMapMap);
        }
        return nodeStatusMap;
    }

    private void rowClick(String key) {
        IDataModel model = this.getModel();
        String pro = null;
        String idPro = null;
        String entityKey = null;
        if ("samplepanel".equals(key) || "materialexampanel".equals(key) || "supapprovepanel".equals(key)) {
            int rowIndex = model.getEntryCurrentRowIndex("entryentity");
            DynamicObject rowObj = model.getEntryRowEntity("entryentity", rowIndex);
            String billId = rowObj.getString(APTITUDE_BILLID);
            if ("samplepanel".equals(key)) {
                this.openBill(billId, "srm_sampleexam", SAMPLEEXAM_STATUS);
            } else if ("materialexampanel".equals(key)) {
                this.openBill(billId, "srm_materialexam", MATERIALEXAM_STATUS);
            } else {
                this.openBill(billId, "srm_supapprove", SUPAPPROVE_STATUS);
            }
        } else {
            boolean newNodeFlag = false;
            String entityKeyPro = null;
            if ("supregpanel".equals(key)) {
                pro = REG_STATUS;
                idPro = SUPREG_BILLID;
                entityKey = "srm_supplierreg";
            } else if ("admittypepanel".equals(key)) {
                pro = APTITUDEEXAM_STATUS;
                idPro = APTITUDE_BILLID;
                entityKey = "srm_aptitudeexam";
            } else if ("scenepanel".equals(key)) {
                pro = SCENEEXAM_STATUS;
                idPro = SCENE_BILLID;
                entityKey = "srm_sceneexam";
            } else if ("nodestatuspanel1".equals(key)) {
                pro = "nodestatus1";
                idPro = "nodebillid1";
                entityKeyPro = "nodeentitykey1";
                newNodeFlag = true;
            } else if ("nodestatuspanel2".equals(key)) {
                pro = "nodestatus2";
                idPro = "nodebillid2";
                entityKeyPro = "nodeentitykey2";
                newNodeFlag = true;
            } else if ("nodestatuspanel3".equals(key)) {
                pro = "nodestatus3";
                idPro = "nodebillid3";
                entityKeyPro = "nodeentitykey3";
                newNodeFlag = true;
            } else if ("nodestatuspanel4".equals(key)) {
                pro = "nodestatus4";
                idPro = "nodebillid4";
                entityKeyPro = "nodeentitykey4";
                newNodeFlag = true;
            } else if ("nodestatuspanel5".equals(key)) {
                pro = "nodestatus5";
                idPro = "nodebillid5";
                entityKeyPro = "nodeentitykey5";
                newNodeFlag = true;
            } else {
                return;
            }
            int rowIndex = model.getEntryCurrentRowIndex("entryentity");
            DynamicObject rowObj = model.getEntryRowEntity("entryentity", rowIndex);
            if (StringUtils.isNotBlank(entityKeyPro) && StringUtils.isBlank((CharSequence)entityKey)) {
                entityKey = rowObj.getString(entityKeyPro);
            }
            if (newNodeFlag || "srm_sceneexam".equals(entityKey)) {
                String aptitudeId = rowObj.getString(APTITUDE_BILLID);
                this.openBill(aptitudeId, entityKey, pro);
            } else {
                String val = rowObj.getString(pro);
                if ("2".equals(val) || "4".equals(val)) {
                    String billId = rowObj.getString(idPro);
                    BillShowParameter param = BillFormUtil.assembleShowBillFormParam((String)entityKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)(null == billId ? 0L : Long.parseLong(billId)), null, (CloseCallBack)new CloseCallBack());
                    this.getView().showForm((FormShowParameter)param);
                } else if ("1".equals(val)) {
                    Long aptitudebillid;
                    DynamicObject aptobj;
                    String billId = rowObj.getString(idPro);
                    if (billId != null && "".equals(billId.trim()) && (aptobj = QueryServiceHelper.queryOne((String)"srm_aptitudeexam", (String)"id,supplier.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(aptitudebillid = Long.valueOf(rowObj.getLong(APTITUDE_BILLID))))})) != null) {
                        String supnum = aptobj.getString("supplier.id");
                        BillShowParameter param = BillFormUtil.assembleShowBillFormParam((String)entityKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)(null == supnum ? 0L : Long.parseLong(supnum)), null, (CloseCallBack)new CloseCallBack());
                        this.getView().showForm((FormShowParameter)param);
                    }
                    if (billId != null && !"".equals(billId.trim())) {
                        BillShowParameter param = BillFormUtil.assembleShowBillFormParam((String)entityKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)Long.parseLong(billId), null, (CloseCallBack)new CloseCallBack());
                        this.getView().showForm((FormShowParameter)param);
                    }
                }
            }
        }
    }

    private void openBill(String billId, String pageKey, String clickPos) {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("entryentity");
        DynamicObject rowObj = model.getEntryRowEntity("entryentity", rowIndex);
        String val = rowObj.getString(clickPos);
        DynamicObjectCollection dyn = null;
        if (val.equals("1")) {
            dyn = SrmBillListUtil.getAllRelatedBill((String)pageKey, (String)billId, (String)"id");
        } else if (val.equals("2") || val.equals("4")) {
            dyn = SrmBillListUtil.getAllStatusRelatedBill((String)pageKey, (String)billId, (String)"id");
        }
        if (dyn != null) {
            if (dyn.size() == 1) {
                Long id = ((DynamicObject)dyn.get(0)).getLong("id");
                BillShowParameter param = BillFormUtil.assembleShowBillFormParam((String)pageKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)id, null, (CloseCallBack)new CloseCallBack());
                this.getView().showForm((FormShowParameter)param);
            } else {
                ArrayList<Long> idList = new ArrayList<Long>(16);
                for (DynamicObject billData : dyn) {
                    idList.add(Long.parseLong(billData.getString("id")));
                }
                QFilter qf = new QFilter("id", "in", idList);
                OpenFormUtil.openListPage((IFormView)this.getView(), (String)pageKey, (ShowType)ShowType.MainNewTabPage, null, (QFilter)qf, null);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyclick) {
        String name = hyclick.getFieldName();
        if ("supplier".equals(name)) {
            IDataModel model = this.getModel();
            int index = hyclick.getRowIndex();
            DynamicObject rowObj = model.getEntryRowEntity("entryentity", index);
            String val = rowObj.getString(name);
            String aptBillId = rowObj.getString(APTITUDE_BILLID);
            String aptBillno = rowObj.getString("srcbillno");
            HashMap<String, String> param = new HashMap<String, String>(4);
            param.put("name", val);
            param.put("billno", aptBillno);
            param.put("aptbillid", aptBillId);
            FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"srm_userrecore", param, (CloseCallBack)new CloseCallBack(), (ShowType)ShowType.MainNewTabPage);
            this.getView().showForm(formParam);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initData(true, true);
        this.initNumData();
    }

    private void initData(boolean isSupReg, boolean isAptitude) {
        DynamicObjectCollection objs = null;
        IPageCache cache = this.getPageCache();
        String entityName = "";
        if (isSupReg) {
            QFilter filter = new QFilter("auditstatus", "=", (Object)"B");
            String searchText = cache.get("searchText");
            if (null != searchText && searchText.trim().length() > 0) {
                filter.and("name", "like", (Object)("%" + searchText + "%"));
            }
            objs = this.getSupRegObjs(filter);
            entityName = "srm_supplierreg";
        }
        if (isAptitude) {
            String isFilterApti = cache.get("isFilterApti");
            QFilter filter = null;
            if ("1".equals(isFilterApti)) {
                filter = new QFilter("auditstatus", "=", (Object)"B");
                filter.or(new QFilter("auditstatus", "=", (Object)"A"));
            } else {
                filter = new QFilter("auditstatus", "=", (Object)"B");
                filter.or(new QFilter("auditstatus", "=", (Object)"C").and(new QFilter("examresult", "!=", (Object)"1")));
                filter.or(new QFilter("auditstatus", "=", (Object)"A"));
                filter.or(new QFilter("auditstatus", "=", (Object)"D"));
            }
            String searchText = cache.get("searchText");
            if (null != searchText && searchText.trim().length() > 0) {
                filter.and("supplier.name", "like", (Object)("%" + searchText + "%"));
            }
            objs = this.getAptitudeExamObjs(filter);
            entityName = "srm_aptitudeexam";
        }
        this.bindData(objs, entityName);
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        List<String> nodeShowList = this.getNodeShowList(enableNewAccessFlow);
        if (isAptitude) {
            if (enableNewAccessFlow) {
                this.matchExamStatusWithNewNodeFlow(objs, nodeShowList);
            } else {
                this.matchExamStatus(objs);
            }
        }
    }

    private List<String> getPresetNodeNumber() {
        ArrayList<String> objectNumbers = new ArrayList<String>(5);
        objectNumbers.add("srm_aptitudeexam");
        objectNumbers.add("srm_sceneexam");
        objectNumbers.add("srm_sampleexam");
        objectNumbers.add("srm_materialexam");
        objectNumbers.add("srm_supapprove");
        return objectNumbers;
    }

    private void initNumData() {
        IDataModel model = this.getModel();
        IPageCache cache = this.getPageCache();
        String searchText = cache.get("searchText");
        final QFilter aptFilter = new QFilter("auditstatus", "=", (Object)"A");
        aptFilter.or(new QFilter("auditstatus", "=", (Object)"B"));
        final QFilter pendingSubmitRFIFilter = new QFilter("billstatus", "=", (Object)"C").and(new QFilter("haveconfirm", "=", (Object)"N").or("haveconfirm", "=", (Object)" "));
        if (null != searchText && searchText.trim().length() > 0) {
            aptFilter.and("supplier.name", "like", (Object)("%" + searchText + "%"));
            pendingSubmitRFIFilter.and("suppliername", "like", (Object)("%" + searchText + "%"));
        }
        QFilter[] qptFilters = this.permOrgFilter(new ArrayList<QFilter>(){
            {
                this.add(aptFilter);
            }
        }, "", "srm_aptitudeexam");
        int aptCount = 0;
        if (null != qptFilters) {
            aptCount = ORMUtil.getCount((QFilter[])qptFilters, (String)"srm_aptitudeexam");
        }
        final QFilter supRegFilter = new QFilter("auditstatus", "=", (Object)"B");
        if (null != searchText && searchText.trim().length() > 0) {
            supRegFilter.and("name", "like", (Object)("%" + searchText + "%"));
        }
        QFilter[] supRegFilters = this.permOrgFilter(new ArrayList<QFilter>(){
            {
                this.add(supRegFilter);
            }
        }, "", "srm_supplierreg");
        int supRegCount = 0;
        if (null != supRegFilters) {
            supRegCount = ORMUtil.getCount((QFilter[])supRegFilters, (String)"srm_supplierreg");
        }
        QFilter[] sceneRegFilters = this.permOrgFilter(new ArrayList<QFilter>(){
            {
                this.add(aptFilter);
            }
        }, "", "srm_sceneexam");
        int sceneRegCount = 0;
        if (null != sceneRegFilters) {
            sceneRegCount = ORMUtil.getCount((QFilter[])sceneRegFilters, (String)"srm_sceneexam");
        }
        QFilter[] sampleFilters = this.permOrgFilter(new ArrayList<QFilter>(){
            {
                this.add(aptFilter);
            }
        }, "", "srm_sampleexam");
        int sampleCount = 0;
        if (null != sampleFilters) {
            sampleCount = ORMUtil.getCount((QFilter[])sampleFilters, (String)"srm_sampleexam");
        }
        QFilter[] matExamFilters = this.permOrgFilter(new ArrayList<QFilter>(){
            {
                this.add(aptFilter);
            }
        }, "", "srm_materialexam");
        int matExamCount = 0;
        if (null != matExamFilters) {
            matExamCount = ORMUtil.getCount((QFilter[])matExamFilters, (String)"srm_materialexam");
        }
        QFilter[] approveFilters = this.permOrgFilter(new ArrayList<QFilter>(){
            {
                this.add(aptFilter);
            }
        }, "", "srm_supapprove");
        int approveCount = 0;
        if (null != approveFilters) {
            approveCount = ORMUtil.getCount((QFilter[])approveFilters, (String)"srm_supapprove");
        }
        QFilter[] pendingSubmitRFIFilters = this.permOrgFilter(new ArrayList<QFilter>(){
            {
                this.add(pendingSubmitRFIFilter);
            }
        }, "", "srm_issuerfi");
        int pendingSubmitRFICount = 0;
        if (null != pendingSubmitRFIFilters) {
            pendingSubmitRFICount = ORMUtil.getCount((QFilter[])pendingSubmitRFIFilters, (String)"srm_issuerfi");
        }
        model.setValue("pendingsubmitrfinum", (Object)pendingSubmitRFICount);
        model.setValue("supregnum", (Object)supRegCount);
        model.setValue("aptitudeexamnum", (Object)aptCount);
        model.setValue("scenenum", (Object)sceneRegCount);
        model.setValue("samplenum", (Object)sampleCount);
        model.setValue("matexamnum", (Object)matExamCount);
        model.setValue("approvenum", (Object)approveCount);
    }

    private Map<String, String> getNodeMap() {
        QFilter qFilter = new QFilter("status", "=", (Object)"1");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"srm_accessnode", (String)"id,name,bizobject", (QFilter[])qFilter.toArray(), (String)"id");
        LinkedHashMap<String, String> nodeMap = new LinkedHashMap<String, String>(16);
        for (DynamicObject object : query) {
            String objectnumber = object.getString("bizobject");
            String name = object.getString("name");
            nodeMap.put(objectnumber, name);
        }
        return nodeMap;
    }

    private DynamicObjectCollection getAptitudeExamObjs(final QFilter filter) {
        String selectProperties = "id,billno,billdate,org,auditstatus,supplier,bizpartner,entertype.name";
        QFilter[] filters = this.permOrgFilter(new ArrayList<QFilter>(1){
            {
                super(x0);
                this.add(filter);
            }
        }, "", "srm_aptitudeexam");
        return QueryServiceHelper.query((String)"srm_aptitudeexam", (String)selectProperties, (QFilter[])filters);
    }

    private DynamicObjectCollection getSupRegObjs(final QFilter filter) {
        String selectProperties = "id,name,number,linkman,phone,createtime,org,auditstatus,supplier,bizpartner";
        QFilter[] qFilters = this.permOrgFilter(new ArrayList<QFilter>(1){
            {
                super(x0);
                this.add(filter);
            }
        }, "", "srm_supplierreg");
        return QueryServiceHelper.query((String)"srm_supplierreg", (String)selectProperties, (QFilter[])qFilters);
    }

    private DynamicObjectCollection getObjs(String entityKey, QFilter filter) {
        String selectProperties = "id,billno,billdate,org,auditstatus,supplier,aptitudeno";
        return QueryServiceHelper.query((String)entityKey, (String)selectProperties, (QFilter[])new QFilter[]{filter});
    }

    private QFilter getQFilter(Set<Long> aptExamBillNoList) {
        return new QFilter("aptitudeno", "in", aptExamBillNoList);
    }

    private void bindData(DynamicObjectCollection objs, String entityName) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        this.getModel().beginInit();
        model.deleteEntryData("entryentity");
        int i = 0;
        for (DynamicObject obj : objs) {
            String pictureField;
            DynamicObject dynamicObject;
            long bizPartner = obj.getLong("bizpartner");
            if (0L != bizPartner && (dynamicObject = QueryServiceHelper.queryOne((String)"bd_bizpartner", (String)"picturefield", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizPartner)})) != null && null != (pictureField = dynamicObject.getString("picturefield")) && pictureField.trim().length() > 0) {
                vs.set("supimg", (Object)pictureField, i);
            }
            if ("srm_aptitudeexam".equals(entityName)) {
                long supplierId = obj.getLong("supplier");
                DynamicObject supplier = QueryServiceHelper.queryOne((String)"srm_supplier", (String)"name,createtime,linkman,phone,auditdate,org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierId)});
                if (null != supplier) {
                    long org;
                    vs.set("supplier", (Object)supplier.getString("name"), i);
                    Date createTime = supplier.getDate("createtime");
                    if (null != createTime) {
                        vs.set("createtime", (Object)DateUtil.date2str((Date)createTime, (String)"yyyy-MM-dd"), i);
                    }
                    vs.set("linkman", (Object)supplier.getString("linkman"), i);
                    vs.set("phone", supplier.get("phone"), i);
                    Date auditDate = supplier.getDate("auditdate");
                    if (null != createTime) {
                        vs.set("auditdate", (Object)DateUtil.date2str((Date)auditDate, (String)"yyyy-MM-dd"), i);
                    }
                    if (0L != (org = supplier.getLong("org"))) {
                        vs.set("org", (Object)org, i);
                    }
                }
                String category = this.getCategory(obj);
                vs.set("category", (Object)category, i);
                String entryType = obj.getString("entertype.name");
                if (StringUtils.isNotBlank((CharSequence)entryType)) {
                    vs.set("entertype", (Object)entryType, i);
                }
                vs.set(REG_STATUS, (Object)"1", i);
                String auditStatus = obj.getString("auditstatus");
                if ("C".equals(auditStatus)) {
                    vs.set(APTITUDEEXAM_STATUS, (Object)"1", i);
                } else if ("D".equals(auditStatus)) {
                    vs.set(APTITUDEEXAM_STATUS, (Object)"4", i);
                } else {
                    vs.set(APTITUDEEXAM_STATUS, (Object)"2", i);
                }
                Date billDate = obj.getDate("billdate");
                if (null != billDate) {
                    vs.set("admitdate", (Object)DateUtil.date2str((Date)billDate, (String)"yyyy-MM-dd"), i);
                }
                vs.set(APTITUDE_BILLID, (Object)obj.getLong("id"), i);
                vs.set("srcbillno", (Object)obj.getString("billno"), i);
            } else if ("srm_supplierreg".equals(entityName)) {
                Date createTime;
                vs.set("supplier", (Object)obj.getString("name"), i);
                long org = obj.getLong("org");
                if (0L != org) {
                    vs.set("org", (Object)org, i);
                }
                if (null != (createTime = obj.getDate("createtime"))) {
                    vs.set("createtime", (Object)DateUtil.date2str((Date)createTime, (String)"yyyy-MM-dd"), i);
                }
                vs.set("phone", obj.get("phone"), i);
                vs.set("linkman", (Object)obj.getString("linkman"), i);
                String auditStatus = obj.getString("auditstatus");
                if ("B".equals(auditStatus)) {
                    vs.set(REG_STATUS, (Object)"2", i);
                    vs.set(APTITUDEEXAM_STATUS, (Object)"3", i);
                } else if ("D".equals(auditStatus)) {
                    vs.set(APTITUDEEXAM_STATUS, (Object)"4", i);
                }
                vs.set(SUPREG_BILLID, (Object)obj.getLong("id"), i);
            }
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private String getCategory(DynamicObject obj) {
        long id = obj.getLong("id");
        DynamicObjectCollection srm_aptitudeexams = QueryServiceHelper.query((String)"srm_aptitudeexam", (String)"entryentity.category,entryentity.category.name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        StringBuilder categorySb = new StringBuilder();
        for (DynamicObject srm_aptitudeexam : srm_aptitudeexams) {
            String category = srm_aptitudeexam.getString("entryentity.category.name");
            categorySb.append(category).append(';');
        }
        return categorySb.toString();
    }

    private void matchExamStatus(DynamicObjectCollection aptitudeExamObjs) {
        HashSet<Long> aptExamBillIdSet = new HashSet<Long>(16);
        for (DynamicObject row : aptitudeExamObjs) {
            aptExamBillIdSet.add(row.getLong("id"));
        }
        QFilter filter = this.getQFilter(aptExamBillIdSet);
        DynamicObjectCollection sceneObjs = this.getObjs("srm_sceneexam", filter);
        Map<Long, DynamicObject> sceneObjsMap = this.dynamicObject2Map(sceneObjs, "aptitudeno");
        DynamicObjectCollection sampleObjs = this.getObjs("srm_sampleexam", filter);
        Map<Long, DynamicObject> sampleObjsMap = this.dynamicObject2Map(sampleObjs, "aptitudeno");
        DynamicObjectCollection materialObjs = this.getObjs("srm_materialexam", filter);
        Map<Long, DynamicObject> materialObjsMap = this.dynamicObject2Map(materialObjs, "aptitudeno");
        DynamicObjectCollection approveObjs = this.getObjs("srm_supapprove", filter);
        Map<Long, DynamicObject> approveObjsMap = this.dynamicObject2Map(approveObjs, "aptitudeno");
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("entryentity");
        DynamicObjectCollection entry = model.getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        List<Long> aptitudebillids = entry.stream().map(x -> x.getLong(APTITUDE_BILLID)).collect(Collectors.toList());
        DynamicObjectCollection aptitudeexamsArrays = QueryServiceHelper.query((String)"srm_aptitudeexam", (String)"id,hasscene,hassample,hasmaterial,hasapprove,entryentity,entryentity.category", (QFilter[])new QFilter[]{new QFilter("id", "in", aptitudebillids)});
        DynamicObjectCollection existCurSceneBill = this.querybillByAptitudebillids("srm_sceneexam", aptitudebillids);
        DynamicObjectCollection existCurSampleexamBills = this.querybillByAptitudebillids("srm_sampleexam", aptitudebillids);
        DynamicObjectCollection existCurMaterialexamBills = this.querybillByAptitudebillids("srm_materialexam", aptitudebillids);
        DynamicObjectCollection existCurSupapproveBills = this.querybillByAptitudebillids("srm_supapprove", aptitudebillids);
        boolean iSrmCategoryConfig = SrmCategoryConfigUtil.isCategoryConfig();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject sceneObj;
            Long srcBillId;
            DynamicObject row = model.getEntryRowEntity("entryentity", i);
            if (iSrmCategoryConfig) {
                srcBillId = row.getLong(APTITUDE_BILLID);
                sceneObj = sceneObjsMap.get(srcBillId);
                this.setStatus("srm_sceneexam", srcBillId, "hasscene", SCENEEXAM_STATUS, "sceneexamdate", i, existCurSceneBill, aptitudeexamsArrays);
                model.setValue(SCENE_BILLID, (Object)(null == sceneObj ? 0L : sceneObj.getLong("id")), i);
                if (srcBillId == 0L) continue;
                boolean hasCategory = false;
                for (DynamicObject aptitudeexamsArray : aptitudeexamsArrays) {
                    if (!srcBillId.equals(aptitudeexamsArray.getLong("id")) || !StringUtils.isNotBlank((CharSequence)aptitudeexamsArray.getString("entryentity.category")) || "0".equals(aptitudeexamsArray.getString("entryentity.category"))) continue;
                    hasCategory = true;
                    break;
                }
                DynamicObject sampleObj = sampleObjsMap.get(srcBillId);
                if (!hasCategory) {
                    this.setStatus(sampleObj, SAMPLEEXAM_STATUS, "sampleexamdate", i);
                } else {
                    this.setStatus("srm_sampleexam", srcBillId, "hassample", SAMPLEEXAM_STATUS, "sampleexamdate", i, existCurSampleexamBills, aptitudeexamsArrays);
                }
                model.setValue(SAMPLE_BILLID, (Object)(null == sampleObj ? 0L : sampleObj.getLong("id")), i);
                DynamicObject materialObj = materialObjsMap.get(srcBillId);
                if (!hasCategory) {
                    this.setStatus(materialObj, MATERIALEXAM_STATUS, "materialexamdate", i);
                } else {
                    this.setStatus("srm_materialexam", srcBillId, "hasmaterial", MATERIALEXAM_STATUS, "materialexamdate", i, existCurMaterialexamBills, aptitudeexamsArrays);
                }
                model.setValue(MATERIALEXAM_BILLID, (Object)(null == materialObj ? 0L : materialObj.getLong("id")), i);
                DynamicObject approveObj = approveObjsMap.get(srcBillId);
                if (!hasCategory) {
                    this.setStatus(approveObj, SUPAPPROVE_STATUS, "approveexamdate", i);
                } else {
                    this.setStatus("srm_supapprove", srcBillId, "hasapprove", SUPAPPROVE_STATUS, "approveexamdate", i, existCurSupapproveBills, aptitudeexamsArrays);
                }
                model.setValue(SUPAPPROVE_BILLID, (Object)(null == approveObj ? 0L : approveObj.getLong("id")), i);
                continue;
            }
            srcBillId = row.getLong(APTITUDE_BILLID);
            sceneObj = sceneObjsMap.get(srcBillId);
            this.setStatus("srm_sceneexam", srcBillId, "hasscene", SCENEEXAM_STATUS, "sceneexamdate", i, existCurSceneBill, aptitudeexamsArrays);
            model.setValue(SCENE_BILLID, (Object)(null == sceneObj ? 0L : sceneObj.getLong("id")), i);
            DynamicObject sampleObj = sampleObjsMap.get(srcBillId);
            this.setStatus("srm_sampleexam", srcBillId, "hassample", SAMPLEEXAM_STATUS, "sampleexamdate", i, existCurSampleexamBills, aptitudeexamsArrays);
            model.setValue(SAMPLE_BILLID, (Object)(null == sampleObj ? 0L : sampleObj.getLong("id")), i);
            DynamicObject materialObj = materialObjsMap.get(srcBillId);
            this.setStatus("srm_materialexam", srcBillId, "hasmaterial", MATERIALEXAM_STATUS, "materialexamdate", i, existCurMaterialexamBills, aptitudeexamsArrays);
            model.setValue(MATERIALEXAM_BILLID, (Object)(null == materialObj ? 0L : materialObj.getLong("id")), i);
            DynamicObject approveObj = approveObjsMap.get(srcBillId);
            this.setStatus(approveObj, SUPAPPROVE_STATUS, "approveexamdate", i);
            model.setValue(SUPAPPROVE_BILLID, (Object)(null == approveObj ? 0L : approveObj.getLong("id")), i);
        }
    }

    public DynamicObjectCollection querybillByAptitudebillids(String billType, List<Long> aptitudebillids) {
        DynamicObjectCollection existCurBill = QueryServiceHelper.query((String)billType, (String)"id,billdate,aptitudeno", (QFilter[])new QFilter[]{new QFilter("aptitudeno", "in", aptitudebillids)}, (String)"billdate");
        return existCurBill;
    }

    private void setStatus(DynamicObject obj, String pro, String datePro, int i) {
        IDataModel model = this.getModel();
        if (null != obj) {
            String auditStatus = obj.getString("auditstatus");
            if ("C".equals(auditStatus)) {
                model.setValue(pro, (Object)"1", i);
            } else if ("D".equals(auditStatus)) {
                model.setValue(pro, (Object)"4", i);
            } else {
                model.setValue(pro, (Object)"2", i);
            }
            Date billDate = obj.getDate("billdate");
            if (null != billDate) {
                model.setValue(datePro, (Object)DateUtil.date2str((Date)billDate, (String)"yyyy-MM-dd"), i);
            }
        } else {
            model.setValue(pro, (Object)"3", i);
        }
    }

    private void setStatus(String billType, Long aptitudeId, String isCompletedFileds, String pro, String datePro, int i, DynamicObjectCollection bills, DynamicObjectCollection aptitudeexams) {
        DynamicObject lastDyo;
        List completedFileds;
        IDataModel model = this.getModel();
        model.setValue(pro, (Object)"3", i);
        List existCurStepBill = bills.stream().filter(x -> aptitudeId.longValue() == x.getLong("aptitudeno") && x.getLong("aptitudeno") != 0L).collect(Collectors.toList());
        if (existCurStepBill != null && !existCurStepBill.isEmpty()) {
            model.setValue(pro, (Object)"2", i);
        }
        if ((completedFileds = aptitudeexams.stream().filter(x -> aptitudeId.longValue() == x.getLong("id") && x.getBoolean(isCompletedFileds)).collect(Collectors.toList())).size() > 0) {
            model.setValue(pro, (Object)"1", i);
        }
        if (existCurStepBill != null && !existCurStepBill.isEmpty() && (lastDyo = (DynamicObject)existCurStepBill.get(existCurStepBill.size() - 1)) != null) {
            Date lastTime = lastDyo.getDate("billdate");
            model.setValue(datePro, (Object)DateUtil.date2str((Date)lastTime, (String)"yyyy-MM-dd"), i);
        }
    }

    private Map<Long, DynamicObject> dynamicObject2Map(DynamicObjectCollection objs, String pro) {
        HashMap<Long, DynamicObject> objsMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject obj : objs) {
            Object val = obj.get(pro);
            objsMap.put(Long.parseLong(val.toString()), obj);
        }
        return objsMap;
    }

    private Map<String, List<DynamicObject>> getAllAuditDynamicObject2Map(DynamicObject[] objs, String pro) {
        HashMap<String, List<DynamicObject>> objsMap = new HashMap<String, List<DynamicObject>>(32);
        for (DynamicObject obj : objs) {
            Object val = obj.get(pro);
            if (null == val || !(val instanceof DynamicObject)) continue;
            String key = ((DynamicObject)val).getPkValue().toString();
            List tmpList = (List)objsMap.get(key);
            tmpList.add(obj);
            objsMap.put(key, tmpList);
        }
        return objsMap;
    }

    public void search(SearchEnterEvent serachEvt) {
        String text = serachEvt.getText();
        IPageCache cache = this.getPageCache();
        if (null != text && text.trim().length() > 0) {
            cache.put("searchText", text);
        } else {
            cache.remove("searchText");
        }
        this.initData(true, true);
        this.initNumData();
    }

    public QFilter[] permOrgFilter(ArrayList<QFilter> qFilters, String orgNameFilterStr, String entitykey) {
        QFilter qFilter = null;
        if (null == qFilters || StringUtils.isEmpty((CharSequence)entitykey)) {
            return null;
        }
        String orgFilterStr = "org.id";
        if (StringUtils.isNotBlank((CharSequence)orgNameFilterStr)) {
            orgFilterStr = orgNameFilterStr;
        }
        Map resultMap = OrgUtil.getCurrentUserAllViewPermOrgs((String)entitykey);
        List permOrgIds = new ArrayList(1);
        if (null != resultMap && resultMap.containsKey("hasAllOrgPerm")) {
            Boolean hasAllOrgPerm = (Boolean)resultMap.get("hasAllOrgPerm");
            if (null != hasAllOrgPerm && !hasAllOrgPerm.booleanValue()) {
                permOrgIds = (List)resultMap.get("hasPermOrgIds");
                qFilter = new QFilter(orgFilterStr, "in", permOrgIds);
                qFilters.add(qFilter);
                return qFilters.toArray(new QFilter[qFilters.size()]);
            }
            if (null != hasAllOrgPerm && hasAllOrgPerm.booleanValue()) {
                return qFilters.toArray(new QFilter[qFilters.size()]);
            }
        }
        return null;
    }
}

