/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.SrmCategoryEnum;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.sdk.sdkutil.GroupStandardUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.SrmSupplierGroup;
import kd.scm.srm.common.SrmBillListUtil;
import kd.scm.srm.common.SrmCategoryLibUtil;
import kd.scm.srm.common.SrmCommUtil;
import kd.scm.srm.common.constant.SrmConstant;
import kd.scm.srm.common.util.AccessNodeUtil;
import kd.scm.srm.common.util.SrmCategoryConfigUtil;

public class SrmAptitudeExamEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String SUPPLIER = "supplier";
    private static final String TAXRATEID = "taxrateid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplier = (BasedataEdit)this.getControl(SUPPLIER);
        BasedataEdit supplierGroup = (BasedataEdit)this.getControl("group");
        BasedataEdit category = (BasedataEdit)this.getControl("category");
        BasedataEdit enterType = (BasedataEdit)this.getControl("entertype");
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        BasedataEdit accessnode = (BasedataEdit)this.getControl("accessnode");
        if (supplier != null) {
            supplier.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if (supplierGroup != null) {
            supplierGroup.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if (category != null) {
            category.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if (enterType != null) {
            enterType.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if (material != null) {
            material.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if (accessnode != null) {
            accessnode.addBeforeF7SelectListener(this::beforeF7Select);
        }
        EntryGrid purSumGrid = (EntryGrid)this.getView().getControl(SrmConstant.ENTRY_NODE);
        purSumGrid.addHyperClickListener((HyperLinkClickListener)this);
        SrmCommUtil.addValidatePreValueBeforeF7Listener((AbstractFormPlugin)this, (String)SUPPLIER, (String)"org");
    }

    public void afterCreateNewData(EventObject eventobject) {
        super.afterCreateNewData(eventobject);
        Map paraMap = SrmCommonUtil.getSrmParameter();
        this.getModel().setValue("ispurorg", paraMap.get("ispurorg"));
        this.getModel().setValue("iscategory", paraMap.get("iscategory"));
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        EntryGrid grid;
        String value;
        String fieldName = args.getFieldName();
        if ("nodestatus".equals(fieldName) && "1".equals(value = (String)(grid = (EntryGrid)args.getSource()).getModel().getValue(fieldName))) {
            DynamicObject accesscode = (DynamicObject)grid.getModel().getValue("accessnode");
            String number = accesscode.getString("bizobject_id");
            Object billId = this.getModel().getDataEntity().getPkValue();
            this.openBill(String.valueOf(billId), number);
        }
    }

    private void openBill(String billId, String pageKey) {
        DynamicObjectCollection dyn = SrmBillListUtil.getAllRelatedBill((String)pageKey, (String)billId, (String)"id");
        if (dyn != null) {
            if (dyn.size() == 1) {
                Long id = ((DynamicObject)dyn.get(0)).getLong("id");
                OpenFormUtil.openBillPage((IFormView)this.getView(), (String)pageKey, (Object)id, (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
            } else {
                ArrayList<Long> idList = new ArrayList<Long>(16);
                for (DynamicObject billData : dyn) {
                    idList.add(Long.parseLong(billData.getString("id")));
                }
                QFilter qf = new QFilter("id", "in", idList);
                OpenFormUtil.openListPage((IFormView)this.getView(), (String)pageKey, (ShowType)ShowType.MainNewTabPage, null, (QFilter)qf, null);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject billObj;
        DynamicObjectCollection dyns;
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (SUPPLIER.equals(fieldKey)) {
            QFilter supFilter = new QFilter("auditstatus", "in", (Object)"C");
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"srm_blackenterprise", (String)"id,name", (QFilter[])new QFilter[]{supFilter});
            if (Objects.isNull(dynamicObjects)) {
                return;
            }
            List supplierNames = dynamicObjects.stream().map(x -> x.getString("name")).filter(key -> StringUtils.isNotBlank((CharSequence)key)).collect(Collectors.toList());
            if (Objects.nonNull(supplierNames) && supplierNames.size() > 0) {
                QFilter filter = new QFilter("name", "not in", supplierNames);
                showParameter.getListFilterParameter().getQFilters().add(filter);
            }
        } else if ("group".equals(fieldKey)) {
            DynamicObject aptitudeBill = this.getModel().getDataEntity();
            DynamicObject purorg = aptitudeBill.getDynamicObject("org");
            SrmSupplierGroup.beforeF7Select((BeforeF7SelectEvent)beforeF7SelectEvent, purorg == null ? null : Long.valueOf(purorg.getLong("id")));
        } else if ("category".equals(fieldKey)) {
            String level;
            GroupStandardUtil.getMaterialGroupStandard((ListShowParameter)showParameter, (String)"srm");
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (SrmCategoryConfigUtil.isCategory((DynamicObject)org).booleanValue() && (level = SrmCategoryConfigUtil.getCategoryLeve((DynamicObject)org)) != null && !level.equals("")) {
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("level", "=", (Object)Integer.valueOf(level)));
            }
        } else if ("entertype".equals(fieldKey)) {
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            showParameter.getListFilterParameter().getQFilters().add(filter);
        } else if ("material".equals(fieldKey)) {
            DynamicObjectCollection groups;
            GroupStandardUtil.getMaterialGroupStandard((ListShowParameter)showParameter, (String)"srm");
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            String level = SrmCategoryConfigUtil.getCategoryLeve((DynamicObject)org);
            if (StringUtils.isNotEmpty((CharSequence)level) && StringUtils.isNumeric((CharSequence)level) && !CollectionUtils.isEmpty((Collection)(groups = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("level", "=", (Object)Integer.valueOf(level))})))) {
                List ids = groups.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                QFilter filter = new QFilter("group.id", "in", ids);
                showParameter.getListFilterParameter().getQFilters().add(filter);
            }
        } else if ("accessnode".equals(fieldKey) && (dyns = (billObj = this.getModel().getDataEntity(true)).getDynamicObjectCollection(SrmConstant.ENTRY_NODE)) != null && !dyns.isEmpty()) {
            ArrayList<Long> numbers = new ArrayList<Long>(dyns.size());
            for (DynamicObject dyn : dyns) {
                DynamicObject temp = dyn.getDynamicObject("accessnode");
                if (temp == null) continue;
                numbers.add(temp.getLong("id"));
            }
            if (!numbers.isEmpty()) {
                showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter filter = new QFilter("id", "not in", numbers);
                showParameter.getListFilterParameter().getQFilters().add(filter);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModel().getValue("type").equals("0")) {
            OperationServiceHelper.executeOperate((String)"save", (String)"srm_aptitudeexam", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, (OperateOption)OperateOption.create());
        }
        this.setMetaEntryFieldEditIsMustInput("entryentity1", "issatisfied");
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        boolean ischgflow = this.getModel().getDataEntity(true).getBoolean("ischgflow");
        if (enableNewAccessFlow) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"isscene", "issample", "ismaterial", "isapprove"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"ispurorg", "iscategory", "hasscene", "hassample", "hasmaterial", "hasapprove"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"pl_accessnode", "isautopush"});
            this.getView().setVisible(Boolean.valueOf(ischgflow), new String[]{"bar_accesssnode"});
            int size = this.getModel().getDataEntity(true).getDynamicObjectCollection(SrmConstant.ENTRY_NODE).getRowCount();
            for (int rowindex = 0; rowindex < size; ++rowindex) {
                this.getView().setEnable(Boolean.valueOf(ischgflow), rowindex, new String[]{"accessnode"});
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"isscene", "issample", "ismaterial", "isapprove"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"ispurorg", "iscategory", "hasscene", "hassample", "hasmaterial", "hasapprove"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"pl_accessnode", "isautopush"});
        }
    }

    private void setEntryEntityEnable() {
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        super.propertyChanged(arg0);
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        String propertyName = arg0.getProperty().getName();
        String categorytype = "";
        switch (propertyName) {
            case "supplier": {
                this.setBillEntryFromSupplier();
                this.updateType();
                this.updateAllEntryOrgAndCategoryStatus();
                this.getView().updateView();
                break;
            }
            case "category": {
                DynamicObject[] pbdaptitudestdconfigs;
                long categoryId = SrmCommonUtil.getPkValue((DynamicObject)arg0.getChangeSet()[0].getDataEntity().getDynamicObject("category"));
                categorytype = this.getModel().getEntryRowEntity("entryentity", rowIndex).getString("categorytype");
                if (categorytype.equals("B")) {
                    this.updateOrgAndCategoryOrMaterialStatus("B", rowIndex, categoryId);
                }
                DynamicObjectCollection entrydyos = this.getModel().getEntryEntity("entryentity");
                DynamicObject changedrow = (DynamicObject)entrydyos.get(arg0.getChangeSet()[0].getRowIndex());
                DynamicObjectCollection targetentrydyos = this.getModel().getEntryEntity("entryentity1");
                DynamicObject catedyo = changedrow.getDynamicObject("category");
                String selectfiled = "evafactorconfig,assesscontent,category,target,categorynote";
                String orgid = ((DynamicObject)this.getModel().getValue("org")).getString("id");
                for (DynamicObject pbdaptitudestdconfig : pbdaptitudestdconfigs = BusinessDataServiceHelper.load((String)"pbd_aptitudestdconfig", (String)selectfiled, (QFilter[])new QFilter[]{new QFilter("createorg.id", "=", (Object)Long.valueOf(orgid)).and(new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C")))})) {
                    DynamicObjectCollection configcolls = pbdaptitudestdconfig.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entryrow : configcolls) {
                        DynamicObject category = entryrow.getDynamicObject("category");
                        if (category == null || catedyo == null || !catedyo.getString("id").equals(category.getString("id"))) continue;
                        DynamicObject newcate = targetentrydyos.addNew();
                        newcate.set("evafactorconfig", (Object)pbdaptitudestdconfig.getDynamicObject("evafactorconfig"));
                        newcate.set("assesscontent", (Object)pbdaptitudestdconfig.getString("assesscontent"));
                        newcate.set("examcategory", (Object)entryrow.getDynamicObject("category"));
                        newcate.set("target", (Object)entryrow.getString("target"));
                        newcate.set("examremark", (Object)entryrow.getString("categorynote"));
                    }
                }
                this.getView().updateView("entryentity1");
                break;
            }
            case "taxrateid": {
                if (!Objects.isNull(this.getModel().getValue(TAXRATEID))) break;
                this.getModel().setValue("taxrate", null);
                break;
            }
            case "categorytype": {
                categorytype = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(rowIndex)).getString("categorytype");
                if (!StringUtils.isBlank((CharSequence)categorytype)) break;
                this.getModel().setValue("category", null, rowIndex);
                this.getModel().setValue("material", null, rowIndex);
                break;
            }
            case "material": {
                DynamicObject materialObj = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(rowIndex)).getDynamicObject("material");
                if (materialObj != null) {
                    Long materialId = materialObj.getLong("id");
                    DynamicObject materialDyo = QueryServiceHelper.queryOne((String)"bd_materialgroupdetail", (String)"group.id", (QFilter[])new QFilter[]{new QFilter("standard.number", "=", (Object)"JBFLBZ"), new QFilter("material.id", "=", (Object)materialId)});
                    this.getModel().setValue("categorytype", (Object)"A", rowIndex);
                    if (materialDyo != null) {
                        Long groupId = materialDyo.getLong("group.id");
                        DynamicObject mateGroup = BusinessDataServiceHelper.loadSingle((String)"bd_materialgroup", (String)"fullname,masterid,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)groupId)});
                        this.getModel().setValue("category", (Object)mateGroup, rowIndex);
                    }
                    this.updateOrgAndCategoryOrMaterialStatus("A", rowIndex, materialId);
                    break;
                }
                this.getModel().setValue("category", null, rowIndex);
                break;
            }
            case "entertype": {
                IDataModel model = this.getModel();
                DynamicObject billObj = this.getModel().getDataEntity(true);
                DynamicObject entertype = billObj.getDynamicObject("entertype");
                if (entertype == null) {
                    model.deleteEntryData(SrmConstant.ENTRY_NODE);
                } else {
                    boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
                    DynamicObject info = BusinessDataServiceHelper.loadSingle((String)"srm_biztype", (String)"ischgflow,isaptitude,isscene,issample,ismaterial,isapprove,entryentity.accessnode", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)entertype.getLong("id"))});
                    model.setValue("ischgflow", (Object)info.getBoolean("ischgflow"));
                    model.setValue("isscene", (Object)info.getBoolean("isscene"));
                    model.setValue("issample", (Object)info.getBoolean("issample"));
                    model.setValue("ismaterial", (Object)info.getBoolean("ismaterial"));
                    model.setValue("isapprove", (Object)info.getBoolean("isapprove"));
                    model.setValue("entertype", (Object)entertype.getLong("id"));
                    if (enableNewAccessFlow) {
                        DynamicObjectCollection accessnodes = info.getDynamicObjectCollection("entryentity");
                        model.deleteEntryData(SrmConstant.ENTRY_NODE);
                        TableValueSetter vs = new TableValueSetter(new String[0]);
                        int rowindex = 0;
                        for (DynamicObject dyn : accessnodes) {
                            DynamicObject node = dyn.getDynamicObject("accessnode");
                            String number = node.getString("bizobject_id");
                            if ("srm_aptitudeexam".equals(number)) continue;
                            vs.set("accessnode", (Object)node.getLong("id"), rowindex);
                            ++rowindex;
                        }
                        AbstractFormDataModel modelvs = (AbstractFormDataModel)model;
                        modelvs.batchCreateNewEntryRow("entry_node", vs);
                    }
                }
                this.getView().updateView();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.setMetaEntryFieldEditIsMustInput("entryentity1", "issatisfied");
    }

    private void updateType() {
        DynamicObject supplier = this.getModel().getDataEntity(true).getDynamicObject(SUPPLIER);
        if (supplier != null) {
            DynamicObject certifiapply = supplier.getDynamicObject("certifiapply");
            String regtype = supplier.getString("regtype");
            DynamicObjectCollection curcateentry = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            if (certifiapply != null) {
                this.getModel().setValue("type", (Object)"0");
                this.getModel().setValue("certifiapply_id", (Object)supplier.getDynamicObject("certifiapply").getLong("id"));
                String billno = certifiapply.getString("number");
                DynamicObject certifiapplybill = BusinessDataServiceHelper.loadSingle((String)"srm_certificationapply", (String)"category,material,categorytype", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
                DynamicObjectCollection cateentry = certifiapplybill.getDynamicObjectCollection("categoryentity");
                curcateentry.clear();
                this.getModel().getDataEntity().getDynamicObjectCollection("entryentity1").clear();
                String suppliernumber = this.getModel().getDataEntity(true).getString("supplier.number");
                DynamicObject dyo = QueryServiceHelper.queryOne((String)"srm_supplier", (String)"auditstatus", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)suppliernumber)});
                String auditstatus = dyo.getString("auditstatus");
                String type = this.getModel().getDataEntity(true).getString("type");
                if (!auditstatus.equals("Z") && ("0".equals(type) || "0".equals(regtype))) {
                    for (DynamicObject caterow : cateentry) {
                        DynamicObject currow = curcateentry.addNew();
                        currow.set("category", (Object)caterow.getDynamicObject("category"));
                        currow.set("orgstatus", (Object)"9");
                        currow.set("categorytype", (Object)caterow.getString("categorytype"));
                        currow.set("material", (Object)caterow.getDynamicObject("material"));
                        currow.set("categorystatus", (Object)"9");
                        currow.set("isenter", (Object)"1");
                    }
                }
                this.getView().updateView();
            } else {
                curcateentry.clear();
                this.getModel().setValue("type", (Object)("0".equals(regtype) ? "0" : "1"));
                this.getModel().setValue("certifiapply", null);
            }
        }
    }

    private void updateAllEntryOrgAndCategoryStatus() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject dyn = this.getModel().getEntryRowEntity("entryentity", i);
            if (dyn == null) continue;
            DynamicObject category = dyn.getDynamicObject("category");
            DynamicObject material = dyn.getDynamicObject("material");
            String categorytype = dyn.getString("categorytype");
            if (categorytype == null) continue;
            if (categorytype.equals("B")) {
                if (category == null) continue;
                this.updateOrgAndCategoryOrMaterialStatus("B", i, (Long)category.getPkValue());
                continue;
            }
            if (material == null || !categorytype.equals("A")) continue;
            this.updateOrgAndCategoryOrMaterialStatus("A", i, (Long)material.getPkValue());
        }
    }

    private void updateOrgAndCategoryOrMaterialStatus(String type, int currentRow, long categoryOrMaterialId) {
        long orgId;
        DynamicObject model = this.getModel().getDataEntity(true);
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)model.getDynamicObject(SUPPLIER));
        DynamicObject orgObj = SrmCategoryLibUtil.querySupplierCategory((long)supplierId, (long)(orgId = SrmCommonUtil.getPkValue((DynamicObject)model.getDynamicObject("org"))), (long)0L);
        if (orgObj == null) {
            this.getModel().setValue("orgstatus", (Object)SrmCategoryEnum.ONGOING.getVal(), currentRow);
        } else {
            this.getModel().setValue("orgstatus", orgObj.get("auditstatus"), currentRow);
        }
        DynamicObject obj = SrmCategoryLibUtil.querySupplierCategoryOrMaterial((long)supplierId, (long)orgId, (long)categoryOrMaterialId, (String)type);
        if (obj == null) {
            this.getModel().setValue("categorystatus", (Object)SrmCategoryEnum.ONGOING.getVal(), currentRow);
            this.getModel().setValue("isenter", (Object)1, currentRow);
        } else {
            String auditStatus = obj.getString("auditstatus");
            this.getModel().setValue("categorystatus", (Object)auditStatus, currentRow);
            if (SrmCategoryEnum.QUITED.getVal().equals(auditStatus) || SrmCategoryEnum.INVALID.getVal().equals(auditStatus)) {
                this.getModel().setValue("isenter", (Object)1, currentRow);
            } else {
                this.getModel().setValue("isenter", (Object)0, currentRow);
            }
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        changeSet[0].getNewValue();
    }

    private void setBillEntryFromSupplier() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject(SUPPLIER));
        if (supplierId == 0L) {
            return;
        }
        DynamicObject supplierObj = BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)"srm_supplier");
        if (supplierObj == null) {
            return;
        }
        Long groupId = supplierObj.getLong("group_id");
        String auditstatus = supplierObj.getString("auditstatus");
        if (groupId != null && groupId != 0L && (SrmSupplierStatusEnum.SUCCESS.getValue().equals(auditstatus) || SrmSupplierStatusEnum.APTITUDE.getValue().equals(auditstatus) || SrmSupplierStatusEnum.UNAPROVE.getValue().equals(auditstatus))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"group"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"group"});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.setValue("bizpartner", (Object)supplierObj.getLong("bizpartner_id"));
        model.deleteEntryData("entry_bank");
        DynamicObjectCollection bankEntries = supplierObj.getDynamicObjectCollection("entry_bank");
        if (bankEntries == null || bankEntries.size() == 0) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < bankEntries.size(); ++i) {
            DynamicObject entry = (DynamicObject)bankEntries.get(i);
            String accounttype = entry.getString("accounttype");
            String account = entry.getString("account");
            String accountname = entry.getString("accountname");
            DynamicObject bank = entry.getDynamicObject("bank");
            DynamicObject curr = entry.getDynamicObject("acccurr");
            boolean isdefault = entry.getBoolean("isdefault");
            String banknote = entry.getString("banknote");
            vs.set("seq", (Object)(i + 1), i);
            vs.set("accounttype", (Object)accounttype, i);
            vs.set("account", (Object)account, i);
            vs.set("accountname", (Object)accountname, i);
            if (bank != null) {
                vs.set("bank", (Object)bank.getLong("id"), i);
            }
            if (curr != null) {
                vs.set("acccurr", (Object)curr.getLong("id"), i);
            }
            vs.set("isdefault", (Object)isdefault, i);
            vs.set("banknote", (Object)banknote, i);
        }
        model.batchCreateNewEntryRow("entry_bank", vs);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        if (enableNewAccessFlow && ("save".equals(operateKey) || "submit".equals(operateKey))) {
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            AccessNodeUtil.sortAccessNode((DynamicObject)dynamicObject, (String)SrmConstant.ENTRY_NODE, (boolean)false);
            this.getView().updateView();
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        switch (key) {
            case "bar_save": 
            case "barsubmit": {
                this.deleteInvalidRows();
                break;
            }
            case "bar_supinfo": {
                DynamicObject supplier = this.getModel().getDataEntity().getDynamicObject(SUPPLIER);
                if (supplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4f9b\u5e94\u5546\u201d\u540e\u518d\u8fdb\u884c\u67e5\u8be2\u3002", (String)"SrmAptitudeExamEdit_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    break;
                }
                OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"srm_supplierreg", (Object)supplier.getPkValue(), (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
                break;
            }
        }
    }

    private void deleteInvalidRows() {
        IDataModel entryOp = this.getModel();
        DynamicObjectCollection targetrows = this.getModel().getEntryEntity("entryentity1");
        HashSet<String> isrepeatset = new HashSet<String>(targetrows.size() << 1);
        ArrayList<Integer> delIndex = new ArrayList<Integer>(10);
        for (int j = 0; j < targetrows.size(); ++j) {
            DynamicObject targetrow = (DynamicObject)targetrows.get(j);
            if (targetrow.getDynamicObject("examcategory") != null && targetrow.getDynamicObject("evafactorconfig") != null) {
                String cateandevaconfig = targetrow.getDynamicObject("examcategory").getString("id") + targetrow.getDynamicObject("evafactorconfig").getString("id");
                if (isrepeatset.contains(cateandevaconfig) || StringUtils.isBlank((CharSequence)cateandevaconfig)) {
                    delIndex.add(j);
                    continue;
                }
                isrepeatset.add(cateandevaconfig);
                continue;
            }
            delIndex.add(j);
        }
        int[] delRepeatIndexRows = new int[delIndex.size()];
        for (int j = 0; j < delIndex.size(); ++j) {
            delRepeatIndexRows[j] = (Integer)delIndex.get(j);
        }
        entryOp.deleteEntryRows("entryentity1", delRepeatIndexRows);
    }

    public void beforeBindData(EventObject e) {
        DynamicObjectCollection entrycate;
        super.beforeBindData(e);
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (!SrmCategoryConfigUtil.isCategory((DynamicObject)org).booleanValue()) {
            if (Objects.nonNull(org)) {
                Long orgid = org.getLong("id");
                String selectfiled = "evafactorconfig,assesscontent,category,target,categorynote";
                DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"pbd_aptitudestdconfig", (String)selectfiled, (QFilter[])new QFilter[]{new QFilter("createorg.id", "=", (Object)orgid).and(new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C")))});
                DynamicObjectCollection entrycolls = this.getModel().getEntryEntity("entryentity1");
                if (entrycolls.size() == 0) {
                    for (DynamicObject dyo : dyos) {
                        DynamicObjectCollection entrydyos = dyo.getDynamicObjectCollection("entryentity");
                        if (entrydyos.size() == 0) continue;
                        DynamicObject entrydyo = (DynamicObject)entrydyos.get(0);
                        DynamicObject newentryrow = entrycolls.addNew();
                        newentryrow.set("evafactorconfig", (Object)dyo.getDynamicObject("evafactorconfig"));
                        newentryrow.set("assesscontent", (Object)dyo.getString("assesscontent"));
                        newentryrow.set("target", (Object)entrydyo.getString("target"));
                        newentryrow.set("examremark", (Object)entrydyo.getString("categorynote"));
                    }
                }
            }
        } else if (this.getModel().getValue("type").equals("0")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
            entrycate = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entrycate.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"category"});
            }
            if (Objects.nonNull(org)) {
                Long orgid = org.getLong("id");
                String selectfiled = "evafactorconfig,assesscontent,category,target,categorynote";
                DynamicObject[] pbdaptitudestdconfigs = BusinessDataServiceHelper.load((String)"pbd_aptitudestdconfig", (String)selectfiled, (QFilter[])new QFilter[]{new QFilter("createorg.id", "=", (Object)orgid).and(new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C")))});
                DynamicObjectCollection entrydyos = this.getModel().getEntryEntity("entryentity");
                HashSet<String> entrycateidset = new HashSet<String>(entrydyos.size() << 1);
                DynamicObjectCollection targetentrydyos = this.getModel().getEntryEntity("entryentity1");
                if (entrydyos.size() != 0 && targetentrydyos.size() == 0) {
                    for (DynamicObject entrydyo : entrydyos) {
                        DynamicObject category = entrydyo.getDynamicObject("category");
                        if (category == null) continue;
                        entrycateidset.add(category.getString("id"));
                    }
                    for (DynamicObject pbdaptitudestdconfig : pbdaptitudestdconfigs) {
                        DynamicObjectCollection configcolls = pbdaptitudestdconfig.getDynamicObjectCollection("entryentity");
                        for (DynamicObject entryrow : configcolls) {
                            DynamicObject category = entryrow.getDynamicObject("category");
                            if (category == null || !entrycateidset.contains(category.getString("id"))) continue;
                            DynamicObject newcate = targetentrydyos.addNew();
                            newcate.set("evafactorconfig", (Object)pbdaptitudestdconfig.getDynamicObject("evafactorconfig"));
                            newcate.set("assesscontent", (Object)pbdaptitudestdconfig.getString("assesscontent"));
                            newcate.set("examcategory", (Object)entryrow.getDynamicObject("category"));
                            newcate.set("target", (Object)entryrow.getString("target"));
                            newcate.set("examremark", (Object)entryrow.getString("categorynote"));
                        }
                    }
                }
            }
        }
        if (this.getModel().getValue("type").equals("1")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"org"});
            entrycate = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entrycate.size(); ++i) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"category"});
            }
        }
    }

    private void setMetaEntryFieldEditIsMustInput(String entryName, String ... FieldName) {
        if (FieldName == null) {
            return;
        }
        int size = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryName).getRowCount();
        boolean flag = false;
        if (size != 0) {
            flag = true;
        }
        for (int i = 0; i < FieldName.length; ++i) {
            FieldEdit fieldEdit = (FieldEdit)this.getControl(FieldName[i]);
            fieldEdit.setMustInput(flag);
        }
    }
}

