/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.SrmCategoryEnum;
import kd.scm.common.sdk.sdkutil.GroupStandardUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillEditUtil;
import kd.scm.srm.common.SrmCategoryLibUtil;
import kd.scm.srm.common.SrmCommUtil;

public class SrmCategoryChgEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener,
EntryGridBindDataListener {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void afterCreateNewData(EventObject eventobject) {
        super.afterCreateNewData(eventobject);
        IDataModel model = this.getModel();
        if (!"A".equals(model.getValue("auditstatus"))) {
            model.setValue("auditstatus", (Object)"A");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map paraMap = SrmCommonUtil.getSrmParameter();
        Object initiator = this.getModel().getValue("initiator");
        if (initiator == null || initiator.toString().equals("")) {
            this.getModel().setValue("initiator", (Object)"0");
        }
        if (((Boolean)paraMap.get("iscategory")).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"orgstatus"});
        }
        SrmCategoryLibUtil.setEnableByType((IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        int currentRowIdex = e.getChangeSet()[0].getRowIndex();
        switch (propertyName) {
            case "supplier": {
                DynamicObject supplier = (DynamicObject)model.getValue("supplier");
                if (Objects.isNull(supplier)) {
                    DynamicObjectCollection rows = model.getEntryEntity("entryentity");
                    if (Objects.nonNull(rows) && rows.size() != 0) {
                        rows.clear();
                    }
                    this.getView().updateView();
                } else {
                    model.setValue("bizpartner", (Object)supplier.getLong("bizpartner_id"));
                }
                SrmBillEditUtil.setCategoryChg((AbstractFormDataModel)((AbstractFormDataModel)model));
                SrmCategoryLibUtil.setEnableByType((IFormView)this.getView());
                break;
            }
            case "org": {
                SrmBillEditUtil.setCategoryChg((AbstractFormDataModel)((AbstractFormDataModel)model));
                SrmCategoryLibUtil.setEnableByType((IFormView)this.getView());
                break;
            }
            case "category": {
                DynamicObject newCategory = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (Objects.nonNull(newCategory)) {
                    this.setStatus(model, e, "B", "addCate");
                }
                String addCate = this.getPageCache().get("addCate");
                DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                Object categorytype = ((DynamicObject)entry.get(currentRowIdex)).get("categorytype");
                if ("true".equals(addCate) || !"B".equals(categorytype)) break;
                Object org = this.getModel().getDataEntity().get("org.id");
                Object supplier1 = this.getModel().getDataEntity().get("supplier.id");
                Object category = ((DynamicObject)entry.get(currentRowIdex)).get("category.id");
                DynamicObject[] supcategorys = BusinessDataServiceHelper.load((String)"srm_supcategory", (String)"id,categorytype,supplier,org,category,material,auditstatus,effectdate,expirydate,issourcelist", (QFilter[])new QFilter[]{new QFilter("org", "=", org).and("supplier", "=", supplier1).and("category", "=", category).and("auditstatus", "!=", (Object)SrmCategoryEnum.QUITED.getVal()).and("categorytype", "=", (Object)"B").and("auditstatus", "!=", (Object)SrmCategoryEnum.INVALID.getVal())});
                if (supcategorys.length <= 0) break;
                this.addEntry(supcategorys, currentRowIdex, entry);
                this.getView().updateView("entryentity");
                break;
            }
            case "categorytype": {
                model.setValue("material", null, currentRowIdex);
                model.setValue("category", null, currentRowIdex);
                model.setValue("note", null, currentRowIdex);
                SrmCategoryLibUtil.setEnableByType((IFormView)this.getView());
                break;
            }
            case "material": {
                DynamicObject group;
                DynamicObject newMaterial = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (!Objects.nonNull(newMaterial)) break;
                DynamicObjectCollection entryentity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(currentRowIdex);
                if (Objects.nonNull(dynamicObject) && !"A".equals(dynamicObject.getString("categorytype"))) {
                    model.beginInit();
                    dynamicObject.set("categorytype", (Object)"A");
                    model.endInit();
                    this.getView().updateView("categorytype", currentRowIdex);
                }
                if (Objects.nonNull(group = newMaterial.getDynamicObject("group"))) {
                    Object pkValue = group.getPkValue();
                    model.setValue("category", pkValue, currentRowIdex);
                }
                this.setStatus(model, e, "A", "addMaterial");
                String addMaterial = this.getPageCache().get("addMaterial");
                if ("true".equals(addMaterial) || !Objects.nonNull(dynamicObject) || !"A".equals(dynamicObject.getString("categorytype"))) break;
                Object org = this.getModel().getDataEntity().get("org.id");
                Object supplier1 = this.getModel().getDataEntity().get("supplier.id");
                Object material = ((DynamicObject)entryentity.get(currentRowIdex)).get("material.id");
                DynamicObject[] supcategorys = BusinessDataServiceHelper.load((String)"srm_supcategory", (String)"id,categorytype,supplier,org,category,material,auditstatus,effectdate,expirydate,issourcelist", (QFilter[])new QFilter[]{new QFilter("org", "=", org).and("supplier", "=", supplier1).and("material", "=", material).and("auditstatus", "!=", (Object)SrmCategoryEnum.QUITED.getVal()).and("categorytype", "=", (Object)"A").and("auditstatus", "!=", (Object)SrmCategoryEnum.INVALID.getVal())});
                if (supcategorys.length <= 0) break;
                this.addEntry(supcategorys, currentRowIdex, entryentity);
                this.getView().updateView("entryentity");
                break;
            }
            case "categorystatus": {
                DynamicObject supcategory;
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (!"1".equals(newValue) && Objects.nonNull(supcategory = (DynamicObject)this.getModel().getValue("supcategory", currentRowIdex))) {
                    Date expirydate = supcategory.getDate("expirydate");
                    Date effectdate = supcategory.getDate("effectdate");
                    this.getModel().setValue("expirydate", (Object)expirydate, currentRowIdex);
                    this.getModel().setValue("effectdate", (Object)effectdate, currentRowIdex);
                }
                SrmCategoryLibUtil.setEnableByType((IFormView)this.getView());
                break;
            }
            case "effectdate": 
            case "expirydate": {
                DynamicObjectCollection dynamicObjects = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(currentRowIdex);
                Date datefrom = dynamicObject.getDate("effectdate");
                Date dateto = dynamicObject.getDate("expirydate");
                if (!Objects.nonNull(dateto) || !Objects.nonNull(datefrom) || dateto.compareTo(datefrom) > 0) break;
                this.getModel().setValue(propertyName, null, currentRowIdex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5931\u6548\u65e5\u671f\u201d\u5fc5\u987b\u5927\u4e8e\u201c\u751f\u6548\u65e5\u671f\u201d,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SrmCategoryChgEdit_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        switch (key) {
            case "bar_save": 
            case "barsubmit": 
            case "bar_unsubmit": {
                if (key.equals("bar_unsubmit")) {
                    Object pk = this.getModel().getDataEntity().getPkValue();
                    DynamicObject dyo = QueryServiceHelper.queryOne((String)"srm_categorychg", (String)"initiator", (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
                    Boolean ok = true;
                    if (dyo.get("initiator") != null && dyo.get("initiator").equals("1")) {
                        ok = false;
                    }
                    if (!ok.booleanValue()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u64a4\u9500\u53d1\u8d77\u65b9\u4e3a\u201c\u4f9b\u5e94\u5546\u201d\u7684\u6570\u636e\uff0c\u8bf7\u8c03\u6574\u3002", (String)"SrmCategoryChgEdit_1", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                }
                this.deleteInvalidRows(this.getModel().getDataEntity(true));
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        BasedataEdit categoryEdit = (BasedataEdit)this.getView().getControl("category");
        categoryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        categoryEdit.addAfterF7SelectListener(this::afterF7Select);
        BasedataEdit materialEdit = (BasedataEdit)this.getView().getControl("material");
        materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        materialEdit.addAfterF7SelectListener(this::afterF7Select);
        SrmCommUtil.addValidatePreValueBeforeF7Listener((AbstractFormPlugin)this, (String)"supplier", (String)"org");
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        QFilter filter;
        Set ids;
        Map resultMap;
        HashSet<Long> existIds;
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"category")) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            GroupStandardUtil.getMaterialGroupStandard((ListShowParameter)showParameter, (String)"srm");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            existIds = new HashSet<Long>(entryEntity.size());
            for (DynamicObject row : entryEntity) {
                if (!"B".equals(row.getString("categorytype"))) continue;
                existIds.add(row.getLong("category_id"));
            }
            int row = e.getRow();
            boolean addCate = false;
            if (SrmCategoryEnum.ADD.getVal().equals(((DynamicObject)entryEntity.get(row)).getString("categorystatus_old"))) {
                addCate = true;
                this.getPageCache().put("addCate", "true");
            } else {
                this.getPageCache().put("addCate", "false");
            }
            resultMap = SrmBillEditUtil.getSupOrgCategoryId((IDataModel)this.getModel());
            if (((Boolean)resultMap.get("succed")).booleanValue()) {
                ids = (Set)resultMap.get("message");
                if (addCate) {
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", existIds));
                } else {
                    if (ids.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u54c1\u7c7b\u5e93\u6ca1\u6709\u53ef\u53d8\u66f4\u7684\u54c1\u7c7b\u3002", (String)"SrmCategoryChgEdit_2", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    filter = new QFilter("id", "in", (Object)ids);
                    showParameter.getListFilterParameter().setFilter(filter.and("id", "not in", existIds));
                }
            } else {
                this.getView().showTipNotification(resultMap.get("message").toString());
                e.setCancel(true);
            }
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"material")) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            GroupStandardUtil.getMaterialGroupStandard((ListShowParameter)showParameter, (String)"srm");
            existIds = new HashSet(entryEntity.size());
            for (DynamicObject row : entryEntity) {
                if (!"A".equals(row.getString("categorytype"))) continue;
                existIds.add(row.getLong("material_id"));
            }
            int row = e.getRow();
            boolean addMaterial = false;
            if (SrmCategoryEnum.ADD.getVal().equals(((DynamicObject)entryEntity.get(row)).getString("categorystatus_old"))) {
                addMaterial = true;
                this.getPageCache().put("addMaterial", "true");
            } else {
                this.getPageCache().put("addMaterial", "false");
            }
            resultMap = SrmBillEditUtil.getSupOrgMaterialId((IDataModel)this.getModel());
            if (((Boolean)resultMap.get("succed")).booleanValue()) {
                ids = (Set)resultMap.get("message");
                if (addMaterial) {
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", existIds));
                } else {
                    if (ids.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u54c1\u7c7b\u5e93\u6ca1\u6709\u53ef\u53d8\u66f4\u7684\u7269\u6599\u3002", (String)"SrmCategoryChgEdit_3", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    filter = new QFilter("id", "in", (Object)ids);
                    showParameter.getListFilterParameter().setFilter(filter.and("id", "not in", existIds));
                }
            } else {
                this.getView().showTipNotification(resultMap.get("message").toString());
                e.setCancel(true);
            }
        }
    }

    private void deleteInvalidRows(DynamicObject billObj) {
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return;
        }
        Iterator ite = rows.iterator();
        while (ite.hasNext()) {
            DynamicObject obj = (DynamicObject)ite.next();
            Date effectDataNew = obj.getDate("effectdate");
            Date expiryDateNew = obj.getDate("expirydate");
            String statusNew = obj.getString("categorystatus");
            DynamicObject supcategory = obj.getDynamicObject("supcategory");
            String statusOld = obj.getString("categorystatus_old");
            long categoryId = obj.getLong("category_id");
            if (effectDataNew == null || expiryDateNew == null || statusNew == null || "".equals(statusNew.trim()) || categoryId == 0L) {
                ite.remove();
                continue;
            }
            if (!Objects.nonNull(supcategory)) continue;
            Date effectDataOld = supcategory.getDate("effectdate");
            Date expiryDateOld = supcategory.getDate("expirydate");
            if (!Objects.nonNull(effectDataOld) || !Objects.nonNull(expiryDateOld) || !statusOld.equals(statusNew) || effectDataOld.compareTo(effectDataNew) != 0 || expiryDateOld.compareTo(expiryDateNew) != 0) continue;
            ite.remove();
        }
        this.getView().updateView();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        IBillView view = (IBillView)this.getView();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        int lastIndex = entryEntity.size();
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        switch (e.getOperateKey()) {
            case "addmaterialgroup": {
                if (!e.getOperationResult().isSuccess()) break;
                entryEntity.addNew();
                model.setValue("categorystatus_old", (Object)SrmCategoryEnum.ADD.getVal(), lastIndex);
                model.setValue("categorystatus", (Object)SrmCategoryEnum.VALID.getVal(), lastIndex);
                model.setValue("effectdate", (Object)TimeServiceHelper.today(), lastIndex);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    model.setValue("expirydate", (Object)simpleDateFormat.parse("2099-12-31"), lastIndex);
                }
                catch (ParseException e1) {
                    this.log.error("expirydate\u8bbe\u7f6e\u5931\u8d25" + e1.getMessage());
                }
                model.beginInit();
                model.setValue("categorytype", (Object)"B", lastIndex);
                model.endInit();
                view.updateView("entryentity");
                entryGrid.clearEntryState();
                entryGrid.selectRows(lastIndex);
                break;
            }
            case "changematerialgroup": {
                if (!e.getOperationResult().isSuccess()) break;
                entryEntity.addNew();
                model.setValue("categorytype", (Object)"B", lastIndex);
                view.updateView("entryentity");
                entryGrid.clearEntryState();
                entryGrid.selectRows(lastIndex);
                break;
            }
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        IBillView view = (IBillView)this.getView();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (!SrmCategoryEnum.ADD.getVal().equals(((DynamicObject)entryEntity.get(i)).getString("categorystatus_old"))) continue;
            view.setEnable(Boolean.valueOf(false), i, new String[]{"categorystatus"});
        }
        SrmCategoryLibUtil.setEnableByType((IFormView)this.getView());
        view.updateViewStatus();
    }

    private void setStatus(IDataModel model, PropertyChangedArgs e, String type, String cachKey) {
        DynamicObject obj = model.getDataEntity(true);
        int currentRow = e.getChangeSet()[0].getRowIndex();
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("supplier"));
        long orgId = SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("org"));
        long categoryId = SrmCommonUtil.getPkValue((DynamicObject)e.getChangeSet()[0].getDataEntity().getDynamicObject("category"));
        DynamicObjectCollection entryentity = obj.getDynamicObjectCollection("entryentity");
        DynamicObject dynamicObject = (DynamicObject)entryentity.get(currentRow);
        String statusOld = dynamicObject.getString("categorystatus_old");
        long materialId = dynamicObject.getLong("material_id");
        String categorytype = dynamicObject.getString("categorytype");
        if (type.equals(categorytype)) {
            if ("false".equals(this.getPageCache().get(cachKey))) {
                DynamicObject changeOrgObj = SrmCategoryLibUtil.getSupplierCategory((long)supplierId, (long)orgId, (long)categoryId, (long)materialId, (String)categorytype);
                if (changeOrgObj == null) {
                    model.setValue("categorystatus_old", (Object)SrmCategoryEnum.ONGOING.getVal(), currentRow);
                } else {
                    model.setValue("categorystatus_old", changeOrgObj.get("auditstatus"), currentRow);
                    if (!changeOrgObj.get("auditstatus").equals(SrmCategoryEnum.QUITED.getVal())) {
                        model.setValue("categorystatus", changeOrgObj.get("auditstatus"), currentRow);
                    }
                }
            } else {
                model.setValue("categorystatus_old", (Object)SrmCategoryEnum.ADD.getVal(), currentRow);
                model.setValue("categorystatus", (Object)SrmCategoryEnum.VALID.getVal(), currentRow);
                this.getView().setEnable(Boolean.valueOf(false), currentRow, new String[]{"categorystatus"});
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent args) {
        BasedataEdit source = (BasedataEdit)args.getSource();
        String key = source.getProperty().getName();
        if (key.equals("material")) {
            this.getPageCache().remove("addMaterial");
        } else if (key.equals("category")) {
            this.getPageCache().remove("addCate");
        }
        SrmCategoryLibUtil.setEnableByType((IFormView)this.getView());
    }

    private List<Long> queryStandMaterial() {
        DynamicObjectCollection materialDyos = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material.id", (QFilter[])new QFilter[]{new QFilter("standard.number", "=", (Object)"JBFLBZ")});
        ArrayList<Long> materialIds = new ArrayList<Long>(1024);
        if (!CollectionUtils.isEmpty((Collection)materialDyos)) {
            for (DynamicObject dyo : materialDyos) {
                Long materialNumber = dyo.getLong("material.id");
                materialIds.add(materialNumber);
            }
        }
        return materialIds;
    }

    private void addEntry(DynamicObject[] supcategorys, int currentRowIdex, DynamicObjectCollection entry) {
        for (int i = 0; i < supcategorys.length; ++i) {
            if (i == 0) {
                this.getModel().setValue("effectdate", (Object)supcategorys[i].getDate("effectdate"), currentRowIdex);
                this.getModel().setValue("expirydate", (Object)supcategorys[i].getDate("expirydate"), currentRowIdex);
                this.getModel().setValue("supcategory_id", supcategorys[i].get("id"), currentRowIdex);
                this.getModel().setValue("categorytype", supcategorys[i].get("categorytype"), currentRowIdex);
                this.getModel().setValue("categorystatus_old", supcategorys[i].get("auditstatus"), currentRowIdex);
                continue;
            }
            DynamicObject dynamicObject = entry.addNew();
            dynamicObject.set("effectdate", (Object)supcategorys[i].getDate("effectdate"));
            dynamicObject.set("expirydate", (Object)supcategorys[i].getDate("expirydate"));
            dynamicObject.set("supcategory_id", supcategorys[i].get("id"));
            dynamicObject.set("category", supcategorys[i].get("category"));
            dynamicObject.set("material", supcategorys[i].get("material"));
            dynamicObject.set("categorystatus", supcategorys[i].get("auditstatus"));
            dynamicObject.set("categorystatus_old", supcategorys[i].get("auditstatus"));
            dynamicObject.set("issourcelist", supcategorys[i].get("issourcelist"));
            dynamicObject.set("categorytype", supcategorys[i].get("categorytype"));
        }
    }
}

